/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.google.common.collect.ImmutableMap;

public enum SymbolJavaType {
    INT("int", "I"),
    INT_LIST("int[]", "[I");

    private static final ImmutableMap<String, SymbolJavaType> types;
    private final String typeName;
    private final String desc;

    private SymbolJavaType(String typeName, String desc) {
        this.typeName = typeName;
        this.desc = desc;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SymbolJavaType getEnum(String name2) {
        return types.get(name2);
    }

    static {
        ImmutableMap.Builder<String, SymbolJavaType> typesBuilder = ImmutableMap.builder();
        for (SymbolJavaType symbolJavaType : SymbolJavaType.values()) {
            typesBuilder.put(symbolJavaType.getTypeName(), symbolJavaType);
        }
        types = typesBuilder.build();
    }
}

