/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DisjointUnionMap<K, V>
implements Map<K, V> {
    private final Map<K, V> first;
    private final Map<K, V> second;
    private Set<K> keySet;
    private Set<Map.Entry<K, V>> entrySet;
    private Collection<V> values;

    public DisjointUnionMap(Map<K, V> first2, Map<K, V> second2) {
        Preconditions.checkArgument(Sets.intersection(first2.keySet(), second2.keySet()).isEmpty(), "Key sets are not disjoint.");
        this.first = first2;
        this.second = second2;
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.first.containsKey(key) || this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.first.containsValue(value) || this.second.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V result2 = this.first.get(key);
        if (result2 == null) {
            result2 = this.second.get(key);
        }
        return result2;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new UnionOfDisjointSets<K>(this.first.keySet(), this.second.keySet());
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnionOfDisjointSets<Map.Entry<K, V>>(this.first.entrySet(), this.second.entrySet());
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Concatenation<V>(this.first.values(), this.second.values());
        }
        return this.values;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static class UnionOfDisjointSets<E>
    extends Concatenation<E>
    implements Set<E> {
        public UnionOfDisjointSets(Set<E> first2, Set<E> second2) {
            super(first2, second2);
        }
    }

    private static class Concatenation<E>
    extends AbstractCollection<E> {
        private final Collection<E> first;
        private final Collection<E> second;

        public Concatenation(Collection<E> first2, Collection<E> second2) {
            this.first = first2;
            this.second = second2;
        }

        @Override
        public final int size() {
            return IntMath.saturatedAdd(this.first.size(), this.second.size());
        }

        @Override
        public final boolean isEmpty() {
            return this.first.isEmpty() && this.second.isEmpty();
        }

        @Override
        public final Iterator<E> iterator() {
            return Iterators.concat(this.first.iterator(), this.second.iterator());
        }

        @Override
        public final Stream<E> stream() {
            return Stream.concat(this.first.stream(), this.second.stream());
        }

        @Override
        public final Stream<E> parallelStream() {
            return Stream.concat(this.first.parallelStream(), this.second.parallelStream());
        }

        @Override
        public final boolean contains(Object object) {
            return this.first.contains(object) || this.second.contains(object);
        }

        @Override
        public final boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Concatenation that = (Concatenation)o2;
            return this.first.equals(that.first) && this.second.equals(that.second);
        }

        @Override
        public final int hashCode() {
            return this.first.hashCode() + this.second.hashCode();
        }

        @Override
        public final boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> newElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> oldElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeIf(Predicate<? super E> filter2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> elementsToKeep) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

