/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

class SvgGroupNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    protected final ArrayList<SvgNode> mChildren = new ArrayList();

    SvgGroupNode(SvgTree svgTree, Element docNode, String name2) {
        super(svgTree, docNode, name2);
    }

    @Override
    public SvgGroupNode deepCopy() {
        SvgGroupNode newInstance = new SvgGroupNode(this.getTree(), this.mDocumentElement, this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    @Override
    protected <T extends SvgGroupNode> void copyFrom(T from2) {
        super.copyFrom(from2);
        for (SvgNode child : from2.mChildren) {
            this.addChild(child.deepCopy());
        }
    }

    boolean resolveHref(SvgTree svgTree) {
        SvgNode referencedNode;
        String id2 = this.getHrefId();
        SvgNode svgNode = referencedNode = id2.isEmpty() ? null : svgTree.getSvgNodeFromId(id2);
        if (referencedNode == null) {
            if (id2.isEmpty() || !svgTree.isIdIgnored(id2)) {
                svgTree.logError("Referenced id not found", this.mDocumentElement);
            }
        } else {
            if (svgTree.getPendingUseSet().contains(referencedNode)) {
                return false;
            }
            SvgNode copiedNode = referencedNode.deepCopy();
            this.addChild(copiedNode);
            for (Map.Entry entry : this.mVdAttributesMap.entrySet()) {
                String key = (String)entry.getKey();
                copiedNode.fillPresentationAttributes(key, (String)entry.getValue());
            }
            this.fillEmptyAttributes(this.mVdAttributesMap);
            float x2 = Svg2Vector.parseFloatOrDefault(this.mDocumentElement.getAttribute("x"), 0.0f);
            float y2 = Svg2Vector.parseFloatOrDefault(this.mDocumentElement.getAttribute("y"), 0.0f);
            this.transformIfNeeded(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x2, y2));
        }
        return true;
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void replaceChild(SvgNode oldChild, SvgNode newChild) {
        int index2 = this.mChildren.indexOf(oldChild);
        if (index2 < 0) {
            throw new IllegalArgumentException("The child being replaced doesn't belong to this group");
        }
        this.mChildren.set(index2, newChild);
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "group: " + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + "  ");
        }
    }

    public SvgGroupNode findParent(SvgNode node) {
        for (SvgNode n2 : this.mChildren) {
            SvgGroupNode parent;
            if (n2 == node) {
                return this;
            }
            if (!n2.isGroupNode() || (parent = ((SvgGroupNode)n2).findParent(node)) == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p2 : this.mChildren) {
            p2.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void flatten(AffineTransform transform2) {
        for (SvgNode node : this.mChildren) {
            this.mStackedTransform.setTransform(transform2);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            node.flatten(this.mStackedTransform);
        }
    }

    @Override
    public void validate() {
        for (SvgNode node : this.mChildren) {
            node.validate();
        }
    }

    @Override
    public void writeXml(OutputStreamWriter writer, String indent) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXml(writer, indent);
        }
    }

    @Override
    public SvgNode.VisitResult accept(SvgNode.Visitor visitor) {
        SvgNode.VisitResult result2 = visitor.visit(this);
        if (result2 == SvgNode.VisitResult.CONTINUE) {
            for (SvgNode node : this.mChildren) {
                if (node.accept(visitor) != SvgNode.VisitResult.ABORT) continue;
                return SvgNode.VisitResult.ABORT;
            }
        }
        return result2 == SvgNode.VisitResult.SKIP_CHILDREN ? SvgNode.VisitResult.CONTINUE : result2;
    }

    @Override
    public void fillPresentationAttributes(String name2, String value) {
        super.fillPresentationAttributes(name2, value);
        for (SvgNode n2 : this.mChildren) {
            if (n2.mVdAttributesMap.containsKey(name2)) continue;
            n2.fillPresentationAttributes(name2, value);
        }
    }
}

