/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.VdPath;
import java.awt.geom.Path2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

class VdNodeRender {
    private static final Logger LOGGER = Logger.getLogger(VdNodeRender.class.getSimpleName());

    VdNodeRender() {
    }

    public static void createPath(@NotNull VdPath.Node[] nodes, @NotNull Path2D path) {
        float[] current2 = new float[6];
        char lastCmd = ' ';
        for (VdPath.Node node : nodes) {
            VdNodeRender.addCommand(path, current2, node.getType(), lastCmd, node.getParams());
            lastCmd = node.getType();
        }
    }

    private static void addCommand(@NotNull Path2D path, float[] current2, char cmd, char lastCmd, float[] val) {
        int incr = 2;
        float cx = current2[0];
        float cy = current2[1];
        float cpx = current2[2];
        float cpy = current2[3];
        float loopX = current2[4];
        float loopY = current2[5];
        switch (cmd) {
            case 'Z': 
            case 'z': {
                path.closePath();
                cx = loopX;
                cy = loopY;
            }
            case 'L': 
            case 'M': 
            case 'T': 
            case 'l': 
            case 'm': 
            case 't': {
                incr = 2;
                break;
            }
            case 'H': 
            case 'V': 
            case 'h': 
            case 'v': {
                incr = 1;
                break;
            }
            case 'C': 
            case 'c': {
                incr = 6;
                break;
            }
            case 'Q': 
            case 'S': 
            case 'q': 
            case 's': {
                incr = 4;
                break;
            }
            case 'A': 
            case 'a': {
                incr = 7;
            }
        }
        for (int k2 = 0; k2 < val.length; k2 += incr) {
            switch (cmd) {
                case 'm': {
                    cx += val[k2];
                    cy += val[k2 + 1];
                    if (k2 > 0) {
                        path.lineTo(cx, cy);
                        break;
                    }
                    path.moveTo(cx, cy);
                    loopX = cx;
                    loopY = cy;
                    break;
                }
                case 'M': {
                    cx = val[k2];
                    cy = val[k2 + 1];
                    if (k2 > 0) {
                        path.lineTo(cx, cy);
                        break;
                    }
                    path.moveTo(cx, cy);
                    loopX = cx;
                    loopY = cy;
                    break;
                }
                case 'l': {
                    path.lineTo(cx += val[k2], cy += val[k2 + 1]);
                    break;
                }
                case 'L': {
                    cx = val[k2];
                    cy = val[k2 + 1];
                    path.lineTo(cx, cy);
                    break;
                }
                case 'Z': 
                case 'z': {
                    path.closePath();
                    cx = loopX;
                    cy = loopY;
                    break;
                }
                case 'h': {
                    path.lineTo(cx += val[k2], cy);
                    break;
                }
                case 'H': {
                    path.lineTo(val[k2], cy);
                    cx = val[k2];
                    break;
                }
                case 'v': {
                    path.lineTo(cx, cy += val[k2]);
                    break;
                }
                case 'V': {
                    path.lineTo(cx, val[k2]);
                    cy = val[k2];
                    break;
                }
                case 'c': {
                    path.curveTo(cx + val[k2], cy + val[k2 + 1], cx + val[k2 + 2], cy + val[k2 + 3], cx + val[k2 + 4], cy + val[k2 + 5]);
                    cpx = cx + val[k2 + 2];
                    cpy = cy + val[k2 + 3];
                    cx += val[k2 + 4];
                    cy += val[k2 + 5];
                    break;
                }
                case 'C': {
                    path.curveTo(val[k2], val[k2 + 1], val[k2 + 2], val[k2 + 3], val[k2 + 4], val[k2 + 5]);
                    cx = val[k2 + 4];
                    cy = val[k2 + 5];
                    cpx = val[k2 + 2];
                    cpy = val[k2 + 3];
                    break;
                }
                case 's': {
                    boolean reflectCtrl = lastCmd == 'c' || lastCmd == 's' || lastCmd == 'C' || lastCmd == 'S';
                    path.curveTo(reflectCtrl ? (double)(2.0f * cx - cpx) : (double)cx, reflectCtrl ? (double)(2.0f * cy - cpy) : (double)cy, cx + val[k2], cy + val[k2 + 1], cx + val[k2 + 2], cy + val[k2 + 3]);
                    cpx = cx + val[k2];
                    cpy = cy + val[k2 + 1];
                    cx += val[k2 + 2];
                    cy += val[k2 + 3];
                    break;
                }
                case 'S': {
                    boolean reflectCtrl = lastCmd == 'c' || lastCmd == 's' || lastCmd == 'C' || lastCmd == 'S';
                    path.curveTo(reflectCtrl ? (double)(2.0f * cx - cpx) : (double)cx, reflectCtrl ? (double)(2.0f * cy - cpy) : (double)cy, val[k2], val[k2 + 1], val[k2 + 2], val[k2 + 3]);
                    cpx = val[k2];
                    cpy = val[k2 + 1];
                    cx = val[k2 + 2];
                    cy = val[k2 + 3];
                    break;
                }
                case 'q': {
                    path.quadTo(cx + val[k2], cy + val[k2 + 1], cx + val[k2 + 2], cy + val[k2 + 3]);
                    cpx = cx + val[k2];
                    cpy = cy + val[k2 + 1];
                    cx += val[k2 + 2];
                    cy += val[k2 + 3];
                    break;
                }
                case 'Q': {
                    path.quadTo(val[k2], val[k2 + 1], val[k2 + 2], val[k2 + 3]);
                    cx = val[k2 + 2];
                    cy = val[k2 + 3];
                    cpx = val[k2];
                    cpy = val[k2 + 1];
                    break;
                }
                case 't': {
                    boolean reflectCtrl = lastCmd == 'q' || lastCmd == 't' || lastCmd == 'Q' || lastCmd == 'T';
                    float tempReflectedX = reflectCtrl ? 2.0f * cx - cpx : cx;
                    float tempReflectedY = reflectCtrl ? 2.0f * cy - cpy : cy;
                    path.quadTo(tempReflectedX, tempReflectedY, cx + val[k2], cy + val[k2 + 1]);
                    cpx = tempReflectedX;
                    cpy = tempReflectedY;
                    cx += val[k2];
                    cy += val[k2 + 1];
                    break;
                }
                case 'T': {
                    boolean reflectCtrl = lastCmd == 'q' || lastCmd == 't' || lastCmd == 'Q' || lastCmd == 'T';
                    float tempReflectedX = reflectCtrl ? 2.0f * cx - cpx : cx;
                    float tempReflectedY = reflectCtrl ? 2.0f * cy - cpy : cy;
                    path.quadTo(tempReflectedX, tempReflectedY, val[k2], val[k2 + 1]);
                    cx = val[k2];
                    cy = val[k2 + 1];
                    cpx = tempReflectedX;
                    cpy = tempReflectedY;
                    break;
                }
                case 'a': {
                    VdNodeRender.drawArc(path, cx, cy, val[k2 + 5] + cx, val[k2 + 6] + cy, Math.abs(val[k2]), Math.abs(val[k2 + 1]), val[k2 + 2], val[k2 + 3] != 0.0f, val[k2 + 4] != 0.0f);
                    cpx = cx += val[k2 + 5];
                    cpy = cy += val[k2 + 6];
                    break;
                }
                case 'A': {
                    VdNodeRender.drawArc(path, cx, cy, val[k2 + 5], val[k2 + 6], Math.abs(val[k2]), Math.abs(val[k2 + 1]), val[k2 + 2], val[k2 + 3] != 0.0f, val[k2 + 4] != 0.0f);
                    cx = val[k2 + 5];
                    cy = val[k2 + 6];
                    cpx = cx;
                    cpy = cy;
                }
            }
            lastCmd = cmd;
        }
        current2[0] = cx;
        current2[1] = cy;
        current2[2] = cpx;
        current2[3] = cpy;
        current2[4] = loopX;
        current2[5] = loopY;
    }

    private static void drawArc(@NotNull Path2D p2, double x0, double y0, double x1, double y1, double a2, double b2, double theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        LOGGER.log(Level.FINE, "(" + x0 + "," + y0 + ")-(" + x1 + "," + y1 + ") {" + a2 + " " + b2 + "}");
        double thetaD = theta * Math.PI / 180.0;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = (x0 * cosTheta + y0 * sinTheta) / a2;
        double y0p = (-x0 * sinTheta + y0 * cosTheta) / b2;
        double x1p = (x1 * cosTheta + y1 * sinTheta) / a2;
        double y1p = (-x1 * sinTheta + y1 * cosTheta) / b2;
        LOGGER.log(Level.FINE, "unit space (" + x0p + "," + y0p + ")-(" + x1p + "," + y1p + ")");
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            LOGGER.log(Level.FINE, " Points are coincident");
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            LOGGER.log(Level.FINE, "Points are too far apart " + dsq);
            double adjust = Math.sqrt(dsq) / 1.99999;
            VdNodeRender.drawArc(p2, x0, y0, x1, y1, a2 * adjust, b2 * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s2 = Math.sqrt(disc);
        double sdx = s2 * dx;
        double sdy = s2 * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        LOGGER.log(Level.FINE, "eta0 = Math.atan2(" + (y0p - cy) + ", " + (x0p - cx) + ") = " + Math.toDegrees(eta0));
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        LOGGER.log(Level.FINE, "eta1 = Math.atan2(" + (y1p - cy) + ", " + (x1p - cx) + ") = " + Math.toDegrees(eta1));
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= a2;
        cx = cx * cosTheta - (cy *= b2) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        LOGGER.log(Level.FINE, "cx = " + cx + ", cy = " + cy + ", a = " + a2 + ", b = " + b2 + ", x0 = " + x0 + ", y0 = " + y0 + ", thetaD = " + Math.toDegrees(thetaD) + ", eta0 = " + Math.toDegrees(eta0) + ", sweep = " + Math.toDegrees(sweep));
        VdNodeRender.arcToBezier(p2, cx, cy, a2, b2, x0, y0, thetaD, eta0, sweep);
    }

    private static void arcToBezier(@NotNull Path2D p2, double cx, double cy, double a2, double b2, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = (int)Math.ceil(Math.abs(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a2 * cosTheta * sinEta1 - b2 * sinTheta * cosEta1;
        double ep1y = -a2 * sinTheta * sinEta1 + b2 * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i2 = 0; i2 < numSegments; ++i2) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a2 * cosTheta * cosEta2 - b2 * sinTheta * sinEta2;
            double e2y = cy + a2 * sinTheta * cosEta2 + b2 * cosTheta * sinEta2;
            double ep2x = -a2 * cosTheta * sinEta2 - b2 * sinTheta * cosEta2;
            double ep2y = -a2 * sinTheta * sinEta2 + b2 * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            p2.curveTo(q1x, q1y, q2x, q2y, e2x, e2y);
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }
}

