/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.EllipseSolver;
import com.android.ide.common.vectordrawable.GradientStop;
import com.android.ide.common.vectordrawable.IllegalVectorDrawableResourceRefException;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdElement;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.android.ide.common.vectordrawable.VdUtil;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

class VdPath
extends VdElement {
    private static final String PATH_ID = "android:name";
    private static final String PATH_DESCRIPTION = "android:pathData";
    private static final String PATH_FILL = "android:fillColor";
    private static final String PATH_FILL_OPACITY = "android:fillAlpha";
    private static final String PATH_FILL_TYPE = "android:fillType";
    private static final String PATH_STROKE = "android:strokeColor";
    private static final String PATH_STROKE_OPACITY = "android:strokeAlpha";
    private static final String FILL_TYPE_EVEN_ODD = "evenOdd";
    private static final String PATH_STROKE_WIDTH = "android:strokeWidth";
    private static final String PATH_TRIM_START = "android:trimPathStart";
    private static final String PATH_TRIM_END = "android:trimPathEnd";
    private static final String PATH_TRIM_OFFSET = "android:trimPathOffset";
    private static final String PATH_STROKE_LINE_CAP = "android:strokeLineCap";
    private static final String PATH_STROKE_LINE_JOIN = "android:strokeLineJoin";
    private static final String PATH_STROKE_MITER_LIMIT = "android:strokeMiterLimit";
    private static final String LINE_CAP_BUTT = "butt";
    private static final String LINE_CAP_ROUND = "round";
    private static final String LINE_CAP_SQUARE = "square";
    private static final String LINE_JOIN_MITER = "miter";
    private static final String LINE_JOIN_ROUND = "round";
    private static final String LINE_JOIN_BEVEL = "bevel";
    private static final float EPSILON = 1.0E-6f;
    private static final char INIT_TYPE = ' ';
    private static final ImmutableMap<Character, Integer> COMMAND_STEP_MAP = ImmutableMap.builder().put(Character.valueOf('z'), 2).put(Character.valueOf('Z'), 2).put(Character.valueOf('m'), 2).put(Character.valueOf('M'), 2).put(Character.valueOf('l'), 2).put(Character.valueOf('L'), 2).put(Character.valueOf('t'), 2).put(Character.valueOf('T'), 2).put(Character.valueOf('h'), 1).put(Character.valueOf('H'), 1).put(Character.valueOf('v'), 1).put(Character.valueOf('V'), 1).put(Character.valueOf('c'), 6).put(Character.valueOf('C'), 6).put(Character.valueOf('s'), 4).put(Character.valueOf('S'), 4).put(Character.valueOf('q'), 4).put(Character.valueOf('Q'), 4).put(Character.valueOf('a'), 7).put(Character.valueOf('A'), 7).build();
    private VdGradient fillGradient;
    private VdGradient strokeGradient;
    private Node[] mNodeList;
    private int mStrokeColor;
    private int mFillColor;
    private float mStrokeWidth;
    private int mStrokeLineCap;
    private int mStrokeLineJoin;
    private float mStrokeMiterlimit = 4.0f;
    private float mStrokeAlpha = 1.0f;
    private float mFillAlpha = 1.0f;
    private int mFillType = 1;
    private float mTrimPathStart;
    private float mTrimPathEnd = 1.0f;
    private float mTrimPathOffset;

    VdPath() {
    }

    private void toPath(Path2D path) {
        path.reset();
        if (this.mNodeList != null) {
            VdNodeRender.createPath(this.mNodeList, path);
        }
    }

    private void setNameValue(String name2, String value) {
        if (value.startsWith("@") && PATH_FILL.equals(name2)) {
            value = "#000000";
        }
        if (value.startsWith("@")) {
            throw new ResourcesNotSupportedException(name2, value);
        }
        if (PATH_DESCRIPTION.equals(name2)) {
            this.mNodeList = PathParser.parsePath(value, PathParser.ParseMode.ANDROID);
        } else if (PATH_ID.equals(name2)) {
            this.mName = value;
        } else if (PATH_FILL.equals(name2)) {
            this.mFillColor = VdUtil.parseColorValue(value);
        } else if (PATH_FILL_TYPE.equals(name2)) {
            this.mFillType = VdPath.parseFillType(value);
        } else if (PATH_STROKE.equals(name2)) {
            this.mStrokeColor = VdUtil.parseColorValue(value);
        } else if (PATH_FILL_OPACITY.equals(name2)) {
            this.mFillAlpha = Float.parseFloat(value);
        } else if (PATH_STROKE_OPACITY.equals(name2)) {
            this.mStrokeAlpha = Float.parseFloat(value);
        } else if (PATH_STROKE_WIDTH.equals(name2)) {
            this.mStrokeWidth = Float.parseFloat(value);
        } else if (PATH_TRIM_START.equals(name2)) {
            this.mTrimPathStart = Float.parseFloat(value);
        } else if (PATH_TRIM_END.equals(name2)) {
            this.mTrimPathEnd = Float.parseFloat(value);
        } else if (PATH_TRIM_OFFSET.equals(name2)) {
            this.mTrimPathOffset = Float.parseFloat(value);
        } else if (PATH_STROKE_LINE_CAP.equals(name2)) {
            if (LINE_CAP_BUTT.equals(value)) {
                this.mStrokeLineCap = 0;
            } else if ("round".equals(value)) {
                this.mStrokeLineCap = 1;
            } else if (LINE_CAP_SQUARE.equals(value)) {
                this.mStrokeLineCap = 2;
            }
        } else if (PATH_STROKE_LINE_JOIN.equals(name2)) {
            if (LINE_JOIN_MITER.equals(value)) {
                this.mStrokeLineJoin = 0;
            } else if ("round".equals(value)) {
                this.mStrokeLineJoin = 1;
            } else if (LINE_JOIN_BEVEL.equals(value)) {
                this.mStrokeLineJoin = 2;
            }
        } else if (PATH_STROKE_MITER_LIMIT.equals(name2)) {
            this.mStrokeMiterlimit = Float.parseFloat(value);
        } else {
            VdPath.getLogger().log(Level.WARNING, ">>>>>> DID NOT UNDERSTAND ! \"" + name2 + "\" <<<<");
        }
    }

    private static int parseFillType(String value) {
        if (FILL_TYPE_EVEN_ODD.equalsIgnoreCase(value)) {
            return 0;
        }
        return 1;
    }

    protected static int applyAlpha(int color, float alpha) {
        int alphaBytes = color >> 24 & 0xFF;
        color &= 0xFFFFFF;
        return color |= (int)((float)alphaBytes * alpha) << 24;
    }

    @Override
    public void draw(Graphics2D g2, AffineTransform currentMatrix, float scaleX, float scaleY) {
        Path2D.Double path2d = new Path2D.Double(this.mFillType);
        this.toPath(path2d);
        g2.setTransform(new AffineTransform());
        g2.scale(scaleX, scaleY);
        g2.transform(currentMatrix);
        if (this.mFillColor != 0 && this.fillGradient == null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color fillColor = new Color(VdPath.applyAlpha(this.mFillColor, this.mFillAlpha), true);
            g2.setColor(fillColor);
            g2.fill(path2d);
        }
        if (this.mStrokeColor != 0 && this.mStrokeWidth != 0.0f && this.strokeGradient == null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke stroke = new BasicStroke(this.mStrokeWidth, this.mStrokeLineCap, this.mStrokeLineJoin, this.mStrokeMiterlimit);
            g2.setStroke(stroke);
            Color strokeColor = new Color(VdPath.applyAlpha(this.mStrokeColor, this.mStrokeAlpha), true);
            g2.setColor(strokeColor);
            g2.draw(path2d);
        }
        if (this.isClipPath) {
            Shape clip = g2.getClip();
            if (clip != null) {
                Area area = new Area(clip);
                area.add(new Area(path2d));
                g2.setClip(area);
            } else {
                g2.setClip(path2d);
            }
        }
        if (this.fillGradient != null) {
            this.fillGradient.drawGradient(g2, path2d, true);
        }
        if (this.strokeGradient != null) {
            this.strokeGradient.drawGradient(g2, path2d, false);
        }
    }

    @Override
    public void parseAttributes(NamedNodeMap attributes) {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            org.w3c.dom.Node attribute = attributes.item(i2);
            if (Objects.equals(attribute.getNamespaceURI(), "http://schemas.android.com/tools")) continue;
            String name2 = attribute.getNodeName();
            String value = attribute.getNodeValue();
            this.setNameValue(name2, value);
        }
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    public String toString() {
        return "Path: Name: " + this.mName + " Node: " + Arrays.toString(this.mNodeList) + " mFillColor: " + Integer.toHexString(this.mFillColor) + " mFillAlpha:" + this.mFillAlpha + " mFillType:" + this.mFillType + " mStrokeColor:" + Integer.toHexString(this.mStrokeColor) + " mStrokeWidth:" + this.mStrokeWidth + " mStrokeAlpha:" + this.mStrokeAlpha;
    }

    protected void addGradientIfExists(org.w3c.dom.Node current2) {
        org.w3c.dom.Node gradientNode = current2.getFirstChild();
        VdGradient newGradient = new VdGradient();
        if (gradientNode != null && (gradientNode = gradientNode.getNextSibling()) != null) {
            String attrValue = gradientNode.getAttributes().getNamedItem("name").getNodeValue();
            if (attrValue.equals(PATH_FILL)) {
                this.fillGradient = newGradient;
            } else if (attrValue.equals(PATH_STROKE)) {
                this.strokeGradient = newGradient;
            }
            gradientNode = gradientNode.getFirstChild();
            if (gradientNode != null) {
                gradientNode = gradientNode.getNextSibling();
            }
        }
        if (gradientNode != null && gradientNode.getNodeName().equals("gradient")) {
            NamedNodeMap gradientAttributes = gradientNode.getAttributes();
            for (int i2 = 0; i2 < gradientAttributes.getLength(); ++i2) {
                String name2 = gradientAttributes.item(i2).getNodeName();
                String value = gradientAttributes.item(i2).getNodeValue();
                newGradient.setGradientValue(name2, value);
            }
            NodeList items = gradientNode.getChildNodes();
            for (int i3 = 0; i3 < items.getLength(); ++i3) {
                org.w3c.dom.Node stop = items.item(i3);
                if (!stop.getNodeName().equals("item")) continue;
                NamedNodeMap stopAttr = stop.getAttributes();
                String color = null;
                String offset = null;
                for (int j2 = 0; j2 < stopAttr.getLength(); ++j2) {
                    org.w3c.dom.Node currentItem = stopAttr.item(j2);
                    if (currentItem.getNodeName().equals("android:color")) {
                        color = currentItem.getNodeValue();
                        if (color == null || color.charAt(0) != '@' && color.charAt(0) != '?') continue;
                        throw new IllegalVectorDrawableResourceRefException(color, PositionXmlParser.getPosition(currentItem), null);
                    }
                    if (!currentItem.getNodeName().equals("android:offset")) continue;
                    offset = currentItem.getNodeValue();
                }
                if (color == null) {
                    color = "#000000";
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> No color for gradient found >>>>>>");
                }
                if (offset == null) {
                    offset = "0";
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> No offset for gradient found>>>>>>");
                }
                GradientStop gradientStop = new GradientStop(color, offset);
                newGradient.mGradientStops.add(gradientStop);
            }
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(VdPath.class.getSimpleName());
    }

    public static class Node {
        private char mType;
        private float[] mParams;

        public char getType() {
            return this.mType;
        }

        public float[] getParams() {
            return this.mParams;
        }

        public Node(char type, float[] params) {
            this.mType = type;
            this.mParams = params;
        }

        public Node(Node n2) {
            this.mType = n2.mType;
            this.mParams = Arrays.copyOf(n2.mParams, n2.mParams.length);
        }

        public static boolean hasRelMoveAfterClose(Node[] nodes) {
            int preType = 32;
            for (Node n2 : nodes) {
                if ((preType == 122 || preType == 90) && n2.mType == 'm') {
                    return true;
                }
                preType = n2.mType;
            }
            return false;
        }

        public static String nodeListToString(Node[] nodes, SvgTree svgTree) {
            StringBuilder result2 = new StringBuilder();
            for (Node node : nodes) {
                result2.append(node.mType);
                int len = node.mParams.length;
                boolean implicitLineTo = false;
                char lineToType = ' ';
                if ((node.mType == 'm' || node.mType == 'M') && len > 2) {
                    implicitLineTo = true;
                    lineToType = node.mType == 'm' ? (char)'l' : 'L';
                }
                for (int j2 = 0; j2 < len; ++j2) {
                    float param;
                    if (j2 > 0) {
                        result2.append(j2 % 2 != 0 ? "," : " ");
                    }
                    if (implicitLineTo && j2 == 2) {
                        result2.append(lineToType);
                    }
                    if (!Float.isFinite(param = node.mParams[j2])) {
                        throw new IllegalArgumentException("Invalid number: " + param);
                    }
                    String str = svgTree.formatCoordinate(param);
                    result2.append(str);
                }
            }
            return result2.toString();
        }

        public static void transform(AffineTransform totalTransform, Node[] nodes) {
            Point2D.Float currentPoint = new Point2D.Float();
            Point2D.Float currentSegmentStartPoint = new Point2D.Float();
            char previousType = ' ';
            for (Node n2 : nodes) {
                n2.transform(totalTransform, currentPoint, currentSegmentStartPoint, previousType);
                previousType = n2.mType;
            }
        }

        private void transform(AffineTransform totalTransform, Point2D.Float currentPoint, Point2D.Float currentSegmentStartPoint, char previousType) {
            int paramsLen = this.mParams.length;
            float[] tempParams = new float[2 * paramsLen];
            float currentX = currentPoint.x;
            float currentY = currentPoint.y;
            float currentSegmentStartX = currentSegmentStartPoint.x;
            float currentSegmentStartY = currentSegmentStartPoint.y;
            int step = COMMAND_STEP_MAP.get(Character.valueOf(this.mType));
            switch (this.mType) {
                case 'Z': 
                case 'z': {
                    currentX = currentSegmentStartX;
                    currentY = currentSegmentStartY;
                    break;
                }
                case 'M': {
                    currentSegmentStartX = this.mParams[0];
                    currentSegmentStartY = this.mParams[1];
                }
                case 'C': 
                case 'L': 
                case 'Q': 
                case 'S': 
                case 'T': {
                    currentX = this.mParams[paramsLen - 2];
                    currentY = this.mParams[paramsLen - 1];
                    totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLen / 2);
                    break;
                }
                case 'm': {
                    if (previousType == 'z' || previousType == 'Z') {
                        this.mType = (char)77;
                        this.mParams[0] = this.mParams[0] + currentSegmentStartX;
                        this.mParams[1] = this.mParams[1] + currentSegmentStartY;
                        currentSegmentStartX = this.mParams[0];
                        currentSegmentStartY = this.mParams[1];
                        for (int i2 = step; i2 < paramsLen; i2 += step) {
                            int n2 = i2;
                            this.mParams[n2] = this.mParams[n2] + this.mParams[i2 - step];
                            int n3 = i2 + 1;
                            this.mParams[n3] = this.mParams[n3] + this.mParams[i2 + 1 - step];
                        }
                        currentX = this.mParams[paramsLen - 2];
                        currentY = this.mParams[paramsLen - 1];
                        totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLen / 2);
                        break;
                    }
                    int headLen = 2;
                    currentSegmentStartX = currentX += this.mParams[0];
                    currentSegmentStartY = currentY += this.mParams[1];
                    if (previousType == ' ') {
                        totalTransform.transform(this.mParams, 0, this.mParams, 0, headLen / 2);
                    } else if (!Node.isTranslationOnly(totalTransform)) {
                        Node.deltaTransform(totalTransform, this.mParams, 0, headLen);
                    }
                    for (int i3 = headLen; i3 < paramsLen; i3 += step) {
                        currentX += this.mParams[i3];
                        currentY += this.mParams[i3 + 1];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    Node.deltaTransform(totalTransform, this.mParams, headLen, paramsLen - headLen);
                    break;
                }
                case 'c': 
                case 'l': 
                case 'q': 
                case 's': 
                case 't': {
                    for (int i4 = 0; i4 < paramsLen - step + 1; i4 += step) {
                        currentX += this.mParams[i4 + step - 2];
                        currentY += this.mParams[i4 + step - 1];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    Node.deltaTransform(totalTransform, this.mParams, 0, paramsLen);
                    break;
                }
                case 'H': {
                    this.mType = (char)76;
                    for (int i5 = 0; i5 < paramsLen; ++i5) {
                        tempParams[i5 * 2] = this.mParams[i5];
                        tempParams[i5 * 2 + 1] = currentY;
                        currentX = this.mParams[i5];
                    }
                    totalTransform.transform(tempParams, 0, tempParams, 0, paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'V': {
                    this.mType = (char)76;
                    for (int i6 = 0; i6 < paramsLen; ++i6) {
                        tempParams[i6 * 2] = currentX;
                        tempParams[i6 * 2 + 1] = this.mParams[i6];
                        currentY = this.mParams[i6];
                    }
                    totalTransform.transform(tempParams, 0, tempParams, 0, paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'h': {
                    for (int i7 = 0; i7 < paramsLen; ++i7) {
                        currentX += this.mParams[i7];
                        tempParams[i7 * 2] = this.mParams[i7];
                        tempParams[i7 * 2 + 1] = 0.0f;
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    this.mType = (char)108;
                    Node.deltaTransform(totalTransform, tempParams, 0, 2 * paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'v': {
                    for (int i8 = 0; i8 < paramsLen; ++i8) {
                        tempParams[i8 * 2] = 0.0f;
                        tempParams[i8 * 2 + 1] = this.mParams[i8];
                        currentY += this.mParams[i8];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    this.mType = (char)108;
                    Node.deltaTransform(totalTransform, tempParams, 0, 2 * paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'A': {
                    for (int i9 = 0; i9 < paramsLen - step + 1; i9 += step) {
                        if (!Node.isTranslationOnly(totalTransform)) {
                            EllipseSolver ellipseSolver = new EllipseSolver(totalTransform, currentX, currentY, this.mParams[i9], this.mParams[i9 + 1], this.mParams[i9 + 2], this.mParams[i9 + 3], this.mParams[i9 + 4], this.mParams[i9 + 5], this.mParams[i9 + 6]);
                            this.mParams[i9] = ellipseSolver.getMajorAxis();
                            this.mParams[i9 + 1] = ellipseSolver.getMinorAxis();
                            this.mParams[i9 + 2] = ellipseSolver.getRotationDegree();
                            if (ellipseSolver.getDirectionChanged()) {
                                this.mParams[i9 + 4] = 1.0f - this.mParams[i9 + 4];
                            }
                        }
                        currentX = this.mParams[i9 + 5];
                        currentY = this.mParams[i9 + 6];
                        totalTransform.transform(this.mParams, i9 + 5, this.mParams, i9 + 5, 1);
                    }
                    break;
                }
                case 'a': {
                    for (int i10 = 0; i10 < paramsLen - step + 1; i10 += step) {
                        float oldCurrentX = currentX;
                        float oldCurrentY = currentY;
                        currentX += this.mParams[i10 + 5];
                        currentY += this.mParams[i10 + 6];
                        if (Node.isTranslationOnly(totalTransform)) continue;
                        EllipseSolver ellipseSolver = new EllipseSolver(totalTransform, oldCurrentX, oldCurrentY, this.mParams[i10], this.mParams[i10 + 1], this.mParams[i10 + 2], this.mParams[i10 + 3], this.mParams[i10 + 4], oldCurrentX + this.mParams[i10 + 5], oldCurrentY + this.mParams[i10 + 6]);
                        Node.deltaTransform(totalTransform, this.mParams, i10 + 5, 2);
                        this.mParams[i10] = ellipseSolver.getMajorAxis();
                        this.mParams[i10 + 1] = ellipseSolver.getMinorAxis();
                        this.mParams[i10 + 2] = ellipseSolver.getRotationDegree();
                        if (!ellipseSolver.getDirectionChanged()) continue;
                        this.mParams[i10 + 4] = 1.0f - this.mParams[i10 + 4];
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected type " + this.mType);
                }
            }
            currentPoint.setLocation(currentX, currentY);
            currentSegmentStartPoint.setLocation(currentSegmentStartX, currentSegmentStartY);
        }

        private static boolean isTranslationOnly(AffineTransform totalTransform) {
            int type = totalTransform.getType();
            return type == 0 || type == 1;
        }

        private static void deltaTransform(AffineTransform totalTransform, float[] coordinates, int offset, int paramsLen) {
            int i2;
            double[] doubleArray = new double[paramsLen];
            for (i2 = 0; i2 < paramsLen; ++i2) {
                doubleArray[i2] = coordinates[i2 + offset];
            }
            totalTransform.deltaTransform(doubleArray, 0, doubleArray, 0, paramsLen / 2);
            for (i2 = 0; i2 < paramsLen; ++i2) {
                coordinates[i2 + offset] = (float)doubleArray[i2];
            }
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder();
            result2.append(this.mType);
            int i2 = 0;
            for (float param : this.mParams) {
                result2.append(i2++ % 2 == 0 ? (char)' ' : ',');
                result2.append(XmlUtils.formatFloatValue(param));
            }
            return result2.toString();
        }
    }

    class VdGradient {
        private float mStartX;
        private float mStartY;
        private float mEndX;
        private float mEndY;
        private float mCenterX;
        private float mCenterY;
        private float mGradientRadius;
        private String mTileMode = "NO_CYCLE";
        private String mGradientType = "linear";
        private final ArrayList<GradientStop> mGradientStops = new ArrayList();

        VdGradient() {
        }

        private void setGradientValue(String name2, String value) {
            switch (name2) {
                case "android:type": {
                    this.mGradientType = value;
                    break;
                }
                case "android:tileMode": {
                    this.mTileMode = value;
                    break;
                }
                case "android:startX": {
                    this.mStartX = Float.parseFloat(value);
                    break;
                }
                case "android:startY": {
                    this.mStartY = Float.parseFloat(value);
                    break;
                }
                case "android:endX": {
                    this.mEndX = Float.parseFloat(value);
                    break;
                }
                case "android:endY": {
                    this.mEndY = Float.parseFloat(value);
                    break;
                }
                case "android:centerX": {
                    this.mCenterX = Float.parseFloat(value);
                    break;
                }
                case "android:centerY": {
                    this.mCenterY = Float.parseFloat(value);
                    break;
                }
                case "android:gradientRadius": {
                    this.mGradientRadius = Float.parseFloat(value);
                }
            }
        }

        private void drawGradient(Graphics2D g2, Path2D path2d, boolean fill) {
            int i2;
            if (this.mGradientStops.isEmpty()) {
                return;
            }
            float[] mFractions = new float[this.mGradientStops.size()];
            Color[] mGradientColors = new Color[this.mGradientStops.size()];
            for (int j2 = 0; j2 < this.mGradientStops.size(); ++j2) {
                GradientStop stop = this.mGradientStops.get(j2);
                float fraction = Float.parseFloat(stop.getOffset());
                int colorInt = VdUtil.parseColorValue(stop.getColor());
                Color color = new Color(colorInt, true);
                mFractions[j2] = fraction;
                mGradientColors[j2] = color;
            }
            for (i2 = 0; i2 < this.mGradientStops.size() - 1; ++i2) {
                if (!(mFractions[i2] >= mFractions[i2 + 1]) || !(mFractions[i2] + 1.0E-6f <= 1.0f)) continue;
                mFractions[i2 + 1] = mFractions[i2] + 1.0E-6f;
            }
            for (i2 = this.mGradientStops.size() - 2; i2 >= 0 && mFractions[i2] >= mFractions[i2 + 1] && mFractions[i2] >= 1.0f; --i2) {
                mFractions[i2] = mFractions[i2 + 1] - 1.0E-6f;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke stroke = new BasicStroke(VdPath.this.mStrokeWidth, VdPath.this.mStrokeLineCap, VdPath.this.mStrokeLineJoin, VdPath.this.mStrokeMiterlimit);
            if (this.mGradientStops.size() == 1) {
                g2.setColor(mGradientColors[0]);
                if (!fill) {
                    g2.setStroke(stroke);
                }
                g2.draw(path2d);
            } else {
                MultipleGradientPaint.CycleMethod tile = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (this.mTileMode.equals("mirror")) {
                    tile = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (this.mTileMode.equals("repeat")) {
                    tile = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                if (this.mGradientType.equals("linear")) {
                    LinearGradientPaint gradient = new LinearGradientPaint(this.mStartX, this.mStartY, this.mEndX, this.mEndY, mFractions, mGradientColors, tile);
                    g2.setPaint(gradient);
                } else if (this.mGradientType.equals("radial")) {
                    RadialGradientPaint paint = new RadialGradientPaint(this.mCenterX, this.mCenterY, this.mGradientRadius, mFractions, mGradientColors, tile);
                    g2.setPaint(paint);
                } else if (this.mGradientType.equals("sweep")) {
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> Unable to render a sweep gradient. Using a solid color instead. >>>>>>");
                    g2.setPaint(mGradientColors[0]);
                } else {
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> Unsupported gradient type: \"" + this.mGradientType + "\">>>>>>");
                }
                if (fill) {
                    g2.fill(path2d);
                } else {
                    g2.setStroke(stroke);
                    g2.draw(path2d);
                }
            }
        }
    }
}

