/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.instantapp.run.InstantAppRunException;
import com.android.instantapp.run.InstantAppSideLoader;
import com.android.instantapp.run.RunListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class PostOInstaller
implements InstantAppSideLoader.Installer {
    private final List<File> myApks;
    private final RunListener myListener;

    PostOInstaller(List<File> apks, RunListener listener) {
        this.myApks = apks;
        this.myListener = listener;
    }

    @Override
    public void install(IDevice device) throws InstantAppRunException {
        ArrayList<String> myInstallOptions = Lists.newArrayList("-t", "--ephemeral");
        this.myListener.logMessage("Running adb command: \"" + PostOInstaller.getAdbInstallCommand(this.myApks, myInstallOptions) + "\"", null);
        try {
            device.installPackages(this.myApks, true, myInstallOptions, 5L, TimeUnit.MINUTES);
        }
        catch (InstallException e2) {
            throw new InstantAppRunException(InstantAppRunException.ErrorType.INSTALL_FAILED, (Throwable)e2);
        }
    }

    @VisibleForTesting
    static String getAdbInstallCommand(List<File> apks, List<String> installOptions) {
        StringBuilder sb = new StringBuilder();
        sb.append("$ adb install-multiple -r ");
        if (!installOptions.isEmpty()) {
            sb.append(Joiner.on(' ').join(installOptions));
            sb.append(' ');
        }
        for (File f2 : apks) {
            sb.append(f2.getPath());
            sb.append(' ');
        }
        return sb.toString();
    }
}

