/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.google.common.annotations.VisibleForTesting;
import java.io.PrintStream;
import java.util.Locale;

public class ConsoleProgressIndicator
extends ProgressIndicatorAdapter {
    private static final int PROGRESS_WIDTH = 40;
    private static final int MAX_WIDTH = 80;
    private String mText = "";
    private String mSecondaryText = "";
    private double mProgress = 0.0;
    private PrintStream mOut;
    private PrintStream mErr;
    private final boolean mDumb;
    private String mLast = null;
    private static final String SPACES = "                                                                                ";

    public ConsoleProgressIndicator() {
        this(System.out, System.err);
    }

    public ConsoleProgressIndicator(PrintStream out, PrintStream err) {
        this(out, err, "dumb".equals(System.getenv("TERM")));
    }

    @VisibleForTesting
    ConsoleProgressIndicator(PrintStream out, PrintStream err, boolean dumb) {
        this.mOut = out;
        this.mErr = err;
        this.mDumb = dumb;
    }

    public void setOut(PrintStream out) {
        this.mOut = out;
    }

    public void setErr(PrintStream err) {
        this.mErr = err;
    }

    @Override
    public double getFraction() {
        return this.mProgress;
    }

    @Override
    public void setFraction(double progress) {
        this.mProgress = progress;
        this.printStatusLine(true);
    }

    private void printStatusLine(boolean forceShowProgress) {
        String result2;
        if (this.mDumb) {
            return;
        }
        StringBuilder line = new StringBuilder();
        if (forceShowProgress || this.getFraction() > 0.0) {
            line.append("[");
            int i2 = 1;
            while ((double)i2 < 40.0 * this.mProgress) {
                line.append("=");
                ++i2;
            }
            while (i2 < 40) {
                line.append(" ");
                ++i2;
            }
            line.append("] ");
            line.append(String.format(Locale.US, "%.0f%%", 100.0 * this.mProgress));
            line.append(" ");
        }
        line.append(this.mText);
        line.append(" ");
        line.append(this.mSecondaryText);
        if (line.length() > 80) {
            line.delete(80, line.length());
        } else {
            line.append(SPACES, 0, 80 - line.length());
        }
        line.append("\r");
        if (this.getFraction() >= 1.0) {
            line.append(System.lineSeparator());
        }
        if (!(result2 = line.toString()).equals(this.mLast)) {
            this.mOut.print(result2);
            this.mOut.flush();
            this.mLast = result2;
        }
    }

    private void logMessage(String s2, Throwable e2, PrintStream stream) {
        if (this.mProgress > 0.0 && this.mProgress < 1.0) {
            this.mOut.print(SPACES);
            this.mOut.print("\r");
            this.mLast = null;
        }
        stream.println(s2);
        if (e2 != null) {
            e2.printStackTrace();
        }
        if (this.mProgress > 0.0 && this.mProgress < 1.0) {
            this.printStatusLine(false);
        }
    }

    @Override
    public void logWarning(String s2, Throwable e2) {
        this.logMessage("Warning: " + s2, e2, this.mErr);
    }

    @Override
    public void logError(String s2, Throwable e2) {
        this.logMessage("Error: " + s2, e2, this.mErr);
    }

    @Override
    public void logInfo(String s2) {
        this.logMessage("Info: " + s2, null, this.mOut);
    }

    @Override
    public void setText(String text) {
        this.mText = text;
        this.printStatusLine(false);
    }

    @Override
    public void setSecondaryText(String text) {
        this.mSecondaryText = text;
        this.printStatusLine(false);
    }
}

