/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;

public class UpdatablePackage
implements Comparable<UpdatablePackage> {
    private LocalPackage mLocalPackage;
    private RemotePackage mRemotePackage;

    public UpdatablePackage(LocalPackage localPackage) {
        this.init(localPackage, null);
    }

    public UpdatablePackage(RemotePackage remotePackage) {
        this.init(null, remotePackage);
    }

    public UpdatablePackage(LocalPackage localPackage, RemotePackage remotePackage) {
        this.init(localPackage, remotePackage);
    }

    private void init(LocalPackage localPkg, RemotePackage remotePkg) {
        assert (localPkg != null || remotePkg != null);
        this.mLocalPackage = localPkg;
        if (remotePkg != null) {
            this.setRemote(remotePkg);
        }
    }

    public void setRemote(RemotePackage remote) {
        this.mRemotePackage = remote;
    }

    public LocalPackage getLocal() {
        return this.mLocalPackage;
    }

    public RemotePackage getRemote() {
        return this.mRemotePackage;
    }

    public boolean hasRemote() {
        return this.getRemote() != null;
    }

    public boolean hasLocal() {
        return this.mLocalPackage != null;
    }

    @Override
    public int compareTo(UpdatablePackage o2) {
        return this.getRepresentative().compareTo(o2.getRepresentative());
    }

    public RepoPackage getRepresentative() {
        if (this.hasLocal()) {
            return this.mLocalPackage;
        }
        return this.getRemote();
    }

    public boolean isUpdate() {
        RemotePackage remote = this.getRemote();
        return this.mLocalPackage != null && remote != null && this.mLocalPackage.getVersion().compareTo(remote.getVersion()) < 0;
    }

    public String getPath() {
        return this.getRepresentative().getPath();
    }
}

