/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.downloader;

import com.android.repository.api.Checksum;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class LocalFileAwareDownloader
implements Downloader {
    private final Downloader mDelegate;

    public LocalFileAwareDownloader(Downloader delegate2) {
        this.mDelegate = delegate2;
    }

    @Override
    public InputStream downloadAndStream(URL url, ProgressIndicator indicator) throws IOException {
        if ("file".equals(url.getProtocol())) {
            return url.openStream();
        }
        return this.mDelegate.downloadAndStream(url, indicator);
    }

    @Override
    public Path downloadFully(URL url, ProgressIndicator indicator) throws IOException {
        if ("file".equals(url.getProtocol())) {
            Path tempFile = Files.createTempFile(LocalFileAwareDownloader.class.getName(), null, new FileAttribute[0]);
            Path source = Paths.get(url.getFile(), new String[0]);
            Files.copy(source, tempFile, new CopyOption[0]);
        }
        return this.mDelegate.downloadFully(url, indicator);
    }

    @Override
    public void downloadFully(URL url, Path target, Checksum checksum, ProgressIndicator indicator) throws IOException {
        if ("file".equals(url.getProtocol())) {
            Path source = target.getFileSystem().getPath(url.getFile(), new String[0]);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, new CopyOption[0]);
            return;
        }
        this.mDelegate.downloadFully(url, target, checksum, indicator);
    }
}

