/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.io.CancellableFileIo;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.utils.PathUtils;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;

class BasicUninstaller
extends AbstractUninstaller {
    public BasicUninstaller(LocalPackage p2, RepoManager mgr) {
        super(p2, mgr);
    }

    @Override
    protected boolean doPrepare(Path tempPath, ProgressIndicator progress) {
        return true;
    }

    @Override
    protected boolean doComplete(Path tempPath, ProgressIndicator progress) {
        Path location = this.getPackage().getLocation();
        try {
            PathUtils.deleteRecursivelyIfExists(location);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getRepoManager().markLocalCacheInvalid();
        boolean successfullyDeleted = CancellableFileIo.notExists(location, new LinkOption[0]);
        if (!successfullyDeleted) {
            progress.logWarning(String.format("Failed to delete package location: %1$s", location));
        }
        return successfullyDeleted;
    }
}

