/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.sources;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemoteListSourceProvider;
import com.android.repository.api.RemoteSource;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.SchemaModule;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlTransient;

public class RemoteListSourceProviderImpl
extends RemoteListSourceProvider {
    private static SchemaModule<?> sAddonListModule = new SchemaModule(RemoteListSourceProviderImpl.class.getPackage().getName() + ".generated.v%d.ObjectFactory", "repo-sites-common-%d.xsd", RepoManager.class);
    private final String mUrl;
    private final Map<Class<? extends RepositorySource>, Collection<SchemaModule<?>>> mAllowedModules;
    private final SchemaModule mSourceListModule;
    private List<RepositorySource> mSources;

    public RemoteListSourceProviderImpl(String url, SchemaModule sourceListModule, Map<Class<? extends RepositorySource>, Collection<SchemaModule<?>>> permittedSchemaModules) throws URISyntaxException {
        this.mUrl = url;
        this.mAllowedModules = permittedSchemaModules;
        this.mSourceListModule = sourceListModule;
    }

    @Override
    public List<RepositorySource> getSources(Downloader downloader, ProgressIndicator progress, boolean forceRefresh) {
        if (downloader == null) {
            throw new IllegalArgumentException("downloader must not be null");
        }
        if (this.mSources != null && !forceRefresh) {
            return this.mSources;
        }
        InputStream xml = null;
        URL url = null;
        SchemaModule sourceModule = this.mSourceListModule == null ? sAddonListModule : this.mSourceListModule;
        int versionsSize = sourceModule.getNamespaceVersionMap().size();
        double progressMax = 0.0;
        double progressIncrement = 1.0 / (double)versionsSize;
        for (int version = versionsSize; xml == null && version > 0; --version) {
            String urlStr = String.format(Locale.ROOT, this.mUrl, version);
            try {
                url = new URL(urlStr);
                xml = downloader.downloadAndStream(url, progress.createSubProgress(progressMax + progressIncrement));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (UnknownHostException e2) {
                progress.logWarning("Failed to connect to host: " + urlStr);
            }
            catch (MalformedURLException e3) {
                progress.logWarning("Invalid URL: " + urlStr);
            }
            catch (IOException e4) {
                progress.logInfo("IOException: " + urlStr);
                progress.logInfo(e4.toString());
            }
            progress.setFraction(progressMax += progressIncrement);
        }
        if (xml != null) {
            List<RepositorySource> result2 = this.parse(xml, progress, url);
            this.mSources = result2;
            return this.mSources;
        }
        progress.logWarning("Failed to download any source lists!");
        return ImmutableList.of();
    }

    private List<RepositorySource> parse(InputStream xml, ProgressIndicator progress, URL url) {
        HashSet<SchemaModule<?>> schemas = Sets.newHashSet(sAddonListModule);
        if (this.mSourceListModule != null) {
            schemas.add(this.mSourceListModule);
        }
        SiteList sl = null;
        try {
            sl = (SiteList)SchemaModuleUtil.unmarshal(xml, schemas, true, progress, url.toString());
        }
        catch (JAXBException e2) {
            progress.logWarning("Failed to parse source list at " + url);
        }
        ArrayList<RepositorySource> result2 = Lists.newArrayList();
        if (sl != null) {
            for (RemoteSource s2 : sl.getSite()) {
                for (Class<? extends RepositorySource> c2 : this.mAllowedModules.keySet()) {
                    if (!c2.isInstance(s2)) continue;
                    s2.setPermittedSchemaModules(this.mAllowedModules.get(c2));
                }
                String urlStr = s2.getUrl();
                try {
                    URL fullUrl = new URL(url, urlStr);
                    s2.setUrl(fullUrl.toExternalForm());
                }
                catch (MalformedURLException e3) {
                    progress.logWarning("Failed to parse URL in remote source list", e3);
                }
                s2.setProvider(this);
                result2.add(s2);
            }
        }
        return result2;
    }

    @Override
    public boolean addSource(RepositorySource source) {
        throw new UnsupportedOperationException("Can't add to RemoteListSourceProvider");
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public void save(ProgressIndicator progress) {
    }

    @Override
    public boolean removeSource(RepositorySource source) {
        throw new UnsupportedOperationException("Can't add to RemoteListSourceProvider");
    }

    @XmlTransient
    public static class SiteList {
        public List<RemoteSource> getSite() {
            return this.getAddonSiteOrSysImgSite();
        }

        protected List<Object> getAddonSiteOrSysImgSite() {
            return this.getAddonSite();
        }

        protected List<RemoteSource> getAddonSite() {
            throw new UnsupportedOperationException();
        }
    }
}

