/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.util;

import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.Dependency;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.RevisionType;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.io.FileOpUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class InstallerUtil {
    public static final String PENDING_PACKAGE_XML_FN = "package.xml.pending";
    public static final String INSTALLER_DIR_FN = ".installer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(Path in, Path out, long expectedSize, ProgressIndicator progress) throws IOException {
        if (!CancellableFileIo.exists(out, new LinkOption[0]) || !CancellableFileIo.isDirectory(out, new LinkOption[0])) {
            throw new IllegalArgumentException("out must exist and be a directory.");
        }
        progress.setText("Unzipping...");
        ZipFile zipFile = new ZipFile(Files.newByteChannel(in, new OpenOption[0]));
        boolean indeterminate = false;
        if (expectedSize == 0L) {
            progress.setIndeterminate(true);
            indeterminate = true;
        }
        try {
            Enumeration<ZipArchiveEntry> entries2 = zipFile.getEntries();
            progress.setFraction(0.0);
            double progressMax = 0.0;
            while (entries2.hasMoreElements()) {
                int mode;
                OutputStream unzippedOutput;
                ZipArchiveEntry entry = entries2.nextElement();
                String name2 = entry.getName();
                Path entryFile = out.resolve(name2);
                progress.setSecondaryText(name2);
                if (entry.isUnixSymlink()) {
                    ByteArrayOutputStream targetByteStream = new ByteArrayOutputStream();
                    InstallerUtil.readZipEntry(zipFile, entry, targetByteStream, indeterminate ? progress : progress.createSubProgress(progressMax += (double)entry.getCompressedSize() / (double)expectedSize));
                    if (!indeterminate) {
                        progress.setFraction(progressMax);
                    }
                    Path linkTarget = out.getFileSystem().getPath(targetByteStream.toString(), new String[0]);
                    if (!Files.isDirectory(entryFile.getParent(), new LinkOption[0])) {
                        Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
                    }
                    Files.createSymbolicLink(entryFile, linkTarget, new FileAttribute[0]);
                    continue;
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryFile, new FileAttribute[0]);
                    continue;
                }
                if (Files.isSymbolicLink(entryFile)) {
                    Files.delete(entryFile);
                }
                if (!CancellableFileIo.exists(entryFile, new LinkOption[0])) {
                    Path parent = entryFile.getParent();
                    if (parent != null && !CancellableFileIo.exists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.createFile(entryFile, new FileAttribute[0]);
                }
                if (InstallerUtil.readZipEntry(zipFile, entry, unzippedOutput = Files.newOutputStream(entryFile, new OpenOption[0]), indeterminate ? progress : progress.createSubProgress(progressMax += (double)entry.getCompressedSize() / (double)expectedSize))) {
                    return;
                }
                if (!indeterminate) {
                    progress.setFraction(progressMax);
                }
                if (FileOpUtils.isWindows() || ((mode = entry.getUnixMode()) & 0x49) == 0) continue;
                try {
                    FileOpUtils.setExecutablePermission(entryFile);
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            progress.setIndeterminate(false);
            progress.setFraction(1.0);
            ZipFile.closeQuietly(zipFile);
        }
    }

    private static boolean readZipEntry(ZipFile zipFile, ZipArchiveEntry entry, OutputStream dest, ProgressIndicator progress) throws IOException {
        byte[] buf = new byte[8192];
        double fraction = 0.0;
        int prevPercent = 0;
        try (BufferedOutputStream bufferedDest = new BufferedOutputStream(dest);
             BufferedInputStream s2 = new BufferedInputStream(zipFile.getInputStream(entry));){
            while (true) {
                int size;
                if ((size = ((InputStream)s2).read(buf)) > -1) {
                    bufferedDest.write(buf, 0, size);
                    int percent = (int)((fraction += (double)size / (double)entry.getSize()) * 100.0);
                    if (percent != prevPercent) {
                        progress.setFraction(fraction);
                        prevPercent = percent;
                    }
                    if (!progress.isCanceled()) continue;
                    boolean bl2 = true;
                    return bl2;
                    continue;
                }
                break;
            }
        }
        progress.setFraction(1.0);
        return false;
    }

    public static void writePendingPackageXml(RepoPackage p2, Path packageRoot, RepoManager manager, ProgressIndicator progress) throws IOException {
        if (!CancellableFileIo.isDirectory(packageRoot, new LinkOption[0])) {
            throw new IllegalArgumentException("packageRoot must exist and be a directory.");
        }
        CommonFactory factory = p2.createFactory();
        Repository repo = factory.createRepositoryType();
        License license = p2.getLicense();
        if (license != null) {
            repo.addLicense(license);
        }
        p2.asMarshallable().addTo(repo);
        Path packageXml = packageRoot.resolve(PENDING_PACKAGE_XML_FN);
        InstallerUtil.writeRepoXml(manager, repo, packageXml, factory, progress);
    }

    public static Repository readPendingPackageXml(Path containingDir, RepoManager manager, ProgressIndicator progress) throws IOException {
        Repository repo;
        try {
            Path xmlFile = containingDir.resolve(PENDING_PACKAGE_XML_FN);
            if (CancellableFileIo.notExists(xmlFile, new LinkOption[0])) {
                return null;
            }
            repo = (Repository)SchemaModuleUtil.unmarshal(CancellableFileIo.newInputStream(xmlFile, new OpenOption[0]), manager.getSchemaModules(), false, progress, xmlFile.getFileName().toString());
        }
        catch (JAXBException e2) {
            throw new IOException("Failed to parse pending package xml", e2);
        }
        return repo;
    }

    public static void writePackageXml(RemotePackage p2, Path packageRoot, RepoManager manager, ProgressIndicator progress) throws IOException {
        if (!CancellableFileIo.isDirectory(packageRoot, new LinkOption[0])) {
            throw new IllegalArgumentException("packageRoot must exist and be a directory.");
        }
        CommonFactory factory = p2.createFactory();
        Repository repo = factory.createRepositoryType();
        License l2 = p2.getLicense();
        if (l2 != null) {
            repo.addLicense(l2);
        }
        LocalPackageImpl impl = LocalPackageImpl.create(p2);
        repo.setLocalPackage(impl);
        Path packageXml = packageRoot.resolve("package.xml");
        InstallerUtil.writeRepoXml(manager, repo, packageXml, factory, progress);
    }

    public static void writeRepoXml(RepoManager manager, Repository repo, Path packageXml, CommonFactory factory, ProgressIndicator progress) throws IOException {
        JAXBElement<Repository> element = factory.generateRepository(repo);
        try (OutputStream fos = Files.newOutputStream(packageXml, new OpenOption[0]);){
            SchemaModuleUtil.marshal(element, manager.getSchemaModules(), fos, manager.getResourceResolver(progress), progress);
        }
    }

    public static URL resolveCompleteArchiveUrl(RemotePackage p2, ProgressIndicator progress) {
        Archive arch = p2.getArchive();
        if (arch == null) {
            return null;
        }
        String urlStr = arch.getComplete().getUrl();
        return InstallerUtil.resolveUrl(urlStr, p2, progress);
    }

    public static URL resolveUrl(String urlStr, RemotePackage p2, ProgressIndicator progress) {
        URL url;
        try {
            url = new URL((String)urlStr);
        }
        catch (MalformedURLException e2) {
            try {
                String sourceUrl = p2.getSource().getUrl();
                if (!sourceUrl.endsWith("/")) {
                    sourceUrl = sourceUrl.substring(0, sourceUrl.lastIndexOf(47) + 1);
                }
                urlStr = sourceUrl + (String)urlStr;
                url = new URL((String)urlStr);
            }
            catch (MalformedURLException e22) {
                progress.logWarning("Failed to parse url: " + (String)urlStr);
                return null;
            }
        }
        return url;
    }

    public static List<RemotePackage> computeRequiredPackages(Collection<RemotePackage> requests, RepositoryPackages packages, ProgressIndicator logger) {
        HashSet<RemotePackage> requiredPackages = Sets.newHashSet();
        Map<String, UpdatablePackage> consolidatedPackages = packages.getConsolidatedPkgs();
        HashSet<String> seen = Sets.newHashSet();
        LinkedHashSet<RemotePackage> roots = Sets.newLinkedHashSet();
        LinkedList<RemotePackage> current2 = Lists.newLinkedList();
        for (RemotePackage request : requests) {
            UpdatablePackage updatable = consolidatedPackages.get(request.getPath());
            if (updatable == null) {
                logger.logWarning(String.format("No package with key %s found!", request.getPath()));
                return null;
            }
            if (updatable.hasLocal() && !updatable.isUpdate()) continue;
            current2.add(request);
            roots.add(request);
            requiredPackages.add(request);
            seen.add(request.getPath());
        }
        HashMultimap<String, Dependency> allDependencies = HashMultimap.create();
        while (!current2.isEmpty()) {
            RemotePackage currentPackage = (RemotePackage)current2.remove();
            Collection<Dependency> currentDependencies = currentPackage.getAllDependencies();
            for (Dependency d2 : currentDependencies) {
                String dependencyPath = d2.getPath();
                UpdatablePackage updatableDependency = consolidatedPackages.get(dependencyPath);
                if (updatableDependency == null) {
                    logger.logWarning(String.format("Dependant package with key %s not found!", dependencyPath));
                    return null;
                }
                LocalPackage localDependency = updatableDependency.getLocal();
                if (localDependency == null && d2.isSoft() != null && d2.isSoft().booleanValue()) continue;
                Revision requiredMinRevision = null;
                RevisionType r2 = d2.getMinRevision();
                if (r2 != null) {
                    requiredMinRevision = r2.toRevision();
                }
                if (localDependency != null && (requiredMinRevision == null || requiredMinRevision.compareTo(localDependency.getVersion()) <= 0)) continue;
                allDependencies.put(dependencyPath, d2);
                roots.remove(updatableDependency.getRemote());
                if (seen.contains(dependencyPath)) continue;
                seen.add(dependencyPath);
                RemotePackage remoteDependency = updatableDependency.getRemote();
                if (remoteDependency == null || requiredMinRevision != null && requiredMinRevision.compareTo(remoteDependency.getVersion()) > 0) {
                    logger.logWarning(String.format("Package \"%1$s\" with revision at least %2$s not available.", updatableDependency.getRepresentative().getDisplayName(), requiredMinRevision));
                    return null;
                }
                requiredPackages.add(remoteDependency);
                current2.add(remoteDependency);
            }
        }
        ArrayList<RemotePackage> result2 = Lists.newArrayList();
        while (!roots.isEmpty()) {
            RemotePackage root = (RemotePackage)roots.iterator().next();
            roots.remove(root);
            result2.add(root);
            for (Dependency d2 : root.getAllDependencies()) {
                Collection nodeDeps = allDependencies.get(d2.getPath());
                if (nodeDeps.size() == 1) {
                    UpdatablePackage newRoot = consolidatedPackages.get(d2.getPath());
                    if (newRoot == null) {
                        logger.logWarning(String.format("Package with key %s not found!", d2.getPath()));
                        return null;
                    }
                    roots.add(newRoot.getRemote());
                }
                nodeDeps.remove(d2);
            }
        }
        if (result2.size() != requiredPackages.size()) {
            logger.logInfo("Failed to sort dependencies, returning partially-sorted list.");
            for (RemotePackage p2 : result2) {
                requiredPackages.remove(p2);
            }
            result2.addAll(requiredPackages);
        }
        return Lists.reverse(result2);
    }

    public static boolean checkValidPath(Path path, RepoManager manager, ProgressIndicator progress) {
        String check = path.normalize() + File.separator;
        for (LocalPackage p2 : manager.getPackages().getLocalPackages().values()) {
            String existing = p2.getLocation().normalize() + File.separator;
            if (existing.equals(check)) continue;
            boolean childExists = existing.startsWith(check);
            boolean parentExists = check.startsWith(existing);
            if (!childExists && !parentExists) continue;
            String message2 = "Trying to install into " + check + " but package \"" + p2.getDisplayName() + "\" already exists at " + existing + ". It must be deleted or moved away before installing into a " + (childExists ? "parent" : "child") + " directory.";
            progress.logWarning(message2);
            return false;
        }
        return true;
    }
}

