/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum ScreenRatio implements ResourceEnum
{
    NOTLONG("notlong", "Not Long", "Short screen aspect ratio"),
    LONG("long", "Long", "Long screen aspect ratio");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private ScreenRatio(String value, String displayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = displayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static ScreenRatio getEnum(String value) {
        for (ScreenRatio orient : ScreenRatio.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(ScreenRatio value) {
        return value == null ? -1 : value.ordinal();
    }

    public static ScreenRatio getByIndex(int index2) {
        ScreenRatio[] values2 = ScreenRatio.values();
        if (index2 >= 0 && index2 < values2.length) {
            return values2[index2];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }

    public static ScreenRatio create(int width, int height) {
        int shortSide;
        int longSide = Math.max(width, height);
        if ((double)longSide / (double)(shortSide = Math.min(width, height)) >= 1.6666666666666667) {
            return LONG;
        }
        return NOTLONG;
    }
}

