/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.aar.AbstractAarResourceRepository;
import com.android.resources.aar.ProtoConfigurationDecoder;
import com.android.resources.aar.ProtoStyledStringDecoder;
import com.android.resources.base.BasicArrayResourceItem;
import com.android.resources.base.BasicAttrReference;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.BasicPluralsResourceItem;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicTextValueResourceItem;
import com.android.resources.base.BasicValueResourceItem;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSourceFile;
import com.android.resources.base.ResourceSourceFileImpl;
import com.android.resources.base.ResourceUrlParser;
import com.android.tools.environment.Logger;
import com.android.utils.DecimalUtils;
import com.android.utils.SdkUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import com.google.protobuf.ByteString;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AarProtoResourceRepository
extends AbstractAarResourceRepository {
    protected static final Predicate<ConfigurationOuterClass.Configuration> TRIVIAL_CONFIG_FILTER = config -> true;
    protected static final Predicate<ResourceType> TRIVIAL_RESOURCE_TYPE_FILTER = type -> true;
    private static final String APK_PROTOCOL = "apk";
    private static final String RESOURCE_TABLE_ENTRY = "resources.pb";
    private static final Logger LOG = Logger.getInstance(AarProtoResourceRepository.class);
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final String[] DIMEN_SUFFIXES = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_SUFFIXES = new String[]{"%", "%p"};
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final double[] RADIX_FACTORS = new double[]{1.0, 0.0078125, 3.0517578125E-5, 1.1920928955078125E-7};
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    protected final Path myResApkFile;
    private final String myResourcePathPrefix;
    private final String myResourceUrlPrefix;
    private final String mySourceAttachmentPrefix;

    protected AarProtoResourceRepository(Loader loader2, String libraryName, Path sourceJar) {
        super(loader2.myNamespace, libraryName);
        this.myResApkFile = loader2.myResApkFile;
        this.myResourcePathPrefix = this.myResApkFile + "!/";
        this.myResourceUrlPrefix = "apk://" + RepositoryLoader.portableFileName(this.myResApkFile.toString()) + "!/";
        this.mySourceAttachmentPrefix = sourceJar != null && loader2.myPackageName != null ? sourceJar + "!/" + AarProtoResourceRepository.getPackageNamePrefix(loader2.myPackageName) : null;
    }

    @Override
    public Path getOrigin() {
        return this.myResApkFile;
    }

    @Override
    public final String getPackageName() {
        return this.myNamespace.getPackageName();
    }

    public static AarProtoResourceRepository create(Path resApkFile, String libraryName) {
        Loader loader2 = new Loader(resApkFile, TRIVIAL_CONFIG_FILTER, TRIVIAL_RESOURCE_TYPE_FILTER);
        try {
            loader2.readApkFile();
        }
        catch (IOException e2) {
            LOG.error(e2);
            return new AarProtoResourceRepository(loader2, libraryName, null);
        }
        Path sourceJar = AarProtoResourceRepository.getSourceJarPath(resApkFile);
        if (!Files.exists(sourceJar, new LinkOption[0])) {
            sourceJar = null;
        }
        AarProtoResourceRepository repository = new AarProtoResourceRepository(loader2, libraryName, sourceJar);
        loader2.loadRepositoryContents(repository);
        return repository;
    }

    private static Path getSourceJarPath(Path resApkFile) {
        Object filename = resApkFile.getFileName().toString();
        int extensionPos = ((String)filename).lastIndexOf(46);
        if (extensionPos >= 0) {
            filename = ((String)filename).substring(0, extensionPos);
        }
        filename = (String)filename + "-src.jar";
        return resApkFile.resolveSibling((String)filename);
    }

    @Override
    public final String getResourceUrl(String relativeResourcePath) {
        return this.expandRelativeResourcePath(this.myResourceUrlPrefix, relativeResourcePath, true);
    }

    @Override
    public final PathString getSourceFile(String relativeResourcePath, boolean forFileResource) {
        return new PathString(APK_PROTOCOL, this.expandRelativeResourcePath(this.myResourcePathPrefix, relativeResourcePath, forFileResource));
    }

    private String expandRelativeResourcePath(String prefix, String relativeResourcePath, boolean forFileResource) {
        int offset = 0;
        if (this.hasOverlaySegment(relativeResourcePath, forFileResource)) {
            assert (Character.isDigit(relativeResourcePath.charAt(0)));
            offset = relativeResourcePath.indexOf(47) + 1;
        }
        int prefixLength = prefix.length();
        int pathLength = relativeResourcePath.length();
        char[] result2 = new char[prefixLength + pathLength - offset];
        prefix.getChars(0, prefixLength, result2, 0);
        relativeResourcePath.getChars(offset, pathLength, result2, prefixLength);
        return new String(result2);
    }

    private boolean hasOverlaySegment(String relativeResourcePath, boolean forFileResource) {
        return forFileResource && this.mySourceAttachmentPrefix != null && AarProtoResourceRepository.isXml(relativeResourcePath);
    }

    @Override
    public final PathString getOriginalSourceFile(String relativeResourcePath, boolean forFileResource) {
        if (AarProtoResourceRepository.isXml(relativeResourcePath)) {
            if (this.mySourceAttachmentPrefix == null) {
                return null;
            }
            return new PathString("jar", this.mySourceAttachmentPrefix + relativeResourcePath);
        }
        return this.getSourceFile(relativeResourcePath, forFileResource);
    }

    private static boolean isXml(String filePath) {
        return SdkUtils.endsWithIgnoreCase(filePath, ".xml");
    }

    private static String getPackageNamePrefix(String packageName) {
        return packageName.replace('.', '/') + "/";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResApkFile;
    }

    protected static class Loader {
        private final Path myResApkFile;
        private final Predicate<ConfigurationOuterClass.Configuration> myConfigFilter;
        private final Predicate<ResourceType> myResourceTypeFilter;
        private final ResourceUrlParser myUrlParser = new ResourceUrlParser();
        private final ListMultimap<String, BasicStyleableResourceItem> myStyleables = ArrayListMultimap.create();
        private final Table<String, ConfigurationOuterClass.Configuration, ResourceSourceFile> mySourceFileCache = HashBasedTable.create();
        private Resources.ResourceTable myResourceTableMsg;
        private String myPackageName;
        private ResourceNamespace myNamespace;

        Loader(Path resApkFile, Predicate<ConfigurationOuterClass.Configuration> configFilter, Predicate<ResourceType> resourceTypeFilter) {
            this.myResApkFile = resApkFile;
            this.myConfigFilter = configFilter;
            this.myResourceTypeFilter = resourceTypeFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readApkFile() throws IOException {
            ResourceNamespace resourceNamespace;
            try {
                try (ZipFile zipFile = new ZipFile(this.myResApkFile.toFile());){
                    this.myResourceTableMsg = Loader.readResourceTableFromResApk(zipFile);
                    this.myPackageName = AndroidManifestPackageNameUtils.getPackageNameFromResApk(zipFile);
                }
                resourceNamespace = this.myPackageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName(this.myPackageName);
            }
            catch (Throwable throwable) {
                this.myNamespace = this.myPackageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName(this.myPackageName);
                throw throwable;
            }
            this.myNamespace = resourceNamespace;
        }

        public void loadRepositoryContents(AarProtoResourceRepository repository) {
            if (this.myResourceTableMsg != null) {
                this.loadFromResourceTable(repository, this.myResourceTableMsg);
            }
        }

        private void loadFromResourceTable(AarProtoResourceRepository repository, Resources.ResourceTable resourceTableMsg) {
            StringPool stringPool = repository.mySourceAttachmentPrefix == null ? null : new StringPool(resourceTableMsg.getSourcePool(), this.myNamespace.getPackageName());
            for (Resources.Package packageMsg : resourceTableMsg.getPackageList()) {
                for (Resources.Type typeMsg : packageMsg.getTypeList()) {
                    String typeName = typeMsg.getName();
                    ResourceType resourceType = ResourceType.fromClassName(typeName);
                    if (resourceType == null) {
                        if (typeName.equals("^attr-private")) {
                            resourceType = ResourceType.ATTR;
                        } else {
                            LOG.warn("Unexpected resource type: " + typeName);
                            continue;
                        }
                    }
                    if (!this.myResourceTypeFilter.test(resourceType)) continue;
                    for (Resources.Entry entryMsg : typeMsg.getEntryList()) {
                        String resourceName = entryMsg.getName();
                        Resources.Visibility visibilityMsg = entryMsg.getVisibility();
                        ResourceVisibility visibility = Loader.decodeVisibility(visibilityMsg);
                        for (Resources.ConfigValue configValueMsg : entryMsg.getConfigValueList()) {
                            ResourceSourceFile sourceFile;
                            BasicResourceItem item;
                            ConfigurationOuterClass.Configuration configMsg;
                            String sourcePath2;
                            Resources.Value valueMsg = configValueMsg.getValue();
                            Resources.Source sourceMsg = valueMsg.getSource();
                            String string2 = sourcePath2 = stringPool == null ? null : stringPool.getString(sourceMsg.getPathIdx());
                            if (sourcePath2 != null && sourcePath2.isEmpty()) {
                                sourcePath2 = null;
                            }
                            if (!this.myConfigFilter.test(configMsg = configValueMsg.getConfig()) || (item = this.createResourceItem(valueMsg, resourceType, resourceName, sourceFile = this.getSourceFile(repository, sourcePath2, configMsg), visibility)) == null) continue;
                            this.addResourceItem(repository, item);
                        }
                    }
                }
            }
            for (BasicStyleableResourceItem styleable : this.myStyleables.values()) {
                repository.addResourceItem(RepositoryLoader.resolveAttrReferences(styleable));
            }
            repository.populatePublicResourcesMap();
            repository.freezeResources();
        }

        private void addResourceItem(AarProtoResourceRepository repository, ResourceItem item) {
            if (item.getType() == ResourceType.STYLEABLE) {
                this.myStyleables.put(item.getName(), (BasicStyleableResourceItem)item);
            } else {
                repository.addResourceItem(item);
            }
        }

        private BasicResourceItem createResourceItem(Resources.Value valueMsg, ResourceType resourceType, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
            switch (valueMsg.getValueCase()) {
                case ITEM: {
                    return this.createResourceItem(valueMsg.getItem(), resourceType, resourceName, sourceFile, visibility);
                }
                case COMPOUND_VALUE: {
                    String description = valueMsg.getComment();
                    if (CharMatcher.whitespace().matchesAllOf(description)) {
                        description = null;
                    }
                    return this.createResourceItem(valueMsg.getCompoundValue(), resourceName, sourceFile, visibility, description);
                }
            }
            LOG.warn("Unexpected Value message: " + valueMsg);
            return null;
        }

        private BasicResourceItem createResourceItem(Resources.Item itemMsg, ResourceType resourceType, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
            switch (itemMsg.getValueCase()) {
                case FILE: {
                    Density densityValue;
                    FolderConfiguration folderConfiguration;
                    DensityQualifier densityQualifier;
                    String path = sourceFile.getRelativePath();
                    if (path == null || !AarProtoResourceRepository.isXml(path)) {
                        path = itemMsg.getFile().getPath();
                    }
                    RepositoryConfiguration configuration = sourceFile.getConfiguration();
                    if (DensityBasedResourceValue.isDensityBasedResourceType(resourceType) && (densityQualifier = (folderConfiguration = configuration.getFolderConfiguration()).getDensityQualifier()) != null && (densityValue = densityQualifier.getValue()) != null) {
                        return new BasicDensityBasedFileResourceItem(resourceType, resourceName, configuration, visibility, path, densityValue);
                    }
                    return new BasicFileResourceItem(resourceType, resourceName, configuration, visibility, path);
                }
                case REF: {
                    String ref = this.decode(itemMsg.getRef());
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, ref);
                }
                case STR: {
                    String textValue = itemMsg.getStr().getValue();
                    return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue);
                }
                case RAW_STR: {
                    String str = itemMsg.getRawStr().getValue();
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, str);
                }
                case PRIM: {
                    String str = Loader.decode(itemMsg.getPrim());
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, str);
                }
                case STYLED_STR: {
                    Resources.StyledString styledStrMsg = itemMsg.getStyledStr();
                    String textValue = styledStrMsg.getValue();
                    String rawXmlValue = ProtoStyledStringDecoder.getRawXmlValue(styledStrMsg);
                    if (rawXmlValue.equals(textValue)) {
                        return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue);
                    }
                    return new BasicTextValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue, rawXmlValue);
                }
                case ID: {
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, null);
                }
            }
            LOG.warn("Unexpected Item message: " + itemMsg);
            return null;
        }

        private static BasicResourceItem createResourceItem(ResourceType resourceType, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility, String value) {
            return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, value);
        }

        private BasicResourceItem createResourceItem(Resources.CompoundValue compoundValueMsg, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility, String description) {
            switch (compoundValueMsg.getValueCase()) {
                case ATTR: {
                    return Loader.createAttr(compoundValueMsg.getAttr(), resourceName, sourceFile, visibility, description);
                }
                case STYLE: {
                    return this.createStyle(compoundValueMsg.getStyle(), resourceName, sourceFile, visibility);
                }
                case STYLEABLE: {
                    return this.createStyleable(compoundValueMsg.getStyleable(), resourceName, sourceFile, visibility);
                }
                case ARRAY: {
                    return this.createArray(compoundValueMsg.getArray(), resourceName, sourceFile, visibility);
                }
                case PLURAL: {
                    return this.createPlurals(compoundValueMsg.getPlural(), resourceName, sourceFile, visibility);
                }
            }
            LOG.warn("Unexpected CompoundValue message: " + compoundValueMsg);
            return null;
        }

        private static BasicAttrResourceItem createAttr(Resources.Attribute attributeMsg, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility, String description) {
            Set<AttributeFormat> formats = Loader.decodeFormatFlags(attributeMsg.getFormatFlags());
            List symbolList = attributeMsg.getSymbolList();
            Map<String, Integer> valueMap = Collections.emptyMap();
            Map<String, String> valueDescriptionMap = Collections.emptyMap();
            for (Resources.Attribute.Symbol symbolMsg : symbolList) {
                String name2 = symbolMsg.getName().getName();
                int slashPos = name2.lastIndexOf(47);
                if (slashPos >= 0) {
                    name2 = name2.substring(slashPos + 1);
                }
                String symbolDescription = symbolMsg.getComment();
                if (CharMatcher.whitespace().matchesAllOf(symbolDescription)) {
                    symbolDescription = null;
                }
                if (valueMap.isEmpty()) {
                    valueMap = new HashMap<String, Integer>();
                }
                valueMap.put(name2, symbolMsg.getValue());
                if (symbolDescription == null) continue;
                if (valueDescriptionMap.isEmpty()) {
                    valueDescriptionMap = new HashMap<String, String>();
                }
                valueDescriptionMap.put(name2, symbolDescription);
            }
            String groupName = null;
            return new BasicAttrResourceItem(resourceName, sourceFile, visibility, description, groupName, formats, valueMap, valueDescriptionMap);
        }

        private BasicStyleResourceItem createStyle(Resources.Style styleMsg, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
            String libraryName = sourceFile.getRepository().getLibraryName();
            this.myUrlParser.parseResourceUrl(styleMsg.getParent().getName());
            String parentStyle = this.myUrlParser.getQualifiedName();
            if (StyleResourceValue.isDefaultParentStyleName(parentStyle, resourceName)) {
                parentStyle = null;
            }
            ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>(styleMsg.getEntryCount());
            for (Resources.Style.Entry entryMsg : styleMsg.getEntryList()) {
                String url = entryMsg.getKey().getName();
                this.myUrlParser.parseResourceUrl(url);
                String name2 = this.myUrlParser.getQualifiedName();
                String value = this.decode(entryMsg.getItem());
                StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(this.myNamespace, name2, value, libraryName);
                styleItems.add(itemValue);
            }
            return new BasicStyleResourceItem(resourceName, sourceFile, visibility, parentStyle, styleItems);
        }

        private BasicStyleableResourceItem createStyleable(Resources.Styleable styleableMsg, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
            ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>(styleableMsg.getEntryCount());
            for (Resources.Styleable.Entry entryMsg : styleableMsg.getEntryList()) {
                String url = entryMsg.getAttr().getName();
                this.myUrlParser.parseResourceUrl(url);
                String packageName = this.myUrlParser.getNamespacePrefix();
                ResourceNamespace attrNamespace = packageName == null ? this.myNamespace : ResourceNamespace.fromPackageName(packageName);
                String comment = entryMsg.getComment();
                BasicAttrReference attr = new BasicAttrReference(attrNamespace, this.myUrlParser.getName(), sourceFile, visibility, comment.isEmpty() ? null : comment, null);
                attrs.add(attr);
            }
            return new BasicStyleableResourceItem(resourceName, sourceFile, visibility, attrs);
        }

        private BasicArrayResourceItem createArray(Resources.Array arrayMsg, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
            ArrayList<String> elements = new ArrayList<String>(arrayMsg.getElementCount());
            for (Resources.Array.Element elementMsg : arrayMsg.getElementList()) {
                String text = this.decode(elementMsg.getItem());
                if (text == null) continue;
                elements.add(text);
            }
            return new BasicArrayResourceItem(resourceName, sourceFile, visibility, elements, 0);
        }

        private BasicPluralsResourceItem createPlurals(Resources.Plural pluralMsg, String resourceName, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
            EnumMap<Arity, String> values2 = new EnumMap<Arity, String>(Arity.class);
            for (Resources.Plural.Entry entryMsg : pluralMsg.getEntryList()) {
                values2.put(Loader.decodeArity(entryMsg.getArity()), this.decode(entryMsg.getItem()));
            }
            return new BasicPluralsResourceItem(resourceName, sourceFile, visibility, values2, null);
        }

        private ResourceSourceFile getSourceFile(AarProtoResourceRepository repository, String sourcePath2, ConfigurationOuterClass.Configuration configMsg) {
            String sourcePathKey = sourcePath2 == null ? "" : sourcePath2;
            ResourceSourceFile sourceFile = this.mySourceFileCache.get(sourcePathKey, configMsg);
            if (sourceFile != null) {
                return sourceFile;
            }
            FolderConfiguration configuration = ProtoConfigurationDecoder.getConfiguration(configMsg);
            configuration.normalizeByRemovingRedundantVersionQualifier();
            sourceFile = new ResourceSourceFileImpl(sourcePath2, new RepositoryConfiguration(repository, configuration));
            this.mySourceFileCache.put(sourcePathKey, configMsg, sourceFile);
            return sourceFile;
        }

        private String decode(Resources.Item itemMsg) {
            switch (itemMsg.getValueCase()) {
                case REF: {
                    return this.decode(itemMsg.getRef());
                }
                case STR: {
                    return itemMsg.getStr().getValue();
                }
                case RAW_STR: {
                    return itemMsg.getRawStr().getValue();
                }
                case STYLED_STR: {
                    return itemMsg.getStyledStr().getValue();
                }
                case FILE: {
                    return itemMsg.getFile().getPath();
                }
                case ID: {
                    return null;
                }
                case PRIM: {
                    return Loader.decode(itemMsg.getPrim());
                }
            }
            return null;
        }

        private String decode(Resources.Reference referenceMsg) {
            String name2 = referenceMsg.getName();
            if (name2.isEmpty()) {
                return "";
            }
            if (referenceMsg.getType() == Resources.Reference.Type.ATTRIBUTE) {
                this.myUrlParser.parseResourceUrl(name2);
                if (this.myUrlParser.hasType(ResourceType.ATTR.getName())) {
                    name2 = this.myUrlParser.getQualifiedName();
                }
                return "?" + name2;
            }
            return "@" + name2;
        }

        private static String decode(Resources.Primitive primitiveMsg) {
            switch (primitiveMsg.getOneofValueCase()) {
                case NULL_VALUE: {
                    return null;
                }
                case EMPTY_VALUE: {
                    return "";
                }
                case FLOAT_VALUE: {
                    return DecimalUtils.trimInsignificantZeros(Float.toString(primitiveMsg.getFloatValue()));
                }
                case DIMENSION_VALUE: {
                    return Loader.decodeComplexDimensionValue(primitiveMsg.getDimensionValue(), 1.0, DIMEN_SUFFIXES);
                }
                case FRACTION_VALUE: {
                    return Loader.decodeComplexDimensionValue(primitiveMsg.getFractionValue(), 100.0, FRACTION_SUFFIXES);
                }
                case INT_DECIMAL_VALUE: {
                    return Integer.toString(primitiveMsg.getIntDecimalValue());
                }
                case INT_HEXADECIMAL_VALUE: {
                    return String.format("0x%X", primitiveMsg.getIntHexadecimalValue());
                }
                case BOOLEAN_VALUE: {
                    return Boolean.toString(primitiveMsg.getBooleanValue());
                }
                case COLOR_ARGB8_VALUE: {
                    return String.format("#%08X", primitiveMsg.getColorArgb8Value());
                }
                case COLOR_RGB8_VALUE: {
                    return String.format("#%06X", primitiveMsg.getColorRgb8Value() & 0xFFFFFF);
                }
                case COLOR_ARGB4_VALUE: {
                    int argb = primitiveMsg.getColorArgb4Value();
                    return String.format("#%X%X%X%X", argb >>> 24 & 0xF, argb >>> 16 & 0xF, argb >>> 8 & 0xF, argb & 0xF);
                }
                case COLOR_RGB4_VALUE: {
                    int rgb = primitiveMsg.getColorRgb4Value();
                    return String.format("#%X%X%X", rgb >>> 16 & 0xF, rgb >>> 8 & 0xF, rgb & 0xF);
                }
            }
            LOG.warn("Unexpected Primitive message: " + primitiveMsg);
            return null;
        }

        private static String decodeComplexDimensionValue(int bits, double scaleFactor, String[] unitSuffixes) {
            int unitCode = bits & 0xF;
            Object unit = unitCode < unitSuffixes.length ? unitSuffixes[unitCode] : " unknown unit: " + unitCode;
            int radix = bits >> 4 & 3;
            int mantissa = bits >> 8;
            double value = (double)mantissa * RADIX_FACTORS[radix] * scaleFactor;
            return DecimalUtils.trimInsignificantZeros(String.format(Locale.US, "%.5g", value)) + (String)unit;
        }

        private static boolean isBitSet(int value, int bitMask) {
            return (value & bitMask) == bitMask;
        }

        private static Set<AttributeFormat> decodeFormatFlags(int flags) {
            EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
            if (Loader.isBitSet(flags, 1)) {
                result2.add(AttributeFormat.REFERENCE);
            }
            if (Loader.isBitSet(flags, 2)) {
                result2.add(AttributeFormat.STRING);
            }
            if (Loader.isBitSet(flags, 4)) {
                result2.add(AttributeFormat.INTEGER);
            }
            if (Loader.isBitSet(flags, 8)) {
                result2.add(AttributeFormat.BOOLEAN);
            }
            if (Loader.isBitSet(flags, 16)) {
                result2.add(AttributeFormat.COLOR);
            }
            if (Loader.isBitSet(flags, 32)) {
                result2.add(AttributeFormat.FLOAT);
            }
            if (Loader.isBitSet(flags, 64)) {
                result2.add(AttributeFormat.DIMENSION);
            }
            if (Loader.isBitSet(flags, 128)) {
                result2.add(AttributeFormat.FRACTION);
            }
            if (Loader.isBitSet(flags, 65536)) {
                result2.add(AttributeFormat.ENUM);
            }
            if (Loader.isBitSet(flags, 131072)) {
                result2.add(AttributeFormat.FLAGS);
            }
            return result2;
        }

        private static Arity decodeArity(Resources.Plural.Arity arity) {
            switch (arity) {
                case ZERO: {
                    return Arity.ZERO;
                }
                case ONE: {
                    return Arity.ONE;
                }
                case TWO: {
                    return Arity.TWO;
                }
                case FEW: {
                    return Arity.FEW;
                }
                case MANY: {
                    return Arity.MANY;
                }
            }
            return Arity.OTHER;
        }

        private static ResourceVisibility decodeVisibility(Resources.Visibility visibilityMsg) {
            switch (visibilityMsg.getLevel()) {
                case UNKNOWN: {
                    return ResourceVisibility.PRIVATE_XML_ONLY;
                }
                case PRIVATE: {
                    return ResourceVisibility.PRIVATE;
                }
                case PUBLIC: {
                    return ResourceVisibility.PUBLIC;
                }
            }
            return ResourceVisibility.UNDEFINED;
        }

        private static Resources.ResourceTable readResourceTableFromResApk(ZipFile resApk) throws IOException {
            ZipEntry zipEntry = resApk.getEntry(AarProtoResourceRepository.RESOURCE_TABLE_ENTRY);
            if (zipEntry == null) {
                throw new IOException("\"resources.pb\" not found in " + resApk.getName());
            }
            try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
                Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)stream);
                return resourceTable;
            }
        }
    }

    private static class StringPool {
        private static final int STRING_COUNT_OFFSET = 8;
        private static final int FLAGS_OFFSET = 16;
        private static final int STRINGS_START_INDEX_OFFSET = 20;
        private static final int UTF8_FLAG = 256;
        private static final String REPLACEMENT_PREFIX = "0/res/";
        final String[] strings;
        private int currentOffset;

        StringPool(Resources.StringPool stringPoolMsg, String packageName) {
            ByteString bytes2 = stringPoolMsg.getData();
            if ((StringPool.getInt32(bytes2, 16) & 0x100) == 0) {
                throw new IllegalArgumentException("UTF-16 encoded string pool is not supported");
            }
            int stringCount = StringPool.getInt32(bytes2, 8);
            this.strings = new String[stringCount];
            this.currentOffset = StringPool.getInt32(bytes2, 20);
            for (int i2 = 0; i2 < stringCount; ++i2) {
                this.getByteEncodedLength(bytes2);
                int byteCount = this.getByteEncodedLength(bytes2);
                int endOffset = this.currentOffset + byteCount;
                this.strings[i2] = bytes2.substring(this.currentOffset, endOffset).toStringUtf8();
                this.currentOffset = endOffset + 1;
            }
            this.normalizePaths(packageName);
        }

        private static int getByte(ByteString bytes2, int offset) {
            return bytes2.byteAt(offset) & 0xFF;
        }

        private static int getInt32(ByteString bytes2, int offset) {
            return StringPool.getByte(bytes2, offset) | StringPool.getByte(bytes2, offset + 1) << 8 | StringPool.getByte(bytes2, offset + 2) << 16 | StringPool.getByte(bytes2, offset + 3) << 24;
        }

        private int getByteEncodedLength(ByteString bytes2) {
            int b2;
            if (((b2 = StringPool.getByte(bytes2, this.currentOffset++)) & 0x80) == 0) {
                return b2;
            }
            return (b2 & 0x7F) << 8 | StringPool.getByte(bytes2, this.currentOffset++);
        }

        /*
         * WARNING - void declaration
         */
        private void normalizePaths(String packageName) {
            String packagePrefix = packageName == null ? null : AarProtoResourceRepository.getPackageNamePrefix(packageName);
            String prefix = null;
            for (String string2 : this.strings) {
                void var6_11;
                if (string2.isEmpty()) continue;
                String string3 = RepositoryLoader.portableFileName(string2);
                if (string3.charAt(0) == '/') {
                    String anchor;
                    int pos;
                    if (prefix == null && (pos = string3.indexOf(anchor = "/res/")) >= 0) {
                        prefix = string3.substring(0, pos + anchor.length());
                    }
                    if (prefix == null && (pos = string3.indexOf(anchor = "/namespaced_res/")) >= 0 && (pos = string3.indexOf(47, pos + anchor.length())) >= 0) {
                        prefix = string3.substring(0, pos + 1);
                    }
                    if (prefix != null && string3.startsWith(prefix)) {
                        String string4 = REPLACEMENT_PREFIX + string3.substring(prefix.length());
                    }
                } else if (packagePrefix != null && string3.startsWith(packagePrefix)) {
                    String string5 = string3.substring(packagePrefix.length());
                }
                this.strings[i] = var6_11;
            }
        }

        public String getString(int index2) {
            return this.strings[index2];
        }
    }
}

