/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.aar.AarResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAarResourceRepository
extends AbstractResourceRepository
implements AarResourceRepository {
    protected final ResourceNamespace myNamespace;
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    private final Map<ResourceType, Set<ResourceItem>> myPublicResources = new EnumMap<ResourceType, Set<ResourceItem>>(ResourceType.class);
    protected final String myLibraryName;

    AbstractAarResourceRepository(ResourceNamespace namespace, String libraryName) {
        this.myNamespace = namespace;
        this.myLibraryName = libraryName;
    }

    @Override
    protected final ListMultimap<String, ResourceItem> getResourcesInternal(ResourceNamespace namespace, ResourceType resourceType) {
        if (!namespace.equals(this.myNamespace)) {
            return ImmutableListMultimap.of();
        }
        return this.myResources.getOrDefault((Object)resourceType, ImmutableListMultimap.of());
    }

    private ListMultimap<String, ResourceItem> getOrCreateMap(ResourceType resourceType) {
        return this.myResources.computeIfAbsent(resourceType, type -> ArrayListMultimap.create());
    }

    protected final void addResourceItem(ResourceItem item) {
        ListMultimap<String, ResourceItem> multimap = this.getOrCreateMap(item.getType());
        multimap.put(item.getName(), item);
    }

    protected final void populatePublicResourcesMap() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            ResourceType resourceType = entry.getKey();
            ImmutableSet.Builder setBuilder = null;
            ListMultimap<String, ResourceItem> items = entry.getValue();
            for (ResourceItem item : items.values()) {
                if (((ResourceItemWithVisibility)item).getVisibility() != ResourceVisibility.PUBLIC) continue;
                if (setBuilder == null) {
                    setBuilder = ImmutableSet.builder();
                }
                setBuilder.add(item);
            }
            this.myPublicResources.put(resourceType, (Set<ResourceItem>)((Object)(setBuilder == null ? ImmutableSet.of() : setBuilder.build())));
        }
    }

    protected void freezeResources() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            this.myResources.put(entry.getKey(), ImmutableListMultimap.copyOf((Multimap)entry.getValue()));
        }
    }

    @Override
    public ResourceVisitor.VisitResult accept(ResourceVisitor visitor) {
        if (visitor.shouldVisitNamespace(this.myNamespace) && AbstractResourceRepository.acceptByResources(this.myResources, visitor) == ResourceVisitor.VisitResult.ABORT) {
            return ResourceVisitor.VisitResult.ABORT;
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    public List<ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType, String resourceName) {
        ListMultimap<String, ResourceItem> map2 = this.getResourcesInternal(namespace, resourceType);
        Collection items = map2.get((Object)resourceName);
        return items == null ? ImmutableList.of() : items;
    }

    @Override
    public ListMultimap<String, ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType) {
        return this.getResourcesInternal(namespace, resourceType);
    }

    @Override
    public Collection<ResourceItem> getPublicResources(ResourceNamespace namespace, ResourceType type) {
        if (!namespace.equals(this.myNamespace)) {
            return Collections.emptySet();
        }
        Set<ResourceItem> resourceItems = this.myPublicResources.get((Object)type);
        return resourceItems == null ? Collections.emptySet() : resourceItems;
    }

    @Override
    public final ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Override
    public final String getLibraryName() {
        return this.myLibraryName;
    }

    @Override
    public final String getDisplayName() {
        return this.myLibraryName == null ? "Android Framework" : this.myLibraryName;
    }

    @Override
    public final boolean containsUserDefinedResources() {
        return false;
    }
}

