/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.resources.aar.FrameworkResourceRepository;
import com.android.utils.Base128OutputStream;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FrameworkResJarCreator {
    public static void main(String[] args2) {
        if (args2.length != 2) {
            FrameworkResJarCreator.printUsage(FrameworkResJarCreator.class.getName());
            System.exit(1);
        }
        Path resDirectory = Paths.get(args2[0], new String[0]).toAbsolutePath().normalize();
        Path jarFile = Paths.get(args2[1], new String[0]).toAbsolutePath().normalize();
        try {
            FrameworkResJarCreator.createJar(resDirectory, jarFile);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @VisibleForTesting
    static void createJar(Path resDirectory, Path jarFile) throws IOException {
        FrameworkResourceRepository repository = FrameworkResourceRepository.create(resDirectory, null, null, false);
        Set<String> languages = repository.getLanguageGroups();
        try (ZipOutputStream zip2 = new ZipOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            for (String language : languages) {
                String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                FrameworkResJarCreator.createZipEntry(entryName, FrameworkResJarCreator.getEncodedResources(repository, language), zip2);
            }
            Path parentDir = resDirectory.getParent();
            List<Path> files2 = FrameworkResJarCreator.getContainedFiles(resDirectory);
            for (Path file2 : files2) {
                String relativePath = parentDir.relativize(file2).toString().replace('\\', '/');
                if (relativePath.equals("res/version") || relativePath.equals("res/BUILD")) continue;
                FrameworkResJarCreator.createZipEntry(relativePath, Files.readAllBytes(file2), zip2);
            }
        }
    }

    private static List<Path> getContainedFiles(Path resDirectory) throws IOException {
        final ArrayList<Path> files2 = new ArrayList<Path>();
        Files.walkFileTree(resDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                files2.add(file2);
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(files2);
        return files2;
    }

    private static void createZipEntry(String name2, byte[] content, ZipOutputStream zip2) throws IOException {
        ZipEntry entry = new ZipEntry(name2);
        zip2.putNextEntry(entry);
        zip2.write(content);
        zip2.closeEntry();
    }

    private static byte[] getEncodedResources(FrameworkResourceRepository repository, String language) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(byteStream);){
            repository.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config)));
        }
        return byteStream.toByteArray();
    }

    private static void printUsage(String programName) {
        System.out.printf("Usage: %s <res_directory> <jar_file>%n", programName);
    }
}

