/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.aapt.ConfigurationOuterClass;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.HighDynamicRangeQualifier;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.resources.configuration.WideGamutColorQualifier;
import com.android.resources.Density;
import com.android.resources.HighDynamicRange;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.resources.WideGamutColor;

class ProtoConfigurationDecoder {
    static FolderConfiguration getConfiguration(ConfigurationOuterClass.Configuration configMsg) {
        int sdkVersion;
        Navigation navigation;
        NavigationState navigationState;
        Keyboard keyboard;
        KeyboardState keyboardState;
        TouchScreen touchScreen;
        int densityDpi;
        NightMode nightMode;
        UiMode uiMode;
        ScreenOrientation screenOrientation;
        HighDynamicRange highDynamicRange;
        WideGamutColor wideGamutColor;
        ScreenRound screenRound;
        ScreenRatio screenRatio;
        ScreenSize screenSize;
        int smallestScreenWidthDp;
        int screenHeightDp;
        int screenWidthDp;
        LayoutDirection layoutDirection;
        Object locale;
        int mnc;
        FolderConfiguration configuration = new FolderConfiguration();
        int mcc = configMsg.getMcc();
        if (mcc != 0) {
            configuration.setCountryCodeQualifier(new CountryCodeQualifier(mcc));
        }
        if ((mnc = configMsg.getMnc()) != 0) {
            configuration.setNetworkCodeQualifier(new NetworkCodeQualifier(mnc));
        }
        if (!((String)(locale = configMsg.getLocale())).isEmpty()) {
            LocaleQualifier qualifier = LocaleQualifier.getQualifier((String)locale);
            if (qualifier == null) {
                locale = "b+" + ((String)locale).replace('-', '+');
                qualifier = LocaleQualifier.getQualifier((String)locale);
            }
            configuration.setLocaleQualifier(qualifier);
        }
        if ((layoutDirection = ProtoConfigurationDecoder.getLayoutDirection(configMsg.getLayoutDirection())) != null) {
            configuration.setLayoutDirectionQualifier(new LayoutDirectionQualifier(layoutDirection));
        }
        if ((screenWidthDp = configMsg.getScreenWidthDp()) != 0) {
            configuration.setScreenWidthQualifier(new ScreenWidthQualifier(screenWidthDp));
        }
        if ((screenHeightDp = configMsg.getScreenHeightDp()) != 0) {
            configuration.setScreenHeightQualifier(new ScreenHeightQualifier(screenHeightDp));
        }
        if ((smallestScreenWidthDp = configMsg.getSmallestScreenWidthDp()) != 0) {
            configuration.setSmallestScreenWidthQualifier(new SmallestScreenWidthQualifier(smallestScreenWidthDp));
        }
        if ((screenSize = ProtoConfigurationDecoder.getScreenSize(configMsg.getScreenLayoutSize())) != null) {
            configuration.setScreenSizeQualifier(new ScreenSizeQualifier(screenSize));
        }
        if ((screenRatio = ProtoConfigurationDecoder.getScreenRatio(configMsg.getScreenLayoutLong())) != null) {
            configuration.setScreenRatioQualifier(new ScreenRatioQualifier(screenRatio));
        }
        if ((screenRound = ProtoConfigurationDecoder.getScreenRound(configMsg.getScreenRound())) != null) {
            configuration.setScreenRoundQualifier(new ScreenRoundQualifier(screenRound));
        }
        if ((wideGamutColor = ProtoConfigurationDecoder.getWideGamutColor(configMsg.getWideColorGamut())) != null) {
            configuration.setWideColorGamutQualifier(new WideGamutColorQualifier(wideGamutColor));
        }
        if ((highDynamicRange = ProtoConfigurationDecoder.getHighDynamicRange(configMsg.getHdr())) != null) {
            configuration.setHighDynamicRangeQualifier(new HighDynamicRangeQualifier(highDynamicRange));
        }
        if ((screenOrientation = ProtoConfigurationDecoder.getScreenOrientation(configMsg.getOrientation())) != null) {
            configuration.setScreenOrientationQualifier(new ScreenOrientationQualifier(screenOrientation));
        }
        if ((uiMode = ProtoConfigurationDecoder.getUiMode(configMsg.getUiModeType())) != null) {
            configuration.setUiModeQualifier(new UiModeQualifier(uiMode));
        }
        if ((nightMode = ProtoConfigurationDecoder.getNightMode(configMsg.getUiModeNight())) != null) {
            configuration.setNightModeQualifier(new NightModeQualifier(nightMode));
        }
        if ((densityDpi = configMsg.getDensity()) != 0) {
            configuration.setDensityQualifier(new DensityQualifier(Density.create(densityDpi)));
        }
        if ((touchScreen = ProtoConfigurationDecoder.getTouchScreen(configMsg.getTouchscreen())) != null) {
            configuration.setTouchTypeQualifier(new TouchScreenQualifier(touchScreen));
        }
        if ((keyboardState = ProtoConfigurationDecoder.getKeyboardState(configMsg.getKeysHidden())) != null) {
            configuration.setKeyboardStateQualifier(new KeyboardStateQualifier(keyboardState));
        }
        if ((keyboard = ProtoConfigurationDecoder.getKeyboard(configMsg.getKeyboard())) != null) {
            configuration.setTextInputMethodQualifier(new TextInputMethodQualifier(keyboard));
        }
        if ((navigationState = ProtoConfigurationDecoder.getNavigationState(configMsg.getNavHidden())) != null) {
            configuration.setNavigationStateQualifier(new NavigationStateQualifier(navigationState));
        }
        if ((navigation = ProtoConfigurationDecoder.getNavigation(configMsg.getNavigation())) != null) {
            configuration.setNavigationMethodQualifier(new NavigationMethodQualifier(navigation));
        }
        if ((sdkVersion = configMsg.getSdkVersion()) != 0) {
            configuration.setVersionQualifier(new VersionQualifier(sdkVersion));
        }
        return configuration;
    }

    private static LayoutDirection getLayoutDirection(ConfigurationOuterClass.Configuration.LayoutDirection protoValue) {
        switch (protoValue) {
            case LAYOUT_DIRECTION_LTR: {
                return LayoutDirection.LTR;
            }
            case LAYOUT_DIRECTION_RTL: {
                return LayoutDirection.RTL;
            }
        }
        return null;
    }

    private static ScreenSize getScreenSize(ConfigurationOuterClass.Configuration.ScreenLayoutSize protoValue) {
        switch (protoValue) {
            case SCREEN_LAYOUT_SIZE_SMALL: {
                return ScreenSize.SMALL;
            }
            case SCREEN_LAYOUT_SIZE_NORMAL: {
                return ScreenSize.NORMAL;
            }
            case SCREEN_LAYOUT_SIZE_LARGE: {
                return ScreenSize.LARGE;
            }
            case SCREEN_LAYOUT_SIZE_XLARGE: {
                return ScreenSize.XLARGE;
            }
        }
        return null;
    }

    private static ScreenRatio getScreenRatio(ConfigurationOuterClass.Configuration.ScreenLayoutLong protoValue) {
        switch (protoValue) {
            case SCREEN_LAYOUT_LONG_NOTLONG: {
                return ScreenRatio.NOTLONG;
            }
            case SCREEN_LAYOUT_LONG_LONG: {
                return ScreenRatio.LONG;
            }
        }
        return null;
    }

    private static ScreenRound getScreenRound(ConfigurationOuterClass.Configuration.ScreenRound protoValue) {
        switch (protoValue) {
            case SCREEN_ROUND_NOTROUND: {
                return ScreenRound.NOTROUND;
            }
            case SCREEN_ROUND_ROUND: {
                return ScreenRound.ROUND;
            }
        }
        return null;
    }

    private static WideGamutColor getWideGamutColor(ConfigurationOuterClass.Configuration.WideColorGamut protoValue) {
        switch (protoValue) {
            case WIDE_COLOR_GAMUT_WIDECG: {
                return WideGamutColor.WIDECG;
            }
            case WIDE_COLOR_GAMUT_NOWIDECG: {
                return WideGamutColor.NOWIDECG;
            }
        }
        return null;
    }

    private static HighDynamicRange getHighDynamicRange(ConfigurationOuterClass.Configuration.Hdr protoValue) {
        switch (protoValue) {
            case HDR_HIGHDR: {
                return HighDynamicRange.HIGHDR;
            }
            case HDR_LOWDR: {
                return HighDynamicRange.LOWDR;
            }
        }
        return null;
    }

    private static ScreenOrientation getScreenOrientation(ConfigurationOuterClass.Configuration.Orientation protoValue) {
        switch (protoValue) {
            case ORIENTATION_PORT: {
                return ScreenOrientation.PORTRAIT;
            }
            case ORIENTATION_LAND: {
                return ScreenOrientation.LANDSCAPE;
            }
            case ORIENTATION_SQUARE: {
                return ScreenOrientation.SQUARE;
            }
        }
        return null;
    }

    private static UiMode getUiMode(ConfigurationOuterClass.Configuration.UiModeType protoValue) {
        switch (protoValue) {
            case UI_MODE_TYPE_NORMAL: {
                return UiMode.NORMAL;
            }
            case UI_MODE_TYPE_CAR: {
                return UiMode.CAR;
            }
            case UI_MODE_TYPE_DESK: {
                return UiMode.DESK;
            }
            case UI_MODE_TYPE_TELEVISION: {
                return UiMode.TELEVISION;
            }
            case UI_MODE_TYPE_APPLIANCE: {
                return UiMode.APPLIANCE;
            }
            case UI_MODE_TYPE_WATCH: {
                return UiMode.WATCH;
            }
            case UI_MODE_TYPE_VRHEADSET: {
                return UiMode.VR_HEADSET;
            }
        }
        return null;
    }

    private static NightMode getNightMode(ConfigurationOuterClass.Configuration.UiModeNight protoValue) {
        switch (protoValue) {
            case UI_MODE_NIGHT_NOTNIGHT: {
                return NightMode.NOTNIGHT;
            }
            case UI_MODE_NIGHT_NIGHT: {
                return NightMode.NIGHT;
            }
        }
        return null;
    }

    private static TouchScreen getTouchScreen(ConfigurationOuterClass.Configuration.Touchscreen protoValue) {
        switch (protoValue) {
            case TOUCHSCREEN_NOTOUCH: {
                return TouchScreen.NOTOUCH;
            }
            case TOUCHSCREEN_STYLUS: {
                return TouchScreen.STYLUS;
            }
            case TOUCHSCREEN_FINGER: {
                return TouchScreen.FINGER;
            }
        }
        return null;
    }

    private static KeyboardState getKeyboardState(ConfigurationOuterClass.Configuration.KeysHidden protoValue) {
        switch (protoValue) {
            case KEYS_HIDDEN_KEYSEXPOSED: {
                return KeyboardState.EXPOSED;
            }
            case KEYS_HIDDEN_KEYSHIDDEN: {
                return KeyboardState.HIDDEN;
            }
            case KEYS_HIDDEN_KEYSSOFT: {
                return KeyboardState.SOFT;
            }
        }
        return null;
    }

    private static Keyboard getKeyboard(ConfigurationOuterClass.Configuration.Keyboard protoValue) {
        switch (protoValue) {
            case KEYBOARD_NOKEYS: {
                return Keyboard.NOKEY;
            }
            case KEYBOARD_QWERTY: {
                return Keyboard.QWERTY;
            }
            case KEYBOARD_TWELVEKEY: {
                return Keyboard.TWELVEKEY;
            }
        }
        return null;
    }

    private static NavigationState getNavigationState(ConfigurationOuterClass.Configuration.NavHidden protoValue) {
        switch (protoValue) {
            case NAV_HIDDEN_NAVEXPOSED: {
                return NavigationState.EXPOSED;
            }
            case NAV_HIDDEN_NAVHIDDEN: {
                return NavigationState.HIDDEN;
            }
        }
        return null;
    }

    private static Navigation getNavigation(ConfigurationOuterClass.Configuration.Navigation protoValue) {
        switch (protoValue) {
            case NAVIGATION_NONAV: {
                return Navigation.NONAV;
            }
            case NAVIGATION_DPAD: {
                return Navigation.DPAD;
            }
            case NAVIGATION_TRACKBALL: {
                return Navigation.TRACKBALL;
            }
            case NAVIGATION_WHEEL: {
                return Navigation.WHEEL;
            }
        }
        return null;
    }

    private ProtoConfigurationDecoder() {
    }
}

