/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.aapt.Resources;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.List;

class ProtoStyledStringDecoder {
    public static String getRawXmlValue(Resources.StyledString styledStringMsg) {
        String text = styledStringMsg.getValue();
        StringBuilder xmlValue = new StringBuilder(text.length() * 2);
        List spanList = styledStringMsg.getSpanList();
        ArrayList<Resources.StyledString.Span> spanStack = new ArrayList<Resources.StyledString.Span>(spanList.size());
        int offset = 0;
        for (int i2 = 0; i2 <= styledStringMsg.getSpanCount(); ++i2) {
            String tagText;
            int pos;
            Resources.StyledString.Span spanMsg;
            int oldOffset = offset;
            if (i2 < styledStringMsg.getSpanCount()) {
                spanMsg = styledStringMsg.getSpan(i2);
                offset = spanMsg.getFirstChar();
            } else {
                spanMsg = null;
                offset = text.length();
            }
            while (!spanStack.isEmpty() && ((Resources.StyledString.Span)spanStack.get(spanStack.size() - 1)).getLastChar() < offset) {
                Resources.StyledString.Span span = (Resources.StyledString.Span)spanStack.remove(spanStack.size() - 1);
                int spanEnd = span.getLastChar() + 1;
                if (spanEnd > oldOffset) {
                    XmlUtils.appendXmlTextValue(xmlValue, text, oldOffset, spanEnd);
                    oldOffset = spanEnd;
                }
                String tagText2 = span.getTag();
                int tagEnd = ProtoStyledStringDecoder.indexOfOrEnd(tagText2, ';', 0);
                xmlValue.append("</").append(tagText2, 0, tagEnd).append('>');
            }
            if (offset < oldOffset) continue;
            XmlUtils.appendXmlTextValue(xmlValue, text, oldOffset, offset);
            if (spanMsg == null || (pos = ProtoStyledStringDecoder.indexOfOrEnd(tagText = spanMsg.getTag(), ';', 0)) == 0) continue;
            spanStack.add(spanMsg);
            xmlValue.append('<').append(tagText, 0, pos);
            while (pos < tagText.length()) {
                int nextPos = ProtoStyledStringDecoder.indexOfOrEnd(tagText, ';', ++pos);
                int nameEnd = tagText.indexOf(61, pos);
                if (nameEnd > pos && nameEnd < nextPos) {
                    xmlValue.append(' ');
                    xmlValue.append(tagText, pos, nameEnd + 1);
                    xmlValue.append('\"');
                    XmlUtils.appendXmlAttributeValue(xmlValue, tagText, nameEnd + 1, nextPos);
                    xmlValue.append('\"');
                }
                pos = nextPos;
            }
            xmlValue.append('>');
        }
        return xmlValue.toString();
    }

    private static int indexOfOrEnd(String str, char ch, int fromIndex) {
        int index2 = str.indexOf(ch, fromIndex);
        return index2 >= 0 ? index2 : str.length();
    }

    private ProtoStyledStringDecoder() {
    }
}

