/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;

public class BasicFileResourceItem
extends BasicResourceItemBase {
    private final RepositoryConfiguration myConfiguration;
    private final String myRelativePath;

    public BasicFileResourceItem(ResourceType type, String name2, RepositoryConfiguration configuration, ResourceVisibility visibility, String relativePath) {
        super(type, name2, visibility);
        this.myConfiguration = configuration;
        this.myRelativePath = relativePath;
    }

    @Override
    public final boolean isFileBased() {
        return true;
    }

    @Override
    public final ResourceReference getReference() {
        return null;
    }

    @Override
    public RepositoryConfiguration getRepositoryConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public final ResourceNamespace.Resolver getNamespaceResolver() {
        return ResourceNamespace.Resolver.EMPTY_RESOLVER;
    }

    @Override
    public String getValue() {
        return this.getRepository().getResourceUrl(this.myRelativePath);
    }

    @Override
    public final PathString getSource() {
        return this.getRepository().getSourceFile(this.myRelativePath, true);
    }

    @Override
    public final PathString getOriginalSource() {
        return this.getRepository().getOriginalSourceFile(this.myRelativePath, true);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicFileResourceItem other = (BasicFileResourceItem)obj;
        return this.myConfiguration.equals(other.myConfiguration) && this.myRelativePath.equals(other.myRelativePath);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix(super.hashCode(), this.myRelativePath.hashCode());
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myRelativePath);
        String qualifierString = this.getConfiguration().getQualifierString();
        int index2 = configIndexes.getInt(qualifierString);
        assert (index2 >= 0);
        stream.writeInt(index2);
        stream.writeInt(this.getEncodedDensityForSerialization());
    }

    static BasicFileResourceItem deserialize(Base128InputStream stream, ResourceType resourceType, String name2, ResourceVisibility visibility, List<RepositoryConfiguration> configurations) throws IOException {
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        RepositoryConfiguration configuration = configurations.get(stream.readInt());
        int encodedDensity = stream.readInt();
        if (encodedDensity == 0) {
            return new BasicFileResourceItem(resourceType, name2, configuration, visibility, relativePath);
        }
        Density density = Density.create(encodedDensity);
        return new BasicDensityBasedFileResourceItem(resourceType, name2, configuration, visibility, relativePath, density);
    }

    protected int getEncodedDensityForSerialization() {
        return 0;
    }
}

