/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.Arity;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class BasicPluralsResourceItem
extends BasicValueResourceItemBase
implements PluralsResourceValue {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Arity[] myArities;
    private final String[] myValues;
    private final int myDefaultIndex;

    public BasicPluralsResourceItem(String name2, ResourceSourceFile sourceFile, ResourceVisibility visibility, Map<Arity, String> quantityValues, Arity defaultArity) {
        this(name2, sourceFile, visibility, quantityValues.keySet().toArray(Arity.EMPTY_ARRAY), quantityValues.values().toArray(EMPTY_STRING_ARRAY), BasicPluralsResourceItem.getIndex(defaultArity, quantityValues.keySet()));
    }

    private BasicPluralsResourceItem(String name2, ResourceSourceFile sourceFile, ResourceVisibility visibility, Arity[] arities, String[] values2, int defaultIndex) {
        super(ResourceType.PLURALS, name2, sourceFile, visibility);
        assert (arities.length == values2.length);
        this.myArities = arities;
        this.myValues = values2;
        assert (values2.length == 0 || defaultIndex < values2.length);
        this.myDefaultIndex = defaultIndex;
    }

    private static int getIndex(Arity arity, Collection<Arity> arities) {
        if (arity == null || arities.isEmpty()) {
            return 0;
        }
        int index2 = 0;
        for (Arity ar2 : arities) {
            if (ar2 == arity) {
                return index2;
            }
            ++index2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getPluralsCount() {
        return this.myArities.length;
    }

    @Override
    public String getQuantity(int index2) {
        return this.myArities[index2].getName();
    }

    @Override
    public String getValue(int index2) {
        return this.myValues[index2];
    }

    @Override
    public String getValue(String quantity) {
        int n2 = this.myArities.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!quantity.equals(this.myArities[i2].getName())) continue;
            return this.myValues[i2];
        }
        return null;
    }

    @Override
    public String getValue() {
        return this.myValues.length == 0 ? null : this.myValues[this.myDefaultIndex];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicPluralsResourceItem other = (BasicPluralsResourceItem)obj;
        return Arrays.equals((Object[])this.myArities, (Object[])other.myArities) && Arrays.equals(this.myValues, other.myValues);
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int n2 = this.myArities.length;
        stream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stream.writeInt(this.myArities[i2].ordinal());
            stream.writeString(this.myValues[i2]);
        }
        stream.writeInt(this.myDefaultIndex);
    }

    static BasicPluralsResourceItem deserialize(Base128InputStream stream, String name2, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver2) throws IOException {
        int n2 = stream.readInt();
        Arity[] arities = n2 == 0 ? Arity.EMPTY_ARRAY : new Arity[n2];
        String[] values2 = n2 == 0 ? EMPTY_STRING_ARRAY : new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            arities[i2] = Arity.values()[stream.readInt()];
            values2[i2] = stream.readString();
        }
        int defaultIndex = stream.readInt();
        if (values2.length != 0 && defaultIndex >= values2.length) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name2, sourceFile, visibility, arities, values2, defaultIndex);
        item.setNamespaceResolver(resolver2);
        return item;
    }
}

