/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.ResourceSourceFile;
import com.android.tools.environment.Logger;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class BasicStyleResourceItem
extends BasicValueResourceItemBase
implements StyleResourceValue {
    private static final Logger LOG = Logger.getInstance(BasicStyleResourceItem.class);
    private final String myParentStyle;
    private final Table<ResourceNamespace, String, StyleItemResourceValue> myStyleItemTable;

    public BasicStyleResourceItem(String name2, ResourceSourceFile sourceFile, ResourceVisibility visibility, String parentStyle, Collection<StyleItemResourceValue> styleItems) {
        super(ResourceType.STYLE, name2, sourceFile, visibility);
        this.myParentStyle = parentStyle;
        ImmutableTable.Builder<ResourceNamespace, String, StyleItemResourceValue> tableBuilder = ImmutableTable.builder();
        HashMap<ResourceReference, StyleItemResourceValue> duplicateCheckMap = new HashMap<ResourceReference, StyleItemResourceValue>();
        for (StyleItemResourceValue styleItem : styleItems) {
            ResourceReference attr = styleItem.getAttr();
            if (attr == null) continue;
            StyleItemResourceValue previouslyDefined = duplicateCheckMap.put(attr, styleItem);
            if (previouslyDefined == null) {
                tableBuilder.put(attr.getNamespace(), attr.getName(), styleItem);
                continue;
            }
            if (previouslyDefined.equals(styleItem)) continue;
            LOG.warn("Conflicting definitions of \"" + styleItem.getAttrName() + "\" in style \"" + name2 + "\"");
        }
        this.myStyleItemTable = tableBuilder.build();
    }

    @Override
    public String getParentStyleName() {
        return this.myParentStyle;
    }

    @Override
    public StyleItemResourceValue getItem(ResourceNamespace namespace, String name2) {
        return this.myStyleItemTable.get(namespace, name2);
    }

    @Override
    public StyleItemResourceValue getItem(ResourceReference attr) {
        if (attr.getResourceType() != ResourceType.ATTR) {
            return null;
        }
        return this.myStyleItemTable.get(attr.getNamespace(), attr.getName());
    }

    @Override
    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.myStyleItemTable.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicStyleResourceItem other = (BasicStyleResourceItem)obj;
        return Objects.equals(this.myParentStyle, other.myParentStyle) && this.myStyleItemTable.equals(other.myStyleItemTable);
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myParentStyle);
        stream.writeInt(this.myStyleItemTable.size());
        for (StyleItemResourceValue styleItem : this.myStyleItemTable.values()) {
            stream.writeString(styleItem.getAttrName());
            stream.writeString(styleItem.getValue());
            int index2 = namespaceResolverIndexes.getInt(styleItem.getNamespaceResolver());
            assert (index2 >= 0);
            stream.writeInt(index2);
        }
    }

    static BasicStyleResourceItem deserialize(Base128InputStream stream, String name2, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver2, List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        LoadableResourceRepository repository = sourceFile.getRepository();
        ResourceNamespace namespace = repository.getNamespace();
        String libraryName = repository.getLibraryName();
        String parentStyle = stream.readString();
        int n2 = stream.readInt();
        ArrayList<StyleItemResourceValue> styleItems = n2 == 0 ? Collections.emptyList() : new ArrayList<StyleItemResourceValue>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String attrName = stream.readString();
            if (attrName == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            String value = stream.readString();
            ResourceNamespace.Resolver itemResolver = namespaceResolvers.get(stream.readInt());
            StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(namespace, attrName, value, libraryName);
            styleItem.setNamespaceResolver(itemResolver);
            styleItems.add(styleItem);
        }
        BasicStyleResourceItem item = new BasicStyleResourceItem(name2, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(resolver2);
        return item;
    }
}

