/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicArrayResourceItem;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicPluralsResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicValueResourceItem;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public abstract class BasicValueResourceItemBase
extends BasicResourceItemBase {
    private final ResourceSourceFile mySourceFile;
    private ResourceNamespace.Resolver myNamespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;

    public BasicValueResourceItemBase(ResourceType type, String name2, ResourceSourceFile sourceFile, ResourceVisibility visibility) {
        super(type, name2, visibility);
        this.mySourceFile = sourceFile;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public final boolean isFileBased() {
        return false;
    }

    @Override
    public final RepositoryConfiguration getRepositoryConfiguration() {
        return this.mySourceFile.getConfiguration();
    }

    @Override
    public final ResourceNamespace.Resolver getNamespaceResolver() {
        return this.myNamespaceResolver;
    }

    public final void setNamespaceResolver(ResourceNamespace.Resolver resolver2) {
        this.myNamespaceResolver = resolver2;
    }

    @Override
    public final PathString getSource() {
        return this.getOriginalSource();
    }

    @Override
    public final PathString getOriginalSource() {
        String sourcePath2 = this.mySourceFile.getRelativePath();
        return sourcePath2 == null ? null : this.getRepository().getOriginalSourceFile(sourcePath2, false);
    }

    public final ResourceSourceFile getSourceFile() {
        return this.mySourceFile;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicValueResourceItemBase other = (BasicValueResourceItemBase)obj;
        return Objects.equals(this.mySourceFile, other.mySourceFile);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix(super.hashCode(), Objects.hashCode(this.mySourceFile));
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int index2 = sourceFileIndexes.getInt(this.mySourceFile);
        assert (index2 >= 0);
        stream.writeInt(index2);
        index2 = namespaceResolverIndexes.getInt(this.myNamespaceResolver);
        assert (index2 >= 0);
        stream.writeInt(index2);
    }

    static BasicValueResourceItemBase deserialize(Base128InputStream stream, ResourceType resourceType, String name2, ResourceVisibility visibility, List<RepositoryConfiguration> configurations, List<ResourceSourceFile> sourceFiles, List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        ResourceSourceFile sourceFile = sourceFiles.get(stream.readInt());
        ResourceNamespace.Resolver resolver2 = namespaceResolvers.get(stream.readInt());
        switch (resourceType) {
            case ARRAY: {
                return BasicArrayResourceItem.deserialize(stream, name2, visibility, sourceFile, resolver2);
            }
            case ATTR: {
                return BasicAttrResourceItem.deserialize(stream, name2, visibility, sourceFile, resolver2);
            }
            case PLURALS: {
                return BasicPluralsResourceItem.deserialize(stream, name2, visibility, sourceFile, resolver2);
            }
            case STYLE: {
                return BasicStyleResourceItem.deserialize(stream, name2, visibility, sourceFile, resolver2, namespaceResolvers);
            }
            case STYLEABLE: {
                return BasicStyleableResourceItem.deserialize(stream, name2, visibility, sourceFile, resolver2, configurations, sourceFiles, namespaceResolvers);
            }
        }
        return BasicValueResourceItem.deserialize(stream, resourceType, name2, visibility, sourceFile, resolver2);
    }
}

