/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class NamespaceResolver
implements ResourceNamespace.Resolver {
    public static final NamespaceResolver EMPTY = new NamespaceResolver(new String[0]);
    private final String[] prefixesAndUris;

    NamespaceResolver(XmlPullParser parser) throws XmlPullParserException {
        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
        this.prefixesAndUris = new String[namespaceCount * 2];
        int j2 = this.prefixesAndUris.length;
        for (int i2 = 0; i2 < namespaceCount; ++i2) {
            this.prefixesAndUris[--j2] = parser.getNamespaceUri(i2);
            this.prefixesAndUris[--j2] = parser.getNamespacePrefix(i2);
        }
    }

    private NamespaceResolver(String[] prefixesAndUris) {
        this.prefixesAndUris = prefixesAndUris;
    }

    int getNamespaceCount() {
        return this.prefixesAndUris.length / 2;
    }

    @Override
    public String prefixToUri(String namespacePrefix) {
        for (int i2 = 0; i2 < this.prefixesAndUris.length; i2 += 2) {
            if (!namespacePrefix.equals(this.prefixesAndUris[i2])) continue;
            return this.prefixesAndUris[i2 + 1];
        }
        return null;
    }

    @Override
    public String uriToPrefix(String namespaceUri) {
        for (int i2 = 0; i2 < this.prefixesAndUris.length; i2 += 2) {
            if (!namespaceUri.equals(this.prefixesAndUris[i2 + 1])) continue;
            return this.prefixesAndUris[i2];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceResolver other = (NamespaceResolver)obj;
        return Arrays.equals(this.prefixesAndUris, other.prefixesAndUris);
    }

    public int hashCode() {
        return Arrays.hashCode(this.prefixesAndUris);
    }

    public void serialize(Base128OutputStream stream) throws IOException {
        stream.writeInt(this.getNamespaceCount());
        for (String str : this.prefixesAndUris) {
            stream.writeString(str);
        }
    }

    public static NamespaceResolver deserialize(Base128InputStream stream) throws IOException {
        int n2 = stream.readInt() * 2;
        String[] prefixesAndUris = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String s2 = stream.readString();
            if (s2 == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            prefixesAndUris[i2] = s2;
        }
        return new NamespaceResolver(prefixesAndUris);
    }
}

