/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ProgressManagerAdapter;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.resources.AndroidAaptIgnore;
import com.android.ide.common.resources.PatternBasedFileFilter;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.io.CancellableFileIo;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicArrayResourceItem;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.BasicForeignAttrResourceItem;
import com.android.resources.base.BasicPluralsResourceItem;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicTextValueResourceItem;
import com.android.resources.base.BasicValueResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.CommentTrackingXmlPullParser;
import com.android.resources.base.FileFilter;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.resources.base.ResourceSourceFileImpl;
import com.android.resources.base.ResourceUrlParser;
import com.android.resources.base.ValueResourceXmlParser;
import com.android.tools.environment.Logger;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RepositoryLoader<T extends LoadableResourceRepository>
implements FileFilter {
    private static final Logger LOG = Logger.getInstance(RepositoryLoader.class);
    private final Set<AttributeFormat> DEFAULT_ATTR_FORMATS = Sets.immutableEnumSet((Enum)AttributeFormat.BOOLEAN, (Enum[])new AttributeFormat[]{AttributeFormat.COLOR, AttributeFormat.DIMENSION, AttributeFormat.FLOAT, AttributeFormat.FRACTION, AttributeFormat.INTEGER, AttributeFormat.REFERENCE, AttributeFormat.STRING});
    private final PatternBasedFileFilter myFileFilter = new PatternBasedFileFilter(new AndroidAaptIgnore(System.getenv("ANDROID_AAPT_IGNORE")));
    private final Map<ResourceType, Set<String>> myPublicResources = new EnumMap<ResourceType, Set<String>>(ResourceType.class);
    private final ListMultimap<String, BasicAttrResourceItem> myAttrs = ArrayListMultimap.create();
    private final ListMultimap<String, BasicAttrResourceItem> myAttrCandidates = ArrayListMultimap.create();
    private final ListMultimap<String, BasicStyleableResourceItem> myStyleables = ArrayListMultimap.create();
    protected ResourceVisibility myDefaultVisibility = ResourceVisibility.PRIVATE;
    protected final Map<String, FolderConfiguration> myFolderConfigCache = new HashMap<String, FolderConfiguration>();
    private final Map<FolderConfiguration, RepositoryConfiguration> myConfigCache = new HashMap<FolderConfiguration, RepositoryConfiguration>();
    private final ValueResourceXmlParser myParser = new ValueResourceXmlParser();
    private final XmlTextExtractor myTextExtractor = new XmlTextExtractor();
    private final ResourceUrlParser myUrlParser = new ResourceUrlParser();
    private final Table<ResourceType, String, BasicValueResourceItemBase> myValueFileResources = Tables.newCustomTable(new EnumMap(ResourceType.class), LinkedHashMap::new);
    protected final Path myResourceDirectoryOrFile;
    private final PathString myResourceDirectoryOrFilePath;
    private final boolean myLoadingFromZipArchive;
    private final ResourceNamespace myNamespace;
    private final Collection<PathString> myResourceFilesAndFolders;
    protected ZipFile myZipFile;

    public RepositoryLoader(Path resourceDirectoryOrFile, Collection<PathString> resourceFilesAndFolders, ResourceNamespace namespace) {
        this.myResourceDirectoryOrFile = resourceDirectoryOrFile;
        this.myResourceDirectoryOrFilePath = new PathString(this.myResourceDirectoryOrFile);
        this.myLoadingFromZipArchive = RepositoryLoader.isZipArchive(resourceDirectoryOrFile);
        this.myNamespace = namespace;
        this.myResourceFilesAndFolders = resourceFilesAndFolders;
    }

    public final Path getResourceDirectoryOrFile() {
        return this.myResourceDirectoryOrFile;
    }

    public final boolean isLoadingFromZipArchive() {
        return this.myLoadingFromZipArchive;
    }

    public final ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    public void loadRepositoryContents(T repository) {
        if (this.myLoadingFromZipArchive) {
            this.loadFromZip(repository);
        } else {
            this.loadFromResFolder(repository);
        }
    }

    public List<String> getPublicXmlFileNames() {
        return ImmutableList.of("public.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromZip(T repository) {
        try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
            this.myZipFile = zipFile;
            this.loadPublicResourceNames();
            boolean shouldParseResourceIds = !this.loadIdsFromRTxt();
            zipFile.stream().forEach(zipEntry -> {
                if (!zipEntry.isDirectory()) {
                    PathString path = new PathString(zipEntry.getName());
                    this.loadResourceFile(path, repository, shouldParseResourceIds);
                }
            });
        }
        catch (Exception e2) {
            ProgressManagerAdapter.throwIfCancellation(e2);
            LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), e2);
        }
        finally {
            this.myZipFile = null;
        }
        this.finishLoading(repository);
    }

    protected void loadFromResFolder(T repository) {
        try {
            if (CancellableFileIo.notExists(this.myResourceDirectoryOrFile, new LinkOption[0])) {
                return;
            }
            this.loadPublicResourceNames();
            boolean shouldParseResourceIds = !this.loadIdsFromRTxt();
            ImmutableList<Path> sourceFilesAndFolders = this.myResourceFilesAndFolders == null ? ImmutableList.of(this.myResourceDirectoryOrFile) : this.myResourceFilesAndFolders.stream().map(PathString::toPath).collect(Collectors.toList());
            List<PathString> resourceFiles = this.findResourceFiles(sourceFilesAndFolders);
            for (PathString file2 : resourceFiles) {
                this.loadResourceFile(file2, repository, shouldParseResourceIds);
            }
        }
        catch (Exception e2) {
            ProgressManagerAdapter.throwIfCancellation(e2);
            LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), e2);
        }
        this.finishLoading(repository);
    }

    protected final void loadResourceFile(PathString file2, T repository, boolean shouldParseResourceIds) {
        FolderInfo folderInfo;
        String folderName = file2.getParentFileName();
        if (folderName != null && (folderInfo = FolderInfo.create(folderName, this.myFolderConfigCache)) != null) {
            RepositoryConfiguration configuration = this.getConfiguration(repository, folderInfo.configuration);
            this.loadResourceFile(file2, folderInfo, configuration, shouldParseResourceIds);
        }
    }

    protected void finishLoading(T repository) {
        this.processAttrsAndStyleables();
    }

    public final String getSourceFileProtocol() {
        if (this.myLoadingFromZipArchive) {
            return "jar";
        }
        return "file";
    }

    public final String getResourcePathPrefix() {
        if (this.myLoadingFromZipArchive) {
            return RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/res/";
        }
        return RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
    }

    public final String getResourceUrlPrefix() {
        if (this.myLoadingFromZipArchive) {
            return "jar://" + RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/res/";
        }
        return RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
    }

    protected boolean loadIdsFromRTxt() {
        return false;
    }

    @Override
    public boolean isIgnored(Path fileOrDirectory, BasicFileAttributes attrs) {
        if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
            return false;
        }
        return this.myFileFilter.isIgnored(fileOrDirectory.toString(), attrs.isDirectory());
    }

    protected void loadPublicResourceNames() {
        Path valuesFolder = this.myResourceDirectoryOrFile.resolve("values");
        List<String> fileNames = this.getPublicXmlFileNames();
        for (String fileName : fileNames) {
            Path publicXmlFile = valuesFolder.resolve(fileName);
            try (BufferedInputStream stream2 = new BufferedInputStream(CancellableFileIo.newInputStream(publicXmlFile, new OpenOption[0]));){
                CommentTrackingXmlPullParser parser = new CommentTrackingXmlPullParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput(stream2, StandardCharsets.UTF_8.name());
                String groupTag = null;
                ResourceType groupType = null;
                ResourceType lastType = null;
                String lastTypeName = "";
                while (true) {
                    int event;
                    if ((event = parser.nextToken()) == 2) {
                        if (parser.getName().equals("public")) {
                            ResourceType type;
                            String name2 = null;
                            String typeName = groupType == null ? null : groupType.getName();
                            int n2 = parser.getAttributeCount();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                String attribute = parser.getAttributeName(i2);
                                if (attribute.equals("name")) {
                                    name2 = parser.getAttributeValue(i2);
                                    if (typeName == null) continue;
                                    break;
                                }
                                if (!attribute.equals("type")) continue;
                                typeName = parser.getAttributeValue(i2);
                            }
                            if (name2 == null || name2.startsWith("__removed") || typeName == null && groupType == null || parser.getLastComment() != null && RepositoryLoader.containsWord(parser.getLastComment(), "@hide")) continue;
                            if (groupType != null) {
                                type = groupType;
                            } else if (typeName.equals(lastTypeName)) {
                                type = lastType;
                            } else {
                                lastType = type = ResourceType.fromXmlValue(typeName);
                                lastTypeName = typeName;
                            }
                            if (type != null) {
                                this.addPublicResourceName(type, name2);
                                continue;
                            }
                            LOG.error("Public resource declaration \"" + name2 + "\" of type " + typeName + " points to unknown resource type.");
                            continue;
                        }
                        if (!this.isPublicGroupTag(parser.getName())) continue;
                        groupTag = parser.getName();
                        String typeName = parser.getAttributeValue(null, "type");
                        groupType = typeName == null ? null : ResourceType.fromXmlValue(typeName);
                        continue;
                    }
                    if (event == 3) {
                        if (groupTag == null || !groupTag.equals(parser.getName())) continue;
                        groupTag = null;
                        groupType = null;
                        continue;
                    }
                    if (event == 1) break;
                }
            }
            catch (NoSuchFileException stream2) {
            }
            catch (Exception e2) {
                ProgressManagerAdapter.throwIfCancellation(e2);
                LOG.error("Can't read and parse " + publicXmlFile, e2);
            }
        }
    }

    private boolean isPublicGroupTag(String tag) {
        return tag.equals("public-group") || tag.equals("staging-public-group") || tag.equals("staging-public-group-final");
    }

    protected final void addPublicResourceName(ResourceType type, String name2) {
        Set names = this.myPublicResources.computeIfAbsent(type, t2 -> new HashSet());
        names.add(name2);
    }

    private static boolean containsWord(String text, String word) {
        int start;
        int end = 0;
        do {
            if ((start = text.indexOf(word, end)) < 0) {
                return false;
            }
            end = start + word.length();
        } while (start != 0 && !Character.isWhitespace(text.charAt(start)) || end != text.length() && !Character.isWhitespace(text.charAt(end)));
        return true;
    }

    private List<PathString> findResourceFiles(List<Path> filesOrFolders) {
        ResourceFileCollector fileCollector = new ResourceFileCollector(this);
        for (Path file2 : filesOrFolders) {
            try {
                CancellableFileIo.walkFileTree(file2, fileCollector);
            }
            catch (IOException iOException) {}
        }
        for (IOException e2 : fileCollector.ioErrors) {
            LOG.error("Error loading resources from " + this.myResourceDirectoryOrFile.toString(), e2);
        }
        Collections.sort(fileCollector.resourceFiles);
        return fileCollector.resourceFiles;
    }

    protected final RepositoryConfiguration getConfiguration(T repository, FolderConfiguration folderConfiguration) {
        RepositoryConfiguration repositoryConfiguration = this.myConfigCache.get(folderConfiguration);
        if (repositoryConfiguration != null) {
            return repositoryConfiguration;
        }
        repositoryConfiguration = new RepositoryConfiguration((LoadableResourceRepository)repository, folderConfiguration);
        this.myConfigCache.put(folderConfiguration, repositoryConfiguration);
        return repositoryConfiguration;
    }

    private void loadResourceFile(PathString file2, FolderInfo folderInfo, RepositoryConfiguration configuration, boolean shouldParseResourceIds) {
        if (folderInfo.resourceType == null) {
            if (RepositoryLoader.isXmlFile(file2)) {
                this.parseValueResourceFile(file2, configuration);
            }
        } else {
            if (shouldParseResourceIds && folderInfo.isIdGenerating && RepositoryLoader.isXmlFile(file2)) {
                this.parseIdGeneratingResourceFile(file2, configuration);
            }
            BasicFileResourceItem item = this.createFileResourceItem(file2, folderInfo.resourceType, configuration);
            this.addResourceItem(item);
        }
    }

    protected static boolean isXmlFile(PathString file2) {
        return RepositoryLoader.isXmlFile(file2.getFileName());
    }

    protected static boolean isXmlFile(String filename) {
        return SdkUtils.endsWithIgnoreCase(filename, ".xml");
    }

    private void addResourceItem(BasicResourceItemBase item) {
        this.addResourceItem(item, item.getRepository());
    }

    protected abstract void addResourceItem(BasicResourceItem var1, T var2);

    protected final void parseValueResourceFile(PathString file2, RepositoryConfiguration configuration) {
        try (InputStream stream = this.getInputStream(file2);){
            int event;
            ResourceSourceFile sourceFile = this.createResourceSourceFile(file2, configuration);
            this.myParser.setInput(stream, null);
            do {
                event = this.myParser.nextToken();
                int depth = this.myParser.getDepth();
                if (event != 2 || this.myParser.getPrefix() != null) continue;
                String tagName = this.myParser.getName();
                assert (depth <= 2);
                if (depth == 1) {
                    if (tagName.equals("resources")) continue;
                    break;
                }
                if (depth <= 1) continue;
                ResourceType resourceType = this.getResourceType(tagName, file2);
                if (resourceType != null && resourceType != ResourceType.PUBLIC) {
                    String resourceName = this.myParser.getAttributeValue(null, "name");
                    if (resourceName != null) {
                        this.validateResourceName(resourceName, resourceType, file2);
                        BasicValueResourceItemBase item = this.createResourceItem(resourceType, resourceName, sourceFile);
                        this.addValueResourceItem(item);
                        continue;
                    }
                    this.skipSubTags();
                    continue;
                }
                this.skipSubTags();
            } while (event != 1);
        }
        catch (XmlSyntaxException | IOException | RuntimeException | XmlPullParserException e2) {
            ProgressManagerAdapter.throwIfCancellation(e2);
            this.handleParsingError(file2, e2);
        }
        this.addValueFileResources();
    }

    protected ResourceSourceFile createResourceSourceFile(PathString file2, RepositoryConfiguration configuration) {
        return new ResourceSourceFileImpl(this.getResRelativePath(file2), configuration);
    }

    private void addValueResourceItem(BasicValueResourceItemBase item) {
        ResourceType resourceType = item.getType();
        if (resourceType == ResourceType.ATTR) {
            RepositoryLoader.addAttr((BasicAttrResourceItem)item, this.myAttrs);
        } else if (resourceType == ResourceType.STYLEABLE) {
            this.myStyleables.put(item.getName(), (BasicStyleableResourceItem)item);
        } else {
            this.myValueFileResources.put(resourceType, item.getName(), item);
        }
    }

    protected final void addValueFileResources() {
        for (BasicValueResourceItemBase item : this.myValueFileResources.values()) {
            this.addResourceItem(item);
        }
        this.myValueFileResources.clear();
    }

    protected final void parseIdGeneratingResourceFile(PathString file2, RepositoryConfiguration configuration) {
        try (InputStream stream = this.getInputStream(file2);){
            int event;
            ResourceSourceFile sourceFile = this.createResourceSourceFile(file2, configuration);
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(stream, null);
            do {
                if ((event = parser.nextToken()) != 2) continue;
                int numAttributes = parser.getAttributeCount();
                for (int i2 = 0; i2 < numAttributes; ++i2) {
                    String idValue = parser.getAttributeValue(i2);
                    if (!idValue.startsWith("@+id/") || idValue.length() <= "@+id/".length()) continue;
                    String resourceName = idValue.substring("@+id/".length());
                    this.addIdResourceItem(resourceName, sourceFile);
                }
            } while (event != 1);
        }
        catch (IOException | RuntimeException | XmlPullParserException e2) {
            ProgressManagerAdapter.throwIfCancellation(e2);
            this.handleParsingError(file2, e2);
        }
        this.addValueFileResources();
    }

    protected void handleParsingError(PathString file2, Exception e2) {
        LOG.warn("Failed to parse " + file2.toString(), e2);
    }

    protected InputStream getInputStream(PathString file2) throws IOException {
        if (this.myZipFile == null) {
            Path path = file2.toPath();
            Preconditions.checkArgument(path != null);
            return new BufferedInputStream(CancellableFileIo.newInputStream(path, new OpenOption[0]));
        }
        ProgressManagerAdapter.checkCanceled();
        ZipEntry entry = this.myZipFile.getEntry(file2.getPortablePath());
        if (entry == null) {
            throw new NoSuchFileException(file2.getPortablePath());
        }
        return new BufferedInputStream(this.myZipFile.getInputStream(entry));
    }

    protected final void addIdResourceItem(String resourceName, ResourceSourceFile sourceFile) {
        ResourceVisibility visibility = this.getVisibility(ResourceType.ID, resourceName);
        BasicValueResourceItem item = new BasicValueResourceItem(ResourceType.ID, resourceName, sourceFile, visibility, null);
        if (!RepositoryLoader.resourceAlreadyDefined(item)) {
            this.addValueResourceItem(item);
        }
    }

    private BasicFileResourceItem createFileResourceItem(PathString file2, ResourceType resourceType, RepositoryConfiguration configuration) {
        DensityQualifier densityQualifier;
        String resourceName = SdkUtils.fileNameToResourceName(file2.getFileName());
        ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
        Density density = null;
        if (DensityBasedResourceValue.isDensityBasedResourceType(resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null) {
            density = densityQualifier.getValue();
        }
        return this.createFileResourceItem(file2, resourceType, resourceName, configuration, visibility, density);
    }

    protected final BasicFileResourceItem createFileResourceItem(PathString file2, ResourceType type, String name2, RepositoryConfiguration configuration, ResourceVisibility visibility, Density density) {
        String relativePath = this.getResRelativePath(file2);
        return density == null ? new BasicFileResourceItem(type, name2, configuration, visibility, relativePath) : new BasicDensityBasedFileResourceItem(type, name2, configuration, visibility, relativePath, density);
    }

    private BasicValueResourceItemBase createResourceItem(ResourceType type, String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        switch (type) {
            case ARRAY: {
                return this.createArrayItem(name2, sourceFile);
            }
            case ATTR: {
                return this.createAttrItem(name2, sourceFile);
            }
            case PLURALS: {
                return this.createPluralsItem(name2, sourceFile);
            }
            case STRING: {
                return this.createStringItem(type, name2, sourceFile, true);
            }
            case STYLE: {
                return this.createStyleItem(name2, sourceFile);
            }
            case STYLEABLE: {
                return this.createStyleableItem(name2, sourceFile);
            }
            case ANIMATOR: 
            case DRAWABLE: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case TRANSITION: {
                return this.createFileReferenceItem(type, name2, sourceFile);
            }
        }
        return this.createStringItem(type, name2, sourceFile, false);
    }

    private BasicArrayResourceItem createArrayItem(String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        String indexValue = this.myParser.getAttributeValue("http://schemas.android.com/tools", "index");
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        ArrayList<String> values2 = new ArrayList<String>();
        this.forSubTags("item", () -> {
            String text = this.myTextExtractor.extractText(this.myParser, false);
            values2.add(text);
        });
        int index2 = 0;
        if (indexValue != null) {
            try {
                index2 = Integer.parseUnsignedInt(indexValue);
            }
            catch (NumberFormatException e2) {
                throw new XmlSyntaxException("The value of the " + namespaceResolver.prefixToUri("http://schemas.android.com/tools") + ":index attribute is not a valid number.", this.myParser, this.getDisplayName(sourceFile));
            }
            if (index2 >= values2.size()) {
                throw new XmlSyntaxException("The value of the " + namespaceResolver.prefixToUri("http://schemas.android.com/tools") + ":index attribute is out of bounds.", this.myParser, this.getDisplayName(sourceFile));
            }
        }
        ResourceVisibility visibility = this.getVisibility(ResourceType.ARRAY, name2);
        BasicArrayResourceItem item = new BasicArrayResourceItem(name2, sourceFile, visibility, values2, index2);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicAttrResourceItem createAttrItem(String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        BasicAttrResourceItem item;
        ResourceNamespace attrNamespace;
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        this.myUrlParser.parseResourceUrl(name2);
        if (this.myUrlParser.hasNamespacePrefix("android")) {
            attrNamespace = ResourceNamespace.ANDROID;
        } else {
            String prefix = this.myUrlParser.getNamespacePrefix();
            attrNamespace = ResourceNamespace.fromNamespacePrefix(prefix, this.myNamespace, this.myParser.getNamespaceResolver());
            if (attrNamespace == null) {
                throw new XmlSyntaxException("Undefined prefix of attr resource name \"" + name2 + "\"", this.myParser, this.getDisplayName(sourceFile));
            }
        }
        name2 = this.myUrlParser.getName();
        String description = this.myParser.getLastComment();
        String groupName = this.myParser.getAttrGroupComment();
        String formatString = this.myParser.getAttributeValue(null, "format");
        Set<AttributeFormat> formats = Strings.isNullOrEmpty(formatString) ? EnumSet.noneOf(AttributeFormat.class) : AttributeFormat.parse(formatString);
        HashMap<String, Integer> valueMap = Maps.newHashMapWithExpectedSize(8);
        HashMap<String, String> descriptionMap = Maps.newHashMapWithExpectedSize(8);
        this.forSubTags(null, () -> {
            if (this.myParser.getPrefix() == null) {
                AttributeFormat format;
                String tagName = this.myParser.getName();
                AttributeFormat attributeFormat = tagName.equals("enum") ? AttributeFormat.ENUM : (format = tagName.equals("flag") ? AttributeFormat.FLAGS : null);
                if (format != null) {
                    formats.add(format);
                    String valueName = this.myParser.getAttributeValue(null, "name");
                    if (valueName != null) {
                        String valueDescription = this.myParser.getLastComment();
                        if (valueDescription != null) {
                            descriptionMap.put(valueName, valueDescription);
                        }
                        String value = this.myParser.getAttributeValue(null, "value");
                        Integer numericValue = null;
                        if (value != null) {
                            try {
                                numericValue = Long.decode(value).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        valueMap.put(valueName, numericValue);
                    }
                }
            }
        });
        if (attrNamespace.equals(this.myNamespace)) {
            ResourceVisibility visibility = this.getVisibility(ResourceType.ATTR, name2);
            item = new BasicAttrResourceItem(name2, sourceFile, visibility, description, groupName, formats, valueMap, descriptionMap);
        } else {
            item = new BasicForeignAttrResourceItem(attrNamespace, name2, sourceFile, description, groupName, formats, valueMap, descriptionMap);
        }
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicPluralsResourceItem createPluralsItem(String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        String defaultQuantity = this.myParser.getAttributeValue("http://schemas.android.com/tools", "quantity");
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        EnumMap<Arity, String> values2 = new EnumMap<Arity, String>(Arity.class);
        this.forSubTags("item", () -> {
            Arity quantity;
            String quantityValue = this.myParser.getAttributeValue(null, "quantity");
            if (quantityValue != null && (quantity = Arity.getEnum(quantityValue)) != null) {
                String text = this.myTextExtractor.extractText(this.myParser, false);
                values2.put(quantity, text);
            }
        });
        Arity defaultArity = null;
        if (!(defaultQuantity == null || (defaultArity = Arity.getEnum(defaultQuantity)) != null && values2.containsKey((Object)defaultArity))) {
            throw new XmlSyntaxException("Invalid value of the " + namespaceResolver.prefixToUri("http://schemas.android.com/tools") + ":quantity attribute.", this.myParser, this.getDisplayName(sourceFile));
        }
        ResourceVisibility visibility = this.getVisibility(ResourceType.PLURALS, name2);
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name2, sourceFile, visibility, values2, defaultArity);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicValueResourceItem createStringItem(ResourceType type, String name2, ResourceSourceFile sourceFile, boolean withRowXml) throws IOException, XmlPullParserException {
        String rawXml;
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        String text = type == ResourceType.ID ? null : this.myTextExtractor.extractText(this.myParser, withRowXml);
        String string2 = rawXml = type == ResourceType.ID ? null : this.myTextExtractor.getRawXml();
        assert (withRowXml || rawXml == null);
        ResourceVisibility visibility = this.getVisibility(type, name2);
        BasicValueResourceItem item = rawXml == null ? new BasicValueResourceItem(type, name2, sourceFile, visibility, text) : new BasicTextValueResourceItem(type, name2, sourceFile, visibility, text, rawXml);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicStyleResourceItem createStyleItem(String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        String parentStyle = this.myParser.getAttributeValue(null, "parent");
        if (parentStyle != null && !parentStyle.isEmpty()) {
            this.myUrlParser.parseResourceUrl(parentStyle);
            parentStyle = this.myUrlParser.getQualifiedName();
        }
        ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>();
        this.forSubTags("item", () -> {
            ResourceNamespace.Resolver itemNamespaceResolver = this.myParser.getNamespaceResolver();
            String itemName = this.myParser.getAttributeValue(null, "name");
            if (itemName != null) {
                String text = this.myTextExtractor.extractText(this.myParser, false);
                StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(this.myNamespace, itemName, text, sourceFile.getRepository().getLibraryName());
                styleItem.setNamespaceResolver(itemNamespaceResolver);
                styleItems.add(styleItem);
            }
        });
        ResourceVisibility visibility = this.getVisibility(ResourceType.STYLE, name2);
        BasicStyleResourceItem item = new BasicStyleResourceItem(name2, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicStyleableResourceItem createStyleableItem(String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>();
        this.forSubTags("attr", () -> {
            String attrName = this.myParser.getAttributeValue(null, "name");
            if (attrName != null) {
                try {
                    BasicAttrResourceItem attr = this.createAttrItem(attrName, sourceFile);
                    attrs.add((AttrResourceValue)((Object)(attr.getFormats().isEmpty() ? attr : attr.createReference())));
                    if (attr.getNamespace().equals(this.myNamespace) && (this.myNamespace != ResourceNamespace.RES_AUTO || !attr.getFormats().isEmpty())) {
                        RepositoryLoader.addAttr(attr, this.myAttrCandidates);
                    }
                }
                catch (XmlSyntaxException e2) {
                    LOG.error(e2);
                }
            }
        });
        BasicStyleableResourceItem item = new BasicStyleableResourceItem(name2, sourceFile, ResourceVisibility.PUBLIC, attrs);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private static void addAttr(BasicAttrResourceItem attr, ListMultimap<String, BasicAttrResourceItem> map2) {
        Collection attrs = map2.get((Object)attr.getName());
        int i2 = RepositoryLoader.findResourceWithSameNameAndConfiguration(attr, (List<? extends ResourceItem>)attrs);
        if (i2 >= 0) {
            BasicAttrResourceItem existing = (BasicAttrResourceItem)attrs.get(i2);
            if (!attr.getFormats().isEmpty()) {
                if (existing.getFormats().isEmpty()) {
                    attrs.set(i2, attr);
                } else if (!attr.getFormats().equals(existing.getFormats())) {
                    if (attr.getFormats().containsAll(existing.getFormats())) {
                        existing.setFormats(attr.getFormats());
                    } else if (existing.getFormats().containsAll(attr.getFormats())) {
                        attr.setFormats(existing.getFormats());
                    } else {
                        AbstractCollection formats = EnumSet.copyOf(attr.getFormats());
                        formats.addAll(existing.getFormats());
                        formats = ImmutableSet.copyOf(formats);
                        attr.setFormats((Set<AttributeFormat>)((Object)formats));
                        existing.setFormats((Set<AttributeFormat>)((Object)formats));
                    }
                }
            }
            if (existing.getFormats().isEmpty() && !attr.getFormats().isEmpty()) {
                attrs.set(i2, attr);
            }
        } else {
            attrs.add(attr);
        }
    }

    private void processAttrsAndStyleables() {
        for (BasicAttrResourceItem attr : this.myAttrs.values()) {
            this.addAttrWithAdjustedFormats(attr);
        }
        for (BasicAttrResourceItem attr : this.myAttrCandidates.values()) {
            Collection attrs;
            int i2 = RepositoryLoader.findResourceWithSameNameAndConfiguration(attr, (List<? extends ResourceItem>)(attrs = this.myAttrs.get((Object)attr.getName())));
            if (i2 >= 0) continue;
            this.addAttrWithAdjustedFormats(attr);
        }
        for (BasicStyleableResourceItem styleable : this.myStyleables.values()) {
            this.addResourceItem(RepositoryLoader.resolveAttrReferences(styleable));
        }
    }

    public static BasicStyleableResourceItem resolveAttrReferences(BasicStyleableResourceItem styleable) {
        LoadableResourceRepository repository = styleable.getRepository();
        List<AttrResourceValue> attributes = styleable.getAllAttributes();
        ArrayList<AttrResourceValue> resolvedAttributes = null;
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            AttrResourceValue attr = attributes.get(i2);
            AttrResourceValue canonicalAttr = BasicStyleableResourceItem.getCanonicalAttr(attr, repository);
            if (canonicalAttr != attr) {
                if (resolvedAttributes == null) {
                    resolvedAttributes = new ArrayList<AttrResourceValue>(attributes.size());
                    for (int j2 = 0; j2 < i2; ++j2) {
                        resolvedAttributes.add(attributes.get(j2));
                    }
                }
                resolvedAttributes.add(canonicalAttr);
                continue;
            }
            if (resolvedAttributes == null) continue;
            resolvedAttributes.add(attr);
        }
        if (resolvedAttributes != null) {
            ResourceNamespace.Resolver namespaceResolver = styleable.getNamespaceResolver();
            styleable = new BasicStyleableResourceItem(styleable.getName(), styleable.getSourceFile(), styleable.getVisibility(), resolvedAttributes);
            styleable.setNamespaceResolver(namespaceResolver);
        }
        return styleable;
    }

    private void addAttrWithAdjustedFormats(BasicAttrResourceItem attr) {
        if (attr.getFormats().isEmpty()) {
            attr = new BasicAttrResourceItem(attr.getName(), attr.getSourceFile(), attr.getVisibility(), attr.getDescription(), attr.getGroupName(), this.DEFAULT_ATTR_FORMATS, Collections.emptyMap(), Collections.emptyMap());
        }
        this.addResourceItem(attr);
    }

    private static boolean resourceAlreadyDefined(BasicResourceItemBase resource) {
        LoadableResourceRepository repository = resource.getRepository();
        List<ResourceItem> items = repository.getResources(resource.getNamespace(), resource.getType(), resource.getName());
        return RepositoryLoader.findResourceWithSameNameAndConfiguration(resource, items) >= 0;
    }

    private static int findResourceWithSameNameAndConfiguration(ResourceItem resource, List<? extends ResourceItem> items) {
        for (int i2 = 0; i2 < items.size(); ++i2) {
            ResourceItem item = items.get(i2);
            if (!item.getConfiguration().equals(resource.getConfiguration())) continue;
            return i2;
        }
        return -1;
    }

    private BasicValueResourceItem createFileReferenceItem(ResourceType type, String name2, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        String text = this.myTextExtractor.extractText(this.myParser, false).trim();
        if (!(text.isEmpty() || text.startsWith("@") || text.startsWith("?"))) {
            text = text.replace('/', File.separatorChar);
        }
        ResourceVisibility visibility = this.getVisibility(type, name2);
        BasicValueResourceItem item = new BasicValueResourceItem(type, name2, sourceFile, visibility, text);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private ResourceType getResourceType(String tagName, PathString file2) throws XmlSyntaxException {
        ResourceType type = ResourceType.fromXmlTagName(tagName);
        if (type == null) {
            if ("eat-comment".equals(tagName) || "skip".equals(tagName)) {
                return null;
            }
            if ("java-symbol".equals(tagName)) {
                return null;
            }
            if (tagName.equals("item")) {
                String typeAttr = this.myParser.getAttributeValue(null, "type");
                if (typeAttr != null) {
                    type = ResourceType.fromClassName(typeAttr);
                    if (type != null) {
                        return type;
                    }
                    LOG.warn("Unrecognized type attribute \"" + typeAttr + "\" at " + this.getDisplayName(file2) + " line " + this.myParser.getLineNumber());
                }
            } else {
                LOG.warn("Unrecognized tag name \"" + tagName + "\" at " + this.getDisplayName(file2) + " line " + this.myParser.getLineNumber());
            }
        }
        return type;
    }

    private void forSubTags(String tagName, XmlTagVisitor subtagVisitor) throws IOException, XmlPullParserException {
        int event;
        int elementDepth = this.myParser.getDepth();
        do {
            if ((event = this.myParser.nextToken()) != 2 || tagName != null && (!tagName.equals(this.myParser.getName()) || this.myParser.getPrefix() != null)) continue;
            subtagVisitor.visitTag();
        } while (event != 1 && (event != 3 || this.myParser.getDepth() > elementDepth));
    }

    private void skipSubTags() throws IOException, XmlPullParserException {
        int event;
        int elementDepth = this.myParser.getDepth();
        while ((event = this.myParser.nextToken()) != 1 && (event != 3 || this.myParser.getDepth() > elementDepth)) {
        }
    }

    private void validateResourceName(String resourceName, ResourceType resourceType, PathString file2) throws XmlSyntaxException {
        String error = ValueResourceNameValidator.getErrorText(resourceName, resourceType);
        if (error != null) {
            throw new XmlSyntaxException(error, this.myParser, this.getDisplayName(file2));
        }
    }

    private String getDisplayName(PathString file2) {
        return file2.isAbsolute() ? file2.getNativePath() : file2.getPortablePath() + " in " + this.myResourceDirectoryOrFile.toString();
    }

    private String getDisplayName(ResourceSourceFile sourceFile) {
        String relativePath = sourceFile.getRelativePath();
        Preconditions.checkArgument(relativePath != null);
        return this.getDisplayName(new PathString(relativePath));
    }

    protected final ResourceVisibility getVisibility(ResourceType resourceType, String resourceName) {
        Set<String> names = this.myPublicResources.get((Object)resourceType);
        return names != null && names.contains(this.getKeyForVisibilityLookup(resourceName)) ? ResourceVisibility.PUBLIC : this.myDefaultVisibility;
    }

    protected String getKeyForVisibilityLookup(String resourceName) {
        return ResourcesUtil.resourceNameToFieldName(resourceName);
    }

    protected final String getResRelativePath(PathString file2) {
        if (file2.isAbsolute()) {
            return this.myResourceDirectoryOrFilePath.relativize(file2).getPortablePath();
        }
        assert (file2.getNameCount() != 0);
        assert (file2.segment(0).equals("res"));
        return file2.subpath(1, file2.getNameCount()).getPortablePath();
    }

    private static boolean isZipArchive(Path resourceDirectoryOrFile) {
        String filename = resourceDirectoryOrFile.getFileName().toString();
        return SdkUtils.endsWithIgnoreCase(filename, ".aar") || SdkUtils.endsWithIgnoreCase(filename, ".jar") || SdkUtils.endsWithIgnoreCase(filename, ".zip");
    }

    public static String portableFileName(String fileName) {
        return fileName.replace(File.separatorChar, '/');
    }

    private static class XmlTextExtractor {
        private final StringBuilder text = new StringBuilder();
        private final StringBuilder rawXml = new StringBuilder();
        private final Deque<Boolean> textInclusionState = new ArrayDeque<Boolean>();
        private boolean nontrivialRawXml;

        private XmlTextExtractor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        String extractText(XmlPullParser parser, boolean withRawXml) throws IOException, XmlPullParserException {
            int event;
            this.text.setLength(0);
            this.rawXml.setLength(0);
            this.textInclusionState.clear();
            this.nontrivialRawXml = false;
            int elementDepth = parser.getDepth();
            do {
                event = parser.nextToken();
                switch (event) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("g".equals(tagName) && XmlTextExtractor.isXliffNamespace(parser.getNamespace())) {
                            boolean includeNestedText = this.getTextInclusionState();
                            String example = parser.getAttributeValue(null, "example");
                            if (example != null) {
                                this.text.append('(').append(example).append(')');
                                includeNestedText = false;
                            } else {
                                String id2 = parser.getAttributeValue(null, "id");
                                if (id2 != null && !id2.equals("id")) {
                                    this.text.append('$').append('{').append(id2).append('}');
                                    includeNestedText = false;
                                }
                            }
                            this.textInclusionState.addLast(includeNestedText);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append('<');
                        String prefix = parser.getPrefix();
                        if (prefix != null) {
                            this.rawXml.append(prefix).append(':');
                        }
                        this.rawXml.append(tagName);
                        int numAttr = parser.getAttributeCount();
                        for (int i2 = 0; i2 < numAttr; ++i2) {
                            this.rawXml.append(' ');
                            String attributePrefix = parser.getAttributePrefix(i2);
                            if (attributePrefix != null) {
                                this.rawXml.append(attributePrefix).append(':');
                            }
                            this.rawXml.append(parser.getAttributeName(i2)).append('=').append('\"');
                            XmlUtils.appendXmlAttributeValue(this.rawXml, parser.getAttributeValue(i2));
                            this.rawXml.append('\"');
                        }
                        this.rawXml.append('>');
                        break;
                    }
                    case 3: {
                        if (parser.getDepth() <= elementDepth) {
                            return ValueXmlHelper.unescapeResourceString(this.text.toString(), false, true);
                        }
                        String tagName = parser.getName();
                        if (withRawXml) {
                            this.rawXml.append('<').append('/');
                            String prefix = parser.getPrefix();
                            if (prefix != null) {
                                this.rawXml.append(prefix).append(':');
                            }
                            this.rawXml.append(tagName).append('>');
                        }
                        if (!"g".equals(tagName) || !XmlTextExtractor.isXliffNamespace(parser.getNamespace())) break;
                        this.textInclusionState.removeLast();
                        break;
                    }
                    case 4: 
                    case 6: {
                        String textPiece = parser.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.rawXml.append(textPiece);
                        break;
                    }
                    case 5: {
                        String textPiece = parser.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append("<![CDATA[").append(textPiece).append("]]>");
                    }
                }
            } while (event != 1);
            return ValueXmlHelper.unescapeResourceString(this.text.toString(), false, true);
        }

        private boolean getTextInclusionState() {
            return this.textInclusionState.isEmpty() || this.textInclusionState.getLast() != false;
        }

        String getRawXml() {
            return this.nontrivialRawXml ? this.rawXml.toString() : null;
        }

        private static boolean isXliffNamespace(String namespaceUri) {
            return namespaceUri != null && namespaceUri.startsWith("urn:oasis:names:tc:xliff:document:");
        }
    }

    protected static class FolderInfo {
        public final ResourceFolderType folderType;
        public final FolderConfiguration configuration;
        public final ResourceType resourceType;
        public final boolean isIdGenerating;

        private FolderInfo(ResourceFolderType folderType, FolderConfiguration configuration, ResourceType resourceType, boolean isIdGenerating) {
            this.configuration = configuration;
            this.resourceType = resourceType;
            this.folderType = folderType;
            this.isIdGenerating = isIdGenerating;
        }

        public static FolderInfo create(String folderName, Map<String, FolderConfiguration> folderConfigCache) {
            boolean isIdGenerating;
            ResourceType resourceType;
            ResourceFolderType folderType = ResourceFolderType.getFolderType(folderName);
            if (folderType == null) {
                return null;
            }
            String qualifier = FolderConfiguration.getQualifier(folderName);
            FolderConfiguration config = folderConfigCache.computeIfAbsent(qualifier, FolderConfiguration::getConfigForQualifierString);
            if (config == null) {
                return null;
            }
            config.normalizeByRemovingRedundantVersionQualifier();
            if (folderType == ResourceFolderType.VALUES) {
                resourceType = null;
                isIdGenerating = false;
            } else {
                resourceType = FolderTypeRelationship.getNonIdRelatedResourceType(folderType);
                isIdGenerating = FolderTypeRelationship.isIdGeneratingFolderType(folderType);
            }
            return new FolderInfo(folderType, config, resourceType, isIdGenerating);
        }
    }

    private static class ResourceFileCollector
    implements FileVisitor<Path> {
        final List<PathString> resourceFiles = new ArrayList<PathString>();
        final List<IOException> ioErrors = new ArrayList<IOException>();
        final FileFilter fileFilter;

        private ResourceFileCollector(FileFilter filter2) {
            this.fileFilter = filter2;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.fileFilter.isIgnored(dir, attrs)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
            if (this.fileFilter.isIgnored(file2, attrs)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            this.resourceFiles.add(new PathString(file2));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file2, IOException exc) {
            this.ioErrors.add(exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }

    private static class XmlSyntaxException
    extends Exception {
        XmlSyntaxException(String error, XmlPullParser parser, String filename) {
            super(error + " at " + filename + " line " + parser.getLineNumber());
        }
    }

    private static interface XmlTagVisitor {
        public void visitTag() throws IOException, XmlPullParserException;
    }
}

