/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ProgressManagerAdapter;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.NamespaceResolver;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.tools.environment.Logger;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ResourceSerializationUtil {
    private static final Logger LOG = Logger.getInstance(ResourceSerializationUtil.class);

    public static void createPersistentCache(Path cacheFile, byte[] fileHeader, Base128StreamWriter contentWriter) {
        Path tempFile;
        try {
            Files.deleteIfExists(cacheFile);
        }
        catch (IOException e2) {
            LOG.warn("Unable to delete " + cacheFile.toString(), e2);
        }
        try {
            cacheFile.getParent().toFile().mkdirs();
            tempFile = Files.createTempFile(cacheFile.getParent().toAbsolutePath(), cacheFile.getFileName().toString(), ".tmp", new FileAttribute[0]);
        }
        catch (IOException e3) {
            LOG.error("Unable to create a temporary file in " + cacheFile.getParent().toString(), e3);
            return;
        }
        try (Base128OutputStream stream = new Base128OutputStream(tempFile);){
            stream.write(fileHeader);
            contentWriter.write(stream);
        }
        catch (Throwable e4) {
            LOG.error("Unable to create cache file " + tempFile.toString(), e4);
            ResourceSerializationUtil.deleteIgnoringErrors(tempFile);
            return;
        }
        try {
            Files.move(tempFile, cacheFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e4) {
        }
        catch (IOException e5) {
            LOG.error("Unable to create cache file " + cacheFile.toString(), e5);
            ResourceSerializationUtil.deleteIgnoringErrors(tempFile);
        }
    }

    public static void writeResourcesToStream(Map<ResourceType, ListMultimap<String, ResourceItem>> resources, Base128OutputStream stream, Predicate<FolderConfiguration> configFilter) throws IOException {
        FolderConfiguration configuration;
        Object2IntOpenHashMap<String> qualifierStringIndexes = new Object2IntOpenHashMap<String>();
        qualifierStringIndexes.defaultReturnValue(-1);
        Object2IntOpenHashMap<ResourceSourceFile> sourceFileIndexes = new Object2IntOpenHashMap<ResourceSourceFile>();
        sourceFileIndexes.defaultReturnValue(-1);
        Object2IntOpenHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes = new Object2IntOpenHashMap<ResourceNamespace.Resolver>();
        namespaceResolverIndexes.defaultReturnValue(-1);
        int itemCount = 0;
        Collection<ListMultimap<String, ResourceItem>> resourceMaps = resources.values();
        for (ListMultimap<String, ResourceItem> resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                ResourceSourceFile sourceFile;
                configuration = item.getConfiguration();
                if (!configFilter.test(configuration)) continue;
                String qualifier = configuration.getQualifierString();
                if (!qualifierStringIndexes.containsKey(qualifier)) {
                    qualifierStringIndexes.put(qualifier, qualifierStringIndexes.size());
                }
                if (item instanceof BasicValueResourceItemBase && !sourceFileIndexes.containsKey(sourceFile = ((BasicValueResourceItemBase)item).getSourceFile())) {
                    sourceFileIndexes.put(sourceFile, sourceFileIndexes.size());
                }
                if (item instanceof ResourceValue) {
                    ResourceSerializationUtil.addToNamespaceResolverIndexes(((ResourceValue)((Object)item)).getNamespaceResolver(), namespaceResolverIndexes);
                }
                if (item instanceof BasicStyleResourceItem) {
                    for (StyleItemResourceValue styleItem : ((BasicStyleResourceItem)item).getDefinedItems()) {
                        ResourceSerializationUtil.addToNamespaceResolverIndexes(styleItem.getNamespaceResolver(), namespaceResolverIndexes);
                    }
                } else if (item instanceof BasicStyleableResourceItem) {
                    for (AttrResourceValue attr : ((BasicStyleableResourceItem)item).getAllAttributes()) {
                        ResourceSerializationUtil.addToNamespaceResolverIndexes(attr.getNamespaceResolver(), namespaceResolverIndexes);
                    }
                }
                ++itemCount;
            }
        }
        ResourceSerializationUtil.writeStrings(qualifierStringIndexes, stream);
        ResourceSerializationUtil.writeSourceFiles(sourceFileIndexes, stream, qualifierStringIndexes);
        ResourceSerializationUtil.writeNamespaceResolvers(namespaceResolverIndexes, stream);
        stream.writeInt(itemCount);
        for (ListMultimap<String, ResourceItem> resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                configuration = item.getConfiguration();
                if (!configFilter.test(configuration)) continue;
                ((BasicResourceItemBase)item).serialize(stream, qualifierStringIndexes, sourceFileIndexes, namespaceResolverIndexes);
            }
        }
    }

    private static void addToNamespaceResolverIndexes(ResourceNamespace.Resolver resolver2, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) {
        if (!namespaceResolverIndexes.containsKey(resolver2)) {
            namespaceResolverIndexes.put(resolver2, namespaceResolverIndexes.size());
        }
    }

    public static void readResourcesFromStream(Base128InputStream stream, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache, LoadableResourceRepository repository, Consumer<BasicResourceItem> resourceConsumer) throws IOException {
        stream.setStringCache(stringCache);
        int n2 = stream.readInt();
        if (n2 == 0) {
            return;
        }
        ArrayList<RepositoryConfiguration> configurations = new ArrayList<RepositoryConfiguration>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String configQualifier = stream.readString();
            if (configQualifier == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForQualifierString(configQualifier);
            if (folderConfig == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            configurations.add(new RepositoryConfiguration(repository, folderConfig));
        }
        n2 = stream.readInt();
        ArrayList<ResourceSourceFile> newSourceFiles = new ArrayList<ResourceSourceFile>(n2);
        for (int i3 = 0; i3 < n2; ++i3) {
            ResourceSourceFile sourceFile = repository.deserializeResourceSourceFile(stream, configurations);
            newSourceFiles.add(sourceFile);
        }
        n2 = stream.readInt();
        ArrayList<ResourceNamespace.Resolver> newNamespaceResolvers = new ArrayList<ResourceNamespace.Resolver>(n2);
        for (int i4 = 0; i4 < n2; ++i4) {
            NamespaceResolver namespaceResolver = NamespaceResolver.deserialize(stream);
            if (namespaceResolverCache != null) {
                namespaceResolver = namespaceResolverCache.computeIfAbsent(namespaceResolver, Function.identity());
            }
            newNamespaceResolvers.add(namespaceResolver);
        }
        n2 = stream.readInt();
        int cancellationCheckInterval = 500;
        for (int i5 = 0; i5 < n2; ++i5) {
            if (i5 % cancellationCheckInterval == 0) {
                ProgressManagerAdapter.checkCanceled();
            }
            BasicResourceItemBase item = BasicResourceItemBase.deserialize(stream, configurations, newSourceFiles, newNamespaceResolvers);
            resourceConsumer.accept(item);
        }
    }

    public static byte[] getCacheFileHeader(Base128StreamWriter headerWriter) {
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(header);){
            headerWriter.write(stream);
        }
        catch (IOException e2) {
            throw new Error("Internal error", e2);
        }
        return header.toByteArray();
    }

    private static void deleteIgnoringErrors(Path file2) {
        try {
            Files.deleteIfExists(file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeStrings(Object2IntMap<String> qualifierStringIndexes, Base128OutputStream stream) throws IOException {
        String[] strings2 = new String[qualifierStringIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(qualifierStringIndexes)) {
            strings2[entry.getIntValue()] = (String)entry.getKey();
        }
        stream.writeInt(strings2.length);
        for (String str : strings2) {
            stream.writeString(str);
        }
    }

    private static void writeSourceFiles(Object2IntMap<ResourceSourceFile> sourceFileIndexes, Base128OutputStream stream, Object2IntMap<String> qualifierStringIndexes) throws IOException {
        ResourceSourceFile[] sourceFiles = new ResourceSourceFile[sourceFileIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(sourceFileIndexes)) {
            sourceFiles[entry.getIntValue()] = (ResourceSourceFile)entry.getKey();
        }
        stream.writeInt(sourceFiles.length);
        for (ResourceSourceFile sourceFile : sourceFiles) {
            sourceFile.serialize(stream, qualifierStringIndexes);
        }
    }

    private static void writeNamespaceResolvers(Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes, Base128OutputStream stream) throws IOException {
        ResourceNamespace.Resolver[] resolvers = new ResourceNamespace.Resolver[namespaceResolverIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(namespaceResolverIndexes)) {
            resolvers[entry.getIntValue()] = (ResourceNamespace.Resolver)entry.getKey();
        }
        stream.writeInt(resolvers.length);
        for (ResourceNamespace.Resolver resolver2 : resolvers) {
            NamespaceResolver serializableResolver = resolver2 == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver2;
            serializableResolver.serialize(stream);
        }
    }

    public static interface Base128StreamWriter {
        public void write(Base128OutputStream var1) throws IOException;
    }
}

