/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.base.CommentTrackingXmlPullParser;
import com.android.resources.base.NamespaceResolver;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.xmlpull.v1.XmlPullParserException;

class ValueResourceXmlParser
extends CommentTrackingXmlPullParser {
    final Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
    final Deque<NamespaceResolver> resolverStack = new ArrayDeque<NamespaceResolver>(4);

    ValueResourceXmlParser() {
    }

    public ResourceNamespace.Resolver getNamespaceResolver() throws XmlPullParserException {
        Preconditions.checkState(this.getEventType() == 2);
        if (this.resolverStack.isEmpty()) {
            return ResourceNamespace.Resolver.EMPTY_RESOLVER;
        }
        NamespaceResolver resolver2 = this.resolverStack.getLast();
        return resolver2.getNamespaceCount() == 0 ? ResourceNamespace.Resolver.EMPTY_RESOLVER : resolver2;
    }

    @Override
    public void setInput(Reader reader) throws XmlPullParserException {
        super.setInput(reader);
        this.resolverStack.clear();
    }

    @Override
    public void setInput(InputStream inputStream, String encoding) throws XmlPullParserException {
        super.setInput(inputStream, encoding);
        this.resolverStack.clear();
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        int token2 = super.nextToken();
        this.processToken(token2);
        return token2;
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        int token2 = super.next();
        this.processToken(token2);
        return token2;
    }

    private void processToken(int token2) throws XmlPullParserException {
        switch (token2) {
            case 2: {
                int namespaceCount = this.getNamespaceCount(this.getDepth());
                NamespaceResolver parent = this.resolverStack.isEmpty() ? null : this.resolverStack.getLast();
                NamespaceResolver current2 = parent != null && parent.getNamespaceCount() == namespaceCount ? parent : this.getOrCreateResolver();
                this.resolverStack.add(current2);
                assert (this.resolverStack.size() == this.getDepth());
                break;
            }
            case 3: {
                this.resolverStack.removeLast();
            }
        }
    }

    private NamespaceResolver getOrCreateResolver() throws XmlPullParserException {
        return this.namespaceResolverCache.computeIfAbsent(new NamespaceResolver(this), Function.identity());
    }
}

