/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.io.CancellableFileIo;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathFileWrapper
implements IAbstractFile,
IAbstractFolder {
    private final Path mFile;

    public PathFileWrapper(Path path) {
        this.mFile = path;
    }

    @Override
    public InputStream getContents() throws StreamException {
        try {
            return CancellableFileIo.newInputStream(this.mFile, new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new StreamException(e2, this);
        }
    }

    @Override
    public void setContents(InputStream source) throws StreamException {
        try (OutputStream fos = Files.newOutputStream(this.mFile, new OpenOption[0]);){
            int count2;
            byte[] buffer = new byte[1024];
            while ((count2 = source.read(buffer)) != -1) {
                fos.write(buffer, 0, count2);
            }
        }
        catch (IOException e2) {
            throw new StreamException(e2, this);
        }
    }

    @Override
    public OutputStream getOutputStream() throws StreamException {
        try {
            return Files.newOutputStream(this.mFile, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new StreamException(ex, this);
        }
    }

    @Override
    public String getOsLocation() {
        return this.mFile.toAbsolutePath().toString();
    }

    @Override
    public boolean exists() {
        return CancellableFileIo.exists(this.mFile, new LinkOption[0]);
    }

    @Override
    public IAbstractFile getFile(String name2) {
        return new PathFileWrapper(this.mFile.resolve(name2));
    }
}

