/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.api.RepoManager;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.DefaultDevices;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.sdklib.devices.DeviceWriter;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Hinge;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.devices.VendorDevices;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class DeviceManager {
    private static final String DEVICE_PROFILES_PROP = "DeviceProfiles";
    private static final Pattern PATH_PROPERTY_PATTERN = Pattern.compile("^Extra.Path=DeviceProfiles$");
    private final Path mAndroidFolder;
    private final ILogger mLog;
    private final VendorDevices mVendorDevices;
    private Table<String, String, Device> mSdkVendorDevices;
    private Table<String, String, Device> mSysImgDevices;
    private Table<String, String, Device> mUserDevices;
    private final DefaultDevices mDefaultDevices;
    private final Object mLock = new Object();
    private final List<DevicesChangedListener> sListeners = new ArrayList<DevicesChangedListener>();
    private final Path mOsSdkPath;
    private final AndroidSdkHandler mSdkHandler;
    public static final EnumSet<DeviceFilter> ALL_DEVICES = EnumSet.allOf(DeviceFilter.class);

    public static DeviceManager createInstance(AndroidLocationsProvider androidLocationsProvider, Path sdkLocation, ILogger log) {
        return DeviceManager.createInstance(AndroidSdkHandler.getInstance(androidLocationsProvider, sdkLocation), log);
    }

    public static DeviceManager createInstance(AndroidSdkHandler sdkHandler, ILogger log) {
        return new DeviceManager(sdkHandler, log);
    }

    private DeviceManager(AndroidSdkHandler sdkHandler, ILogger log) {
        this.mSdkHandler = sdkHandler;
        this.mOsSdkPath = sdkHandler.getLocation() == null ? null : sdkHandler.getLocation();
        this.mAndroidFolder = sdkHandler.getAndroidFolder() == null ? Paths.get("", new String[0]) : sdkHandler.getAndroidFolder();
        this.mLog = log;
        this.mDefaultDevices = new DefaultDevices(this.mLog);
        this.mVendorDevices = new VendorDevices(this.mLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(DevicesChangedListener listener) {
        List<DevicesChangedListener> list2 = this.sListeners;
        synchronized (list2) {
            if (!this.sListeners.contains(listener)) {
                this.sListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(DevicesChangedListener listener) {
        List<DevicesChangedListener> list2 = this.sListeners;
        synchronized (list2) {
            return this.sListeners.remove(listener);
        }
    }

    public DeviceStatus getDeviceStatus(String name2, String manufacturer) {
        Device d2 = this.getDevice(name2, manufacturer);
        if (d2 == null) {
            return DeviceStatus.MISSING;
        }
        return DeviceStatus.EXISTS;
    }

    public Device getDevice(String id2, String manufacturer) {
        this.initDevicesLists();
        Device d2 = this.mUserDevices.get(id2, manufacturer);
        if (d2 != null) {
            return d2;
        }
        d2 = this.mSysImgDevices.get(id2, manufacturer);
        if (d2 != null) {
            return d2;
        }
        d2 = this.mDefaultDevices.getDevice(id2, manufacturer);
        if (d2 != null) {
            return d2;
        }
        d2 = this.mVendorDevices.getDevice(id2, manufacturer);
        if (d2 != null) {
            return d2;
        }
        d2 = this.mSdkVendorDevices.get(id2, manufacturer);
        return d2;
    }

    public Collection<Device> getDevices(DeviceFilter deviceFilter) {
        return this.getDevices(EnumSet.of(deviceFilter));
    }

    public Collection<Device> getDevices(Collection<DeviceFilter> deviceFilter) {
        this.initDevicesLists();
        HashBasedTable<String, String, Device> devices = HashBasedTable.create();
        if (this.mUserDevices != null && deviceFilter.contains((Object)DeviceFilter.USER)) {
            devices.putAll(this.mUserDevices);
        }
        if (this.mDefaultDevices.getDevices() != null && deviceFilter.contains((Object)DeviceFilter.DEFAULT)) {
            devices.putAll(this.mDefaultDevices.getDevices());
        }
        if (this.mVendorDevices.getDevices() != null && deviceFilter.contains((Object)DeviceFilter.VENDOR)) {
            devices.putAll(this.mVendorDevices.getDevices());
        }
        if (this.mSdkVendorDevices != null && deviceFilter.contains((Object)DeviceFilter.VENDOR)) {
            devices.putAll(this.mSdkVendorDevices);
        }
        if (this.mSysImgDevices != null && deviceFilter.contains((Object)DeviceFilter.SYSTEM_IMAGES)) {
            devices.putAll(this.mSysImgDevices);
        }
        return Collections.unmodifiableCollection(devices.values());
    }

    private void initDevicesLists() {
        boolean changed = this.mDefaultDevices.init();
        changed |= this.mVendorDevices.init();
        changed |= this.initSdkVendorDevices();
        changed |= this.initSysImgDevices();
        if (changed |= this.initUserDevices()) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initSdkVendorDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSdkVendorDevices != null) {
                return false;
            }
            this.mSdkVendorDevices = HashBasedTable.create();
            if (this.mOsSdkPath != null) {
                Path extrasFolder = this.mOsSdkPath.resolve("extras");
                List<Path> deviceDirs = this.getExtraDirs(extrasFolder);
                for (Path deviceDir : deviceDirs) {
                    Path deviceXml = deviceDir.resolve("devices.xml");
                    if (!Files.isRegularFile(deviceXml, new LinkOption[0])) continue;
                    this.mSdkVendorDevices.putAll(this.loadDevices(deviceXml));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    private boolean initSysImgDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSysImgDevices != null) {
                return false;
            }
            this.mSysImgDevices = HashBasedTable.create();
            if (this.mOsSdkPath == null) {
                return false;
            }
            LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(this.mLog);
            RepoManager mgr = this.mSdkHandler.getSdkManager(progress);
            mgr.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress, null, null);
            mgr.getPackages().getLocalPackages().values().stream().filter(pkg -> pkg.getTypeDetails() instanceof DetailsTypes.SysImgDetailsType).sorted(Comparator.comparing(pkg -> ((DetailsTypes.SysImgDetailsType)((Object)pkg.getTypeDetails())).getAndroidVersion())).forEach(pkg -> {
                Path deviceXml = pkg.getLocation().resolve("devices.xml");
                if (CancellableFileIo.isRegularFile(deviceXml, new LinkOption[0])) {
                    this.mSysImgDevices.putAll(this.loadDevices(deviceXml));
                }
            });
            this.markDeprecatedWearSkins();
            return true;
        }
    }

    private void markDeprecatedWearSkins() {
        this.mSysImgDevices.values().forEach(device -> {
            if ("android-wear".equals(device.getTagId())) {
                device.setIsDeprecated(!device.getId().startsWith("wearos"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initUserDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices != null) {
                return false;
            }
            this.mUserDevices = HashBasedTable.create();
            Path userDevicesFile = null;
            try {
                try {
                    userDevicesFile = this.mAndroidFolder.resolve("devices.xml");
                    if (userDevicesFile != null && Files.exists(userDevicesFile, new LinkOption[0])) {
                        this.mUserDevices.putAll(DeviceParser.parse(userDevicesFile));
                        return true;
                    }
                }
                catch (SAXException e2) {
                    if (userDevicesFile != null) {
                        Path parent = userDevicesFile.toAbsolutePath().getParent();
                        String base = userDevicesFile.getFileName().toString() + ".old";
                        Path renamedConfig = parent.resolve(base);
                        int i2 = 0;
                        while (CancellableFileIo.exists(renamedConfig, new LinkOption[0])) {
                            renamedConfig = parent.resolve(base + "." + i2++);
                        }
                        this.mLog.error(e2, "Error parsing %1$s, backing up to %2$s", userDevicesFile.toAbsolutePath(), renamedConfig.toAbsolutePath());
                        Files.move(userDevicesFile, renamedConfig, new CopyOption[0]);
                    }
                }
            }
            catch (IOException | ParserConfigurationException e3) {
                this.mLog.error(e3, "Error parsing %1$s", userDevicesFile == null ? "(null)" : userDevicesFile.toAbsolutePath());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserDevice(Device d2) {
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                this.mUserDevices.put(d2.getId(), d2.getManufacturer(), d2);
            }
            changed = true;
        }
        if (changed) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDevice(Device d2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null && this.mUserDevices.contains(d2.getId(), d2.getManufacturer())) {
                this.mUserDevices.remove(d2.getId(), d2.getManufacturer());
                this.notifyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUserDevice(Device d2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
            }
            this.removeUserDevice(d2);
            this.addUserDevice(d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserDevices() {
        if (this.mUserDevices == null) {
            return;
        }
        if (this.mAndroidFolder == null) {
            return;
        }
        Path userDevicesFile = this.mAndroidFolder.resolve("devices.xml");
        if (this.mUserDevices.isEmpty()) {
            try {
                Files.deleteIfExists(userDevicesFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserDevices.isEmpty()) {
                try {
                    DeviceWriter.writeToXml(Files.newOutputStream(userDevicesFile, new OpenOption[0]), this.mUserDevices.values());
                }
                catch (FileNotFoundException e2) {
                    this.mLog.warning("Couldn't open file: %1$s", e2.getMessage());
                }
                catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e3) {
                    this.mLog.warning("Error writing file: %1$s", e3.getMessage());
                }
            }
        }
    }

    public static Map<String, String> getHardwareProperties(State s2) {
        Hinge hinge;
        Hardware hw = s2.getHardware();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hw.mainKeys", DeviceManager.getBooleanVal(hw.getButtonType().equals((Object)ButtonType.HARD)));
        props.put("hw.trackBall", DeviceManager.getBooleanVal(hw.getNav().equals(Navigation.TRACKBALL)));
        props.put("hw.dPad", DeviceManager.getBooleanVal(hw.getNav().equals(Navigation.DPAD)));
        Set<Sensor> sensors = hw.getSensors();
        props.put("hw.gps", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GPS)));
        props.put("hw.battery", DeviceManager.getBooleanVal(hw.getChargeType().equals((Object)PowerType.BATTERY)));
        props.put("hw.accelerometer", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.ACCELEROMETER)));
        props.put("hw.sensors.orientation", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GYROSCOPE)));
        props.put("hw.audioInput", DeviceManager.getBooleanVal(hw.hasMic()));
        props.put("hw.sdCard", DeviceManager.getBooleanVal(hw.hasSdCard()));
        props.put("hw.lcd.density", Integer.toString(hw.getScreen().getPixelDensity().getDpiValue()));
        props.put("hw.lcd.width", Integer.toString(hw.getScreen().getXDimension()));
        props.put("hw.lcd.height", Integer.toString(hw.getScreen().getYDimension()));
        props.put("hw.sensors.proximity", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.PROXIMITY_SENSOR)));
        if (hw.getScreen().isFoldable()) {
            props.put("hw.keyboard.lid", DeviceManager.getBooleanVal(true));
            props.put("hw.displayRegion.0.1.xOffset", Integer.toString(hw.getScreen().getFoldedXOffset()));
            props.put("hw.displayRegion.0.1.yOffset", Integer.toString(hw.getScreen().getFoldedYOffset()));
            props.put("hw.displayRegion.0.1.height", Integer.toString(hw.getScreen().getFoldedHeight()));
            props.put("hw.displayRegion.0.1.width", Integer.toString(hw.getScreen().getFoldedWidth()));
            if (hw.getScreen().getFoldedWidth2() != 0 && hw.getScreen().getFoldedHeight2() != 0) {
                props.put("hw.displayRegion.0.2.xOffset", Integer.toString(hw.getScreen().getFoldedXOffset2()));
                props.put("hw.displayRegion.0.2.yOffset", Integer.toString(hw.getScreen().getFoldedYOffset2()));
                props.put("hw.displayRegion.0.2.width", Integer.toString(hw.getScreen().getFoldedWidth2()));
                props.put("hw.displayRegion.0.2.height", Integer.toString(hw.getScreen().getFoldedHeight2()));
            }
            if (hw.getScreen().getFoldedWidth3() != 0 && hw.getScreen().getFoldedHeight3() != 0) {
                props.put("hw.displayRegion.0.3.xOffset", Integer.toString(hw.getScreen().getFoldedXOffset3()));
                props.put("hw.displayRegion.0.3.yOffset", Integer.toString(hw.getScreen().getFoldedYOffset3()));
                props.put("hw.displayRegion.0.3.width", Integer.toString(hw.getScreen().getFoldedWidth3()));
                props.put("hw.displayRegion.0.3.height", Integer.toString(hw.getScreen().getFoldedHeight3()));
            }
        }
        if ((hinge = hw.getHinge()) != null) {
            props.put("hw.sensor.hinge", hinge.getCount() > 0 ? "yes" : "no");
            props.put("hw.sensor.hinge.count", Integer.toString(hinge.getCount()));
            props.put("hw.sensor.hinge.type", Integer.toString(hinge.getType()));
            props.put("hw.sensor.hinge.sub_type", Integer.toString(hinge.getSubtype()));
            props.put("hw.sensor.hinge.ranges", hinge.getRanges());
            props.put("hw.sensor.hinge.defaults", Integer.toString(hinge.getDefaults()));
            props.put("hw.sensor.hinge.areas", hinge.getAreas());
            hinge.getFoldAtPosture().ifPresent(fold2 -> props.put("hw.sensor.hinge.fold_to_displayRegion.0.1_at_posture", Integer.toString(fold2)));
            props.put("hw.sensor.posture_list", hinge.getPostureList());
            props.put("hw.sensor.hinge_angles_posture_definitions", hinge.getHingeAnglePostureDefinitions());
        }
        return props;
    }

    public static Map<String, String> getHardwareProperties(Device d2) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d2.getDefaultState());
        for (State s2 : d2.getAllStates()) {
            Storage ramSize = s2.getHardware().getRam();
            if (ramSize.getSize() > 0L) {
                props.put("hw.ramSize", Long.toString(ramSize.getSizeAsUnit(Storage.Unit.MiB)));
            }
            if (!s2.getKeyState().equals(KeyboardState.HIDDEN)) continue;
            props.put("hw.keyboard.lid", DeviceManager.getBooleanVal(true));
        }
        HashFunction md52 = Hashing.md5();
        Hasher hasher = md52.newHasher();
        ArrayList<String> keys2 = new ArrayList<String>(props.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            if (key == null) continue;
            hasher.putString(key, Charsets.UTF_8);
            String value = props.get(key);
            hasher.putString(value == null ? "null" : value, Charsets.UTF_8);
        }
        String hash = "MD5:" + hasher.hash().toString();
        props.put("hw.device.hash2", hash);
        props.remove("hw.device.hash");
        props.put("hw.device.name", d2.getId());
        props.put("hw.device.manufacturer", d2.getManufacturer());
        if (d2.getId().equals("13.5in Freeform")) {
            props.put("display.settings.xml", "freeform");
        }
        if (Device.isRollable(d2.getId())) {
            props.put("hw.sensor.roll", "yes");
            props.put("hw.sensor.roll.count", "1");
            props.put("hw.sensor.hinge.type", "3");
            props.put("hw.sensor.roll.ranges", "58.55-100");
            props.put("hw.sensor.roll.defaults", "67.5");
            props.put("hw.sensor.roll.radius", "3");
            props.put("hw.sensor.roll.direction", "1");
            props.put("hw.sensor.roll.resize_to_displayRegion.0.1_at_posture", "1");
            props.put("hw.sensor.roll.resize_to_displayRegion.0.2_at_posture", "2");
            props.put("hw.sensor.posture_list", "1, 2, 3");
            props.put("hw.sensor.roll_percentages_posture_definitions", "58.55-76.45, 76.45-94.35, 94.35-100");
        }
        if (d2.getId().equals("resizable")) {
            props.put("hw.resizable.configs", "phone-0-1080-2400-420, foldable-1-2208-1840-420, tablet-2-1920-1200-240, desktop-3-1920-1080-160");
        }
        if (Device.isAutomotive(d2)) {
            props.put("hw.display6.width", "400");
            props.put("hw.display6.height", "600");
            props.put("hw.display6.density", "120");
            props.put("hw.display6.flag", "0");
        }
        if (Device.isAutomotiveDistantDisplay(d2)) {
            props.put("hw.display7.width", "3000");
            props.put("hw.display7.height", "600");
            props.put("hw.display7.density", "120");
            props.put("hw.display7.flag", "0");
        }
        return props;
    }

    public static String hasHardwarePropHashChanged(Device d2, String hashV2) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d2);
        String newHash = props.get("hw.device.hash2");
        if (newHash != null && newHash.equals(hashV2)) {
            return null;
        }
        return newHash;
    }

    private static String getBooleanVal(boolean bool) {
        if (bool) {
            return "yes";
        }
        return "no";
    }

    private Table<String, String, Device> loadDevices(Path deviceXml) {
        try {
            return DeviceParser.parse(deviceXml);
        }
        catch (AssertionError | ParserConfigurationException | SAXException e2) {
            this.mLog.error((Throwable)e2, "Error parsing %1$s", deviceXml.toAbsolutePath());
        }
        catch (IOException e3) {
            this.mLog.error(e3, "Error reading %1$s", deviceXml.toAbsolutePath());
        }
        catch (IllegalStateException e4) {
            this.mLog.error(e4, null, new Object[0]);
        }
        return HashBasedTable.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<DevicesChangedListener> list2 = this.sListeners;
        synchronized (list2) {
            for (DevicesChangedListener listener : this.sListeners) {
                listener.onDevicesChanged();
            }
        }
    }

    private List<Path> getExtraDirs(Path extrasFolder) {
        final ArrayList<Path> extraDirs = new ArrayList<Path>();
        if (CancellableFileIo.isDirectory(extrasFolder, new LinkOption[0])) {
            try {
                Files.walkFileTree(extrasFolder, ImmutableSet.of(), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                        if (attrs.isDirectory() && DeviceManager.isDevicesExtra(file2)) {
                            extraDirs.add(file2);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return extraDirs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isDevicesExtra(Path item) {
        Path properties = item.resolve("source.properties");
        try (BufferedReader propertiesReader = Files.newBufferedReader(properties);){
            String line;
            Matcher m4;
            do {
                if ((line = propertiesReader.readLine()) == null) return false;
            } while (!(m4 = PATH_PROPERTY_PATTERN.matcher(line)).matches());
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static enum DeviceStatus {
        EXISTS,
        CHANGED,
        MISSING;

    }

    public static enum DeviceFilter {
        DEFAULT,
        USER,
        VENDOR,
        SYSTEM_IMAGES;

    }

    public static interface DevicesChangedListener {
        public void onDevicesChanged();
    }
}

