/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.installer;

import com.android.repository.api.Installer;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.PlatformTarget;
import java.nio.file.Path;

public class SourceInstallListener
implements PackageOperation.StatusChangeListener {
    private final AndroidSdkHandler mSdkHandler;

    public SourceInstallListener(AndroidSdkHandler sdkHandler) {
        this.mSdkHandler = sdkHandler;
    }

    @Override
    public void statusChanged(PackageOperation op, ProgressIndicator progress) throws PackageOperation.StatusChangeListenerException {
        if (op.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
            String targetHash = AndroidTargetHash.getPlatformHashString(((DetailsTypes.ApiDetailsType)((Object)op.getPackage().getTypeDetails())).getAndroidVersion());
            IAndroidTarget target = this.mSdkHandler.getAndroidTargetManager(progress).getTargetFromHashString(targetHash, progress);
            if (target instanceof PlatformTarget) {
                Path sourcePath2 = null;
                if (op instanceof Installer) {
                    sourcePath2 = op.getLocation(progress);
                }
                ((PlatformTarget)target).setSources(sourcePath2);
            }
        }
    }
}

