/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.io.CancellableFileIo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.stream.Stream;

public abstract class FileOp {
    public abstract FileSystem getFileSystem();

    public final void deleteFileOrFolder(File fileOrFolder) {
        if (this.isDirectory(fileOrFolder)) {
            for (File item : this.listFiles(fileOrFolder)) {
                this.deleteFileOrFolder(item);
            }
        }
        this.delete(fileOrFolder);
    }

    public final boolean exists(File file2) {
        return CancellableFileIo.exists(this.toPath(file2), new LinkOption[0]);
    }

    public final boolean isFile(File file2) {
        return CancellableFileIo.isRegularFile(this.toPath(file2), new LinkOption[0]);
    }

    public final boolean isDirectory(File file2) {
        return CancellableFileIo.isDirectory(this.toPath(file2), new LinkOption[0]);
    }

    public final long length(File file2) throws IOException {
        return CancellableFileIo.size(this.toPath(file2));
    }

    public boolean delete(File file2) {
        try {
            Files.delete(this.toPath(file2));
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public final boolean mkdirs(File file2) {
        try {
            Files.createDirectories(this.toPath(file2), new FileAttribute[0]);
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public final File[] listFiles(File file2) {
        File[] fileArray;
        block8: {
            Stream<Path> children2 = CancellableFileIo.list(this.toPath(file2));
            try {
                fileArray = (File[])children2.map(path -> new File(path.toString())).toArray(File[]::new);
                if (children2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (children2 != null) {
                        try {
                            children2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return new File[0];
                }
            }
            children2.close();
        }
        return fileArray;
    }

    public OutputStream newFileOutputStream(File file2) throws IOException {
        return this.newFileOutputStream(file2, false);
    }

    public OutputStream newFileOutputStream(File file2, boolean append) throws IOException {
        if (append) {
            return Files.newOutputStream(this.toPath(file2), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(this.toPath(file2), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public final InputStream newFileInputStream(File file2) throws IOException {
        return this.newFileInputStream(this.toPath(file2));
    }

    public final InputStream newFileInputStream(Path path) throws IOException {
        return CancellableFileIo.newInputStream(path, new OpenOption[0]);
    }

    public final long lastModified(File file2) {
        try {
            return CancellableFileIo.getLastModifiedTime(this.toPath(file2), new LinkOption[0]).toMillis();
        }
        catch (IOException e2) {
            return 0L;
        }
    }

    public final String readText(File f2) throws IOException {
        return CancellableFileIo.readString(this.toPath(f2));
    }

    public final boolean setLastModified(Path file2, long time) throws IOException {
        Files.setLastModifiedTime(file2, FileTime.fromMillis(time));
        return true;
    }

    public Path toPath(File file2) {
        return this.toPath(file2.getPath());
    }

    public Path toPath(String path) {
        return this.getFileSystem().getPath(path, new String[0]);
    }
}

