/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.repository.Revision;
import com.android.repository.api.Channel;
import com.android.repository.api.Checksum;
import com.android.repository.api.Dependency;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RemotePackageImpl;
import com.android.repository.impl.meta.RepoPackageImpl;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.LayoutlibVersion;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.legacy.LegacyRepoUtils;
import com.android.sdklib.repository.legacy.descriptors.PkgType;
import com.android.sdklib.repository.legacy.remote.RemotePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.archives.ArchFilter;
import com.android.sdklib.repository.legacy.remote.internal.archives.Archive;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteAddonPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemotePlatformPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkAddonSource;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkRepoSource;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSource;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSysImgSource;
import com.android.sdklib.repository.targets.OptionalLibraryImpl;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;

public class LegacyRemoteRepoLoader
implements FallbackRemoteRepoLoader {
    @Override
    public Collection<RemotePackage> parseLegacyXml(RepositorySource source, Downloader downloader, SettingsController settings, ProgressIndicator progress) {
        RemotePkgInfo[] packages = null;
        Collection<SchemaModule<?>> modules = source.getPermittedModules();
        double progressMax = 0.0;
        double progressIncrement = 1.0 / (double)modules.size();
        for (SchemaModule<?> module : modules) {
            SdkSource legacySource = null;
            if (module.equals(AndroidSdkHandler.getRepositoryModule())) {
                legacySource = new SdkRepoSource(source.getUrl(), "Legacy Repo Source");
            } else if (module.equals(AndroidSdkHandler.getAddonModule())) {
                legacySource = new SdkAddonSource(source.getUrl(), "Legacy Addon Source");
            } else if (module.equals(AndroidSdkHandler.getSysImgModule())) {
                legacySource = new SdkSysImgSource(source.getUrl(), "Legacy System Image Source");
            }
            if (legacySource != null) {
                legacySource.load(downloader, settings, progress.createSubProgress(progressMax + progressIncrement));
                if (legacySource.getFetchError() != null) {
                    progress.logInfo(legacySource.getFetchError());
                }
                if ((packages = legacySource.getPackages()) != null) break;
            }
            progress.setFraction(progressMax += progressIncrement);
        }
        ArrayList<RemotePackage> result2 = Lists.newArrayList();
        if (packages != null) {
            for (void var16_14 : packages) {
                if (var16_14.getPkgDesc().getType() == PkgType.PKG_SAMPLE) continue;
                LegacyRemotePackage pkg = new LegacyRemotePackage((RemotePkgInfo)var16_14, source);
                result2.add(pkg);
            }
        }
        return result2;
    }

    private class LegacyRemotePackage
    implements RemotePackage {
        private final RemotePkgInfo mWrapped;
        private RepositorySource mSource;
        private TypeDetails mDetails;

        LegacyRemotePackage(RemotePkgInfo remote, RepositorySource source) {
            this.mWrapped = remote;
            this.mSource = source;
        }

        @Override
        public TypeDetails getTypeDetails() {
            if (this.mDetails == null) {
                LayoutlibVersion layoutlibVersion;
                int layoutlibApi = 0;
                if (this.mWrapped instanceof RemotePlatformPkgInfo && (layoutlibVersion = ((RemotePlatformPkgInfo)this.mWrapped).getLayoutLibVersion()) != null) {
                    layoutlibApi = layoutlibVersion.getApi();
                }
                ArrayList<OptionalLibrary> libs = Lists.newArrayList();
                if (this.mWrapped instanceof RemoteAddonPkgInfo) {
                    for (RemoteAddonPkgInfo.Lib wrappedLib : ((RemoteAddonPkgInfo)this.mWrapped).getLibs()) {
                        libs.add(new OptionalLibraryImpl(wrappedLib.getName(), Paths.get("", new String[0]), wrappedLib.getDescription(), false));
                    }
                }
                this.mDetails = LegacyRepoUtils.createTypeDetails(this.mWrapped.getPkgDesc(), layoutlibApi, libs, null);
            }
            return this.mDetails;
        }

        @Override
        public Revision getVersion() {
            return this.mWrapped.getRevision();
        }

        @Override
        public String getDisplayName() {
            return LegacyRepoUtils.getDisplayName(this.mWrapped.getPkgDesc());
        }

        @Override
        public License getLicense() {
            return this.mWrapped.getLicense();
        }

        @Override
        public Collection<Dependency> getAllDependencies() {
            return ImmutableList.of();
        }

        @Override
        public String getPath() {
            return LegacyRepoUtils.getLegacyPath(this.mWrapped.getPkgDesc(), null);
        }

        @Override
        public CommonFactory createFactory() {
            return RepoManager.getCommonModule().createLatestFactory();
        }

        @Override
        public RepoPackageImpl asMarshallable() {
            return RemotePackageImpl.create(this);
        }

        @Override
        public boolean obsolete() {
            return this.mWrapped.isObsolete();
        }

        @Override
        public int compareTo(RepoPackage o2) {
            int res = ComparisonChain.start().compare((Comparable<?>)((Object)this.getPath()), (Comparable<?>)((Object)o2.getPath())).compare(this.getVersion(), o2.getVersion()).result();
            if (res != 0) {
                return res;
            }
            if (!(o2 instanceof RemotePackage)) {
                return this.getClass().getName().compareTo(o2.getClass().getName());
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof RepoPackage && this.compareTo((RepoPackage)obj) == 0;
        }

        public int hashCode() {
            return this.getPath().hashCode() * 37 + this.getVersion().hashCode();
        }

        @Override
        public RepositorySource getSource() {
            return this.mSource;
        }

        @Override
        public void setSource(RepositorySource source) {
            this.mSource = source;
        }

        @Override
        public com.android.repository.impl.meta.Archive getArchive() {
            for (Archive archive : this.mWrapped.getArchives()) {
                if (!archive.isCompatible()) continue;
                CommonFactory f2 = RepoManager.getCommonModule().createLatestFactory();
                com.android.repository.impl.meta.Archive arch = f2.createArchiveType();
                Archive.CompleteType complete = f2.createCompleteType();
                complete.setTypedChecksum(Checksum.create(archive.getChecksum(), "sha1"));
                complete.setSize(archive.getSize());
                complete.setUrl(archive.getUrl());
                arch.setComplete(complete);
                ArchFilter filter2 = archive.getArchFilter();
                if (filter2.getHostBits() != null) {
                    arch.setHostBits(filter2.getHostBits().getSize());
                }
                if (filter2.getHostOS() != null) {
                    arch.setHostOs(filter2.getHostOS().getXmlName());
                }
                if (filter2.getJvmBits() != null) {
                    arch.setJvmBits(filter2.getJvmBits().getSize());
                }
                if (filter2.getMinJvmVersion() != null) {
                    arch.setMinJvmVersion(f2.createRevisionType(filter2.getMinJvmVersion()));
                }
                return arch;
            }
            return null;
        }

        @Override
        public Channel getChannel() {
            if (this.getVersion().isPreview()) {
                return Channel.create(1);
            }
            return Channel.create(0);
        }

        @Override
        public Path getInstallDir(RepoManager manager, ProgressIndicator progress) {
            Path path = manager.getLocalPath();
            return this.mWrapped.getPkgDesc().getCanonicalInstallFolder(path);
        }

        public String toString() {
            return "Legacy package: " + this.mWrapped.toString();
        }
    }
}

