/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal.packages;

import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.LayoutlibVersion;
import com.android.sdklib.repository.legacy.descriptors.PkgDesc;
import com.android.sdklib.repository.legacy.remote.internal.packages.LayoutlibVersionMixin;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteMinToolsPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemotePackageParserUtils;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSource;
import java.util.Map;
import org.w3c.dom.Node;

@Deprecated
public class RemotePlatformPkgInfo
extends RemoteMinToolsPkgInfo {
    private final String mVersionName;
    private final LayoutlibVersionMixin mLayoutlibVersion;

    public RemotePlatformPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mVersionName = RemotePackageParserUtils.getXmlString(packageNode, "version");
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = RemotePackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.isEmpty()) {
            codeName = null;
        }
        AndroidVersion version = new AndroidVersion(apiLevel, codeName);
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newPlatform(version, this.getRevision(), this.getMinToolsRevision());
        pkgDescBuilder.setDescriptionShort(RemotePlatformPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.mVersionName, version, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemotePlatformPkgInfo.createListDescription(this.mListDisplay, this.mVersionName, version, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    private static String createListDescription(String listDisplay, String versionName, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        String s2 = version.isPreview() ? String.format("SDK Platform Android %1$s Preview%2$s", versionName, obsolete ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s%2$s", versionName, obsolete ? " (Obsolete)" : "");
        return s2;
    }

    private static String createShortDescription(String listDisplay, Revision revision, String versionName, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        String s2 = version.isPreview() ? String.format("SDK Platform Android %1$s Preview, revision %2$s%3$s", versionName, revision.toShortString(), obsolete ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s, API %2$d, revision %3$s%4$s", versionName, version.getApiLevel(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
        return s2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result2 = 31 * result2 + (this.getPkgDesc().hasAndroidVersion() ? 0 : this.getPkgDesc().getAndroidVersion().hashCode());
        result2 = 31 * result2 + (this.mVersionName == null ? 0 : this.mVersionName.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemotePlatformPkgInfo)) {
            return false;
        }
        RemotePlatformPkgInfo other = (RemotePlatformPkgInfo)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        return !(this.mVersionName == null ? other.mVersionName != null : !this.mVersionName.equals(other.mVersionName));
    }

    public LayoutlibVersion getLayoutLibVersion() {
        return this.mLayoutlibVersion.getLayoutlibVersion();
    }
}

