/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.io.CancellableFileIo;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.PackageParserUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.SysImgFactory;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemImageManager {
    private final RepoManager mRepoManager;
    private final DetailsTypes.SysImgDetailsType mValidator;
    public static final String SYS_IMG_NAME = "system.img";
    private static final int MAX_DEPTH = 4;
    private Multimap<LocalPackage, SystemImage> mPackageToImage;
    private Map<Path, SystemImage> mPathToImage;
    private Table<IdDisplay, AndroidVersion, Multimap<IdDisplay, SystemImage>> mValuesToImage;

    public SystemImageManager(RepoManager mgr, SysImgFactory factory) {
        this.mRepoManager = mgr;
        this.mValidator = factory.createSysImgDetailsType();
    }

    public Collection<SystemImage> getImages() {
        if (this.mPackageToImage == null) {
            this.init();
        }
        return this.mPackageToImage.values();
    }

    public Multimap<LocalPackage, SystemImage> getImageMap() {
        if (this.mPackageToImage == null) {
            this.init();
        }
        return this.mPackageToImage;
    }

    public Collection<SystemImage> lookup(IdDisplay tag, AndroidVersion version, IdDisplay vendor) {
        Multimap<IdDisplay, SystemImage> m4;
        if (this.mValuesToImage == null) {
            this.init();
        }
        return (m4 = this.mValuesToImage.get(tag, version)) == null ? ImmutableList.of() : m4.get(vendor);
    }

    private void init() {
        Multimap<LocalPackage, SystemImage> images = this.buildImageMap();
        HashBasedTable<IdDisplay, AndroidVersion, Multimap<IdDisplay, SystemImage>> valuesToImage = HashBasedTable.create();
        HashMap<Path, SystemImage> pathToImages = Maps.newHashMap();
        for (SystemImage img : images.values()) {
            AndroidVersion version;
            IdDisplay vendor = img.getAddonVendor();
            IdDisplay tag = img.getTag();
            HashMultimap<IdDisplay, SystemImage> vendorImageMap = (HashMultimap<IdDisplay, SystemImage>)valuesToImage.get(tag, version = img.getAndroidVersion());
            if (vendorImageMap == null) {
                vendorImageMap = HashMultimap.create();
                valuesToImage.put(tag, version, vendorImageMap);
            }
            vendorImageMap.put(vendor, img);
            pathToImages.put(img.getLocation(), img);
        }
        this.mValuesToImage = valuesToImage;
        this.mPackageToImage = images;
        this.mPathToImage = pathToImages;
    }

    private Multimap<LocalPackage, SystemImage> buildImageMap() {
        HashMultimap<LocalPackage, SystemImage> result2 = HashMultimap.create();
        HashMap<AndroidVersion, Path> platformSkins = Maps.newHashMap();
        Collection<LocalPackage> packages = this.mRepoManager.getPackages().getLocalPackages().values();
        for (LocalPackage p2 : packages) {
            Path skinDir;
            if (!(p2.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType) || !CancellableFileIo.exists(skinDir = p2.getLocation().resolve("skins"), new LinkOption[0])) continue;
            platformSkins.put(((DetailsTypes.PlatformDetailsType)((Object)p2.getTypeDetails())).getAndroidVersion(), skinDir);
        }
        for (LocalPackage p2 : packages) {
            TypeDetails typeDetails = p2.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.SysImgDetailsType) && !(typeDetails instanceof DetailsTypes.PlatformDetailsType) && !(typeDetails instanceof DetailsTypes.AddonDetailsType)) continue;
            this.collectImages(p2.getLocation(), p2, platformSkins, result2);
        }
        return result2;
    }

    private void collectImages(Path dir, final LocalPackage p2, final Map<AndroidVersion, Path> platformSkins, final Multimap<LocalPackage, SystemImage> collector2) {
        try {
            CancellableFileIo.walkFileTree(dir, ImmutableSet.of(), 4, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    String name2 = dir.getFileName().toString();
                    if (name2.equals("data") || name2.equals("samples") || name2.equals("skins")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                    if (file2.toString().endsWith(SystemImageManager.SYS_IMG_NAME) && file2.getFileName().toString().equals(SystemImageManager.SYS_IMG_NAME)) {
                        collector2.put(p2, SystemImageManager.this.createSysImg(p2, file2.getParent(), platformSkins));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SystemImage createSysImg(LocalPackage p2, Path dir, Map<AndroidVersion, Path> platformSkins) {
        List<String> translatedAbis;
        List<String> abis;
        String containingDir = dir.getFileName().toString();
        TypeDetails details = p2.getTypeDetails();
        AndroidVersion version = null;
        if (details instanceof DetailsTypes.ApiDetailsType) {
            version = ((DetailsTypes.ApiDetailsType)((Object)details)).getAndroidVersion();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType) {
            abis = ((DetailsTypes.SysImgDetailsType)((Object)details)).getAbis();
            translatedAbis = ((DetailsTypes.SysImgDetailsType)((Object)details)).getTranslatedAbis();
        } else if (this.mValidator.isValidAbi(containingDir)) {
            abis = Collections.singletonList(containingDir);
            translatedAbis = Collections.emptyList();
        } else {
            abis = Collections.singletonList("armeabi");
            translatedAbis = Collections.emptyList();
        }
        IdDisplay vendor = null;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            vendor = ((DetailsTypes.AddonDetailsType)((Object)details)).getVendor();
        } else if (details instanceof DetailsTypes.SysImgDetailsType) {
            vendor = ((DetailsTypes.SysImgDetailsType)((Object)details)).getVendor();
        }
        Path skinDir = dir.resolve("skins");
        if (CancellableFileIo.notExists(skinDir, new LinkOption[0]) && version != null) {
            skinDir = platformSkins.get(version);
        }
        List<Object> skins = skinDir != null ? PackageParserUtils.parseSkinFolder(skinDir) : ImmutableList.of();
        return new SystemImage(dir, SystemImageTags.getTags(p2), vendor, abis, translatedAbis, skins, (RepoPackage)p2);
    }

    public ISystemImage getImageAt(Path imageDir) {
        if (this.mPathToImage == null) {
            this.init();
        }
        return this.mPathToImage.get(imageDir);
    }

    public void clearCache() {
        this.mPackageToImage = null;
        this.mPathToImage = null;
    }
}

