/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.Installer;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.installer.SdkInstallerUtil;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCli;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import com.android.sdklib.tool.sdkmanager.SdkPackagesAction;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;

class InstallAction
extends SdkPackagesAction {
    private static final String ACTION_ARG = "--install";

    InstallAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    public static void register(Map<String, Function<SdkManagerCliSettings, SdkAction>> argToFactory) {
        argToFactory.put(ACTION_ARG, InstallAction::new);
    }

    @Override
    @Slow
    public void execute(ProgressIndicator progress) throws SdkManagerCli.CommandFailedException {
        progress.setText("Loading package information...");
        this.getRepoManager().loadSynchronously(0L, progress.createSubProgress(0.1), this.getDownloader(), this.mSettings);
        List<RemotePackage> remotes = new ArrayList<RemotePackage>();
        for (String path : this.getPaths(this.getRepoManager())) {
            RemotePackage p3 = this.getRepoManager().getPackages().getRemotePackages().get(path);
            if (p3 == null) {
                progress.logWarning("Failed to find package '" + path + "'");
                throw new SdkManagerCli.CommandFailedException();
            }
            remotes.add(p3);
        }
        if ((remotes = InstallerUtil.computeRequiredPackages(remotes, this.getRepoManager().getPackages(), progress)) != null) {
            List<RemotePackage> acceptedRemotes = this.checkLicenses(remotes, progress);
            if (!acceptedRemotes.equals(remotes)) {
                this.getOutputStream().println("The following packages can not be installed since their licenses or those of the packages they depend on were not accepted:");
                remotes.stream().filter(p2 -> !acceptedRemotes.contains(p2)).forEach(p2 -> this.getOutputStream().println("  " + p2.getPath()));
                if (!acceptedRemotes.isEmpty()) {
                    this.getOutputStream().print("Continue installing the remaining packages? (y/N): ");
                    if (!SdkManagerCli.askYesNo(this.getInputReader())) {
                        throw new SdkManagerCli.CommandFailedException();
                    }
                }
                remotes = acceptedRemotes;
            }
            double progressMax = 0.1;
            double progressIncrement = 0.9 / (double)remotes.size();
            for (RemotePackage p4 : remotes) {
                progress.setText("Installing " + p4.getDisplayName());
                Installer installer = SdkInstallerUtil.findBestInstallerFactory(p4, this.getSdkHandler()).createInstaller(p4, this.getRepoManager(), this.getDownloader());
                if (!this.applyPackageOperation(installer, progress.createSubProgress(progressMax += progressIncrement))) {
                    throw new SdkManagerCli.CommandFailedException();
                }
                progress.setFraction(progressMax);
            }
        } else {
            progress.logWarning("Unable to compute a complete list of dependencies.");
            throw new SdkManagerCli.CommandFailedException();
        }
        progress.setFraction(1.0);
    }

    private List<RemotePackage> checkLicenses(List<RemotePackage> remotes, ProgressIndicator progress) {
        HashMultimap unacceptedLicenses = HashMultimap.create();
        remotes.forEach(remote -> {
            License l2 = remote.getLicense();
            if (l2 != null && !l2.checkAccepted(this.getSdkHandler().getLocation())) {
                unacceptedLicenses.put(l2, remote);
            }
        });
        for (License l2 : new TreeSet(unacceptedLicenses.keySet())) {
            if (!SdkManagerCli.askForLicense(l2, this.getOutputStream(), this.getInputReader())) continue;
            unacceptedLicenses.removeAll(l2);
            l2.setAccepted(this.getRepoManager().getLocalPath());
        }
        if (!unacceptedLicenses.isEmpty()) {
            ArrayList<RemotePackage> acceptedPackages = new ArrayList<RemotePackage>(remotes);
            HashSet problemPackages = new HashSet(unacceptedLicenses.values());
            this.getOutputStream().println("Skipping following packages as the license is not accepted:");
            problemPackages.forEach(problem -> this.getOutputStream().println(problem.getDisplayName()));
            acceptedPackages.removeAll(problemPackages);
            Iterator acceptedIter = acceptedPackages.iterator();
            while (acceptedIter.hasNext()) {
                RemotePackage accepted = (RemotePackage)acceptedIter.next();
                List<RemotePackage> required = InstallerUtil.computeRequiredPackages(Collections.singletonList(accepted), this.getRepoManager().getPackages(), progress);
                if (Collections.disjoint(required, problemPackages)) continue;
                acceptedIter.remove();
                problemPackages.add(accepted);
            }
            remotes = acceptedPackages;
        }
        return remotes;
    }
}

