/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import java.util.Locale;
import java.util.function.Predicate;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FilteredTreeModel<T>
extends DefaultTreeModel {
    private final Predicate<T> predicate;

    public FilteredTreeModel(TreeNode treeNode, Predicate<T> predicate) {
        super(treeNode);
        this.predicate = predicate;
    }

    @Override
    public Object getChild(Object parent, int index2) {
        int n2 = super.getChildCount(parent);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object result2 = super.getChild(parent, i2);
            if (!this.predicate.test(result2)) continue;
            if (index2 == 0) {
                return result2;
            }
            --index2;
        }
        String msg = String.format(Locale.US, "Child index %1$d is higher than # of children %2$d", index2, this.getChildCount(parent));
        throw new IllegalStateException(msg);
    }

    @Override
    public int getChildCount(Object parent) {
        int count2 = 0;
        int n2 = super.getChildCount(parent);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object result2 = super.getChild(parent, i2);
            if (!this.predicate.test(result2)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index2 = 0;
        int n2 = super.getChildCount(parent);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object result2 = super.getChild(parent, i2);
            if (!this.predicate.test(result2)) continue;
            if (result2.equals(child)) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }
}

