/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex.tree;

import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class DexElementNode
extends DefaultMutableTreeNode {
    private final String name;
    private final ImmutableReference reference;
    private boolean defined;
    private boolean removed;
    private int methodReferencesCount;
    private int methodDefinitionsCount;

    DexElementNode(String name2, boolean allowsChildren) {
        this(name2, allowsChildren, null);
    }

    DexElementNode(String name2, boolean allowsChildren, ImmutableReference reference) {
        super(null, allowsChildren);
        this.name = name2;
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public DexElementNode getChildAt(int i2) {
        return (DexElementNode)super.getChildAt(i2);
    }

    public void sort(Comparator<DexElementNode> comparator) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            DexElementNode node = this.getChildAt(i2);
            node.sort(comparator);
        }
        if (this.children != null) {
            Vector childrenList = this.children;
            childrenList.sort(comparator);
        }
    }

    public <T extends DexElementNode> T getChildByType(String name2, Class<T> type) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            DexElementNode node = this.getChildAt(i2);
            if (!name2.equals(node.getName()) || !type.equals(node.getClass())) continue;
            return (T)node;
        }
        return null;
    }

    public boolean isSeed(ProguardSeedsMap seedsMap, ProguardMap map2, boolean checkChildren) {
        if (seedsMap != null && checkChildren) {
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                DexElementNode node = this.getChildAt(i2);
                if (!node.isSeed(seedsMap, map2, checkChildren)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DexElementNode getParent() {
        return (DexElementNode)super.getParent();
    }

    public void update() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DexElementNode node = this.getChildAt(i2);
            node.update();
        }
    }

    protected static String combine(String parentPackage, String childName) {
        return parentPackage.isEmpty() ? childName : parentPackage + "." + childName;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public void setDefined(boolean defined) {
        this.defined = defined;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public int getMethodReferencesCount() {
        return this.methodReferencesCount;
    }

    protected void setMethodReferencesCount(int methodReferencesCount) {
        this.methodReferencesCount = methodReferencesCount;
    }

    public int getMethodDefinitionsCount() {
        return this.methodDefinitionsCount;
    }

    protected void setMethodDefinitionsCount(int methodDefinitionsCount) {
        this.methodDefinitionsCount = methodDefinitionsCount;
    }

    public abstract long getSize();
}

