/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.internal.ZipArchive;
import com.google.common.primitives.Shorts;
import java.io.IOException;
import java.nio.file.Path;

public class ApkArchive
extends ZipArchive {
    public static final String APK_BASELINE_PROFILE_PATH = String.format("/%s/%s", "assets/dexopt", "baseline.prof");
    public static final String APK_BASELINE_PROFILE_METADATA_PATH = String.format("/%s/%s", "assets/dexopt", "baseline.profm");

    public ApkArchive(Path artifact) throws IOException {
        super(artifact);
    }

    @Override
    public boolean isBinaryXml(Path p2, byte[] content) {
        boolean xmlResource;
        if (!p2.toString().endsWith(".xml")) {
            return false;
        }
        Path name2 = p2.getFileName();
        if (name2 == null) {
            return false;
        }
        Path contents = this.getContentRoot();
        boolean manifest = p2.equals(contents.resolve("AndroidManifest.xml"));
        boolean insideResFolder = p2.startsWith(contents.resolve("res"));
        boolean insideResRaw = p2.startsWith(contents.resolve("res").resolve("raw"));
        boolean bl2 = xmlResource = insideResFolder && !insideResRaw;
        if (!manifest && !xmlResource) {
            return false;
        }
        short code = Shorts.fromBytes(content[1], content[0]);
        return code == 3;
    }

    @Override
    public boolean isBaselineProfile(Path p2, byte[] content) {
        String path = p2.toString();
        return path.equals(APK_BASELINE_PROFILE_PATH) || path.equals(APK_BASELINE_PROFILE_METADATA_PATH);
    }
}

