/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;

public interface ApkEntry {
    public static ApkEntry fromNode(Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ApkEntry)) {
            return null;
        }
        return (ApkEntry)userObject;
    }

    public static void sort(DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> children2 = new ArrayList<DefaultMutableTreeNode>();
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            children2.add((DefaultMutableTreeNode)node.getChildAt(i2));
        }
        Collections.sort(children2, (o1, o2) -> {
            ApkEntry entry1 = ApkEntry.fromNode(o1);
            ApkEntry entry2 = ApkEntry.fromNode(o2);
            if (entry1 == null || entry2 == null) {
                return 0;
            }
            return Long.compare(entry2.getSize(), entry1.getSize());
        });
        node.removeAllChildren();
        for (DefaultMutableTreeNode child : children2) {
            node.add(child);
        }
    }

    public String getName();

    public Path getPath();

    public long getSize();
}

