/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.internal.AbstractArchive;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;

public class AppBundleArchive
extends AbstractArchive {
    public static String BUNDLE_BASELINE_PROFILE_PATH = String.format("/BUNDLE-METADATA/%s/%s", "com.android.tools.build.profiles", "baseline.prof");
    public static String BUNDLE_BASELINE_PROFILE_METADATA_PATH = String.format("/BUNDLE-METADATA/%s/%s", "com.android.tools.build.profiles", "baseline.profm");
    private final FileSystem zipFileSystem;

    private AppBundleArchive(Path path) throws IOException {
        super(path);
        this.zipFileSystem = FileUtils.createZipFilesystem(path);
    }

    public static AppBundleArchive fromBundleFile(Path artifact) throws IOException {
        return new AppBundleArchive(artifact);
    }

    @Override
    public Path getContentRoot() {
        return this.zipFileSystem.getPath("/", new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.zipFileSystem.close();
    }

    @Override
    public boolean isProtoXml(Path p2, byte[] content) {
        boolean xmlResource;
        if (!p2.toString().endsWith(".xml")) {
            return false;
        }
        Path name2 = p2.getFileName();
        if (name2 == null) {
            return false;
        }
        boolean manifest = AppBundleArchive.isManifestFile(p2);
        boolean insideResFolder = AppBundleArchive.isInsideResFolder(p2);
        boolean insideResRaw = AppBundleArchive.isInsiderResRawFolder(p2);
        boolean bl2 = xmlResource = insideResFolder && !insideResRaw;
        if (!manifest && !xmlResource) {
            return false;
        }
        return XmlUtils.isProtoXml(content);
    }

    @Override
    public boolean isBaselineProfile(Path p2, byte[] content) {
        String path = p2.toString();
        return path.equals(BUNDLE_BASELINE_PROFILE_PATH) || path.equals(BUNDLE_BASELINE_PROFILE_METADATA_PATH);
    }

    private static boolean isManifestFile(Path p2) {
        return AppBundleArchive.matchPathPrefix(p2, PathEntry.any(), PathEntry.FD_MANIFEST, PathEntry.FN_ANDROID_MANIFEST_XML);
    }

    private static boolean isInsideResFolder(Path p2) {
        return AppBundleArchive.matchPathPrefix(p2, PathEntry.any(), PathEntry.name("res"));
    }

    private static boolean isInsiderResRawFolder(Path p2) {
        return AppBundleArchive.matchPathPrefix(p2, PathEntry.any(), PathEntry.FD_RES, PathEntry.FD_RES_RAW);
    }

    private static boolean matchPathPrefix(Path path, PathEntry ... prefixEntries) {
        int index2 = 0;
        for (PathEntry entry : prefixEntries) {
            if (!entry.matches(path.getName(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    public static abstract class PathEntry {
        public static final PathEntry FD_RES = PathEntry.name("res");
        public static final PathEntry FD_RES_RAW = PathEntry.name("raw");
        public static final PathEntry FN_ANDROID_MANIFEST_XML = PathEntry.name("AndroidManifest.xml");
        public static final PathEntry FD_MANIFEST = PathEntry.name("manifest");

        public abstract boolean matches(Path var1);

        public static PathEntry any() {
            return AnyPathEntry.instance;
        }

        public static PathEntry name(String name2) {
            return new NamePathEntry(name2);
        }
    }

    public static class NamePathEntry
    extends PathEntry {
        private final String name;

        public NamePathEntry(String name2) {
            this.name = name2;
        }

        @Override
        public boolean matches(Path name2) {
            return name2.toString().equals(this.name);
        }
    }

    public static class AnyPathEntry
    extends PathEntry {
        public static AnyPathEntry instance = new AnyPathEntry();

        @Override
        public boolean matches(Path name2) {
            return true;
        }
    }
}

