/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.AdaptiveIconShape;
import com.android.tools.configurations.ConfigurationListener;
import com.android.tools.configurations.ConfigurationModelModule;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.configurations.DeviceState;
import com.android.tools.configurations.ResourceResolverCache;
import com.android.tools.configurations.Wallpaper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.layoutlib.LayoutlibContext;
import com.android.tools.res.ResourceUtils;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.tools.sdk.LayoutlibFactory;
import com.google.common.base.MoreObjects;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class Configuration {
    public static final String CUSTOM_DEVICE_ID = "Custom";
    public static final int UI_MODE_TYPE_MASK = 15;
    private static final int UI_MODE_TYPE_APPLIANCE = 5;
    private static final int UI_MODE_TYPE_CAR = 3;
    private static final int UI_MODE_TYPE_DESK = 2;
    private static final int UI_MODE_TYPE_NORMAL = 1;
    private static final int UI_MODE_TYPE_TELEVISION = 4;
    private static final int UI_MODE_TYPE_VR_HEADSET = 7;
    private static final int UI_MODE_TYPE_WATCH = 6;
    private static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_YES = 32;
    public static final int UI_MODE_NIGHT_NO = 16;
    private static final ResourceReference postSplashAttrReference = ResourceReference.attr(ResourceNamespace.RES_AUTO, "postSplashScreenTheme");
    protected final FolderConfiguration myFullConfig = new FolderConfiguration();
    protected final ConfigurationSettings mySettings;
    protected final FolderConfiguration myEditedConfig;
    private IAndroidTarget myTarget;
    private String myTheme;
    private Device mySpecificDevice;
    private State myState;
    private Device myDevice;
    private String myStateName;
    private String myActivity;
    private Locale myLocale = null;
    private UiMode myUiMode = UiMode.NORMAL;
    private NightMode myNightMode = NightMode.NOTNIGHT;
    private String myDisplayName;
    private int myBulkEditingCount;
    private List<ConfigurationListener> myListeners;
    protected int myNotifyDirty;
    protected int myFolderConfigDirty = 246;
    protected int myProjectStateVersion;
    private long myModificationCount;
    private float myFontScale = 1.0f;
    private int myUiModeFlagValue;
    private AdaptiveIconShape myAdaptiveShape = AdaptiveIconShape.getDefaultShape();
    private boolean myUseThemedIcon = false;
    private Wallpaper myWallpaper = null;
    private Consumer<BufferedImage> myImageTransformation = null;
    private static final String NO_ACTIVITY = new String();

    protected Configuration(ConfigurationSettings settings, FolderConfiguration editedConfig) {
        this.mySettings = settings;
        this.myEditedConfig = editedConfig;
        if (this.isLocaleSpecificLayout()) {
            this.myLocale = Locale.create(editedConfig);
        }
        if (this.isOrientationSpecificLayout()) {
            ScreenOrientationQualifier qualifier = editedConfig.getScreenOrientationQualifier();
            assert (qualifier != null);
            ScreenOrientation orientation = qualifier.getValue();
            if (orientation != null) {
                this.myStateName = orientation.getShortDisplayValue();
            }
        }
    }

    public static Configuration create(ConfigurationSettings settings, FolderConfiguration editedConfig) {
        return new Configuration(settings, editedConfig);
    }

    protected void copyFrom(Configuration from2) {
        this.myFullConfig.set(from2.myFullConfig);
        this.myFolderConfigDirty = from2.myFolderConfigDirty;
        this.myProjectStateVersion = from2.myProjectStateVersion;
        this.myTarget = from2.myTarget;
        this.myLocale = from2.myLocale;
        this.myTheme = from2.getTheme();
        this.mySpecificDevice = from2.mySpecificDevice;
        this.myDevice = from2.myDevice;
        this.myStateName = from2.myStateName;
        this.myState = from2.myState;
        this.myActivity = from2.getActivity();
        this.myUiMode = from2.getUiMode();
        this.myNightMode = from2.getNightMode();
        this.myDisplayName = from2.getDisplayName();
        this.myFontScale = from2.myFontScale;
        this.myUiModeFlagValue = from2.myUiModeFlagValue;
        this.myAdaptiveShape = from2.myAdaptiveShape;
        this.myUseThemedIcon = from2.myUseThemedIcon;
        this.myWallpaper = from2.myWallpaper;
    }

    public Configuration clone() {
        Configuration copy2 = new Configuration(this.mySettings, FolderConfiguration.copyOf(this.getEditedConfig()));
        copy2.copyFrom(this);
        return copy2;
    }

    protected String getStateName() {
        return this.myStateName;
    }

    public void save() {
    }

    public ConfigurationSettings getSettings() {
        return this.mySettings;
    }

    protected String calculateActivity() {
        return null;
    }

    public final String getActivity() {
        if (this.myActivity == NO_ACTIVITY) {
            return null;
        }
        if (this.myActivity == null) {
            this.myActivity = this.calculateActivity();
            if (this.myActivity == null) {
                this.myActivity = NO_ACTIVITY;
                return null;
            }
        }
        return this.myActivity;
    }

    @Slow
    public Device getDevice() {
        Device cached2 = this.getCachedDevice();
        if (cached2 != null) {
            return cached2;
        }
        this.myDevice = this.mySpecificDevice != null ? this.mySpecificDevice : this.computeBestDevice();
        return this.myDevice;
    }

    public Device getCachedDevice() {
        return this.myDevice;
    }

    public static FolderConfiguration getFolderConfig(ConfigurationModelModule module, State state, Locale locale, IAndroidTarget target) {
        FolderConfiguration currentConfig = DeviceConfigHelper.getFolderConfig(state);
        if (currentConfig != null && locale.hasLanguage()) {
            currentConfig.setLocaleQualifier(locale.qualifier);
            LayoutLibrary layoutLib = Configuration.getLayoutLibrary(target, module.getAndroidPlatform(), module.getLayoutlibContext());
            if (layoutLib != null && layoutLib.isRtl(locale.toLocaleId())) {
                currentConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
            }
        }
        return currentConfig;
    }

    private static LayoutLibrary getLayoutLibrary(IAndroidTarget target, AndroidPlatform platform, LayoutlibContext context2) {
        if (target == null || platform == null) {
            return null;
        }
        try {
            return LayoutlibFactory.getLayoutLibrary(target, platform, context2);
        }
        catch (RenderingException ignored) {
            return null;
        }
    }

    @Slow
    protected Device computeBestDevice() {
        return this.mySettings.getDefaultDevice();
    }

    public State getDeviceState() {
        if (this.myState == null) {
            Device device = this.getDevice();
            this.myState = DeviceState.getDeviceState(device, this.myStateName);
        }
        return this.myState;
    }

    public Locale getLocale() {
        if (this.myLocale == null) {
            return this.mySettings.getLocale();
        }
        return this.myLocale;
    }

    public UiMode getUiMode() {
        return this.myUiMode;
    }

    public NightMode getNightMode() {
        return this.myNightMode;
    }

    public String getTheme() {
        if (this.myTheme == null) {
            return this.getPreferredTheme();
        }
        return this.myTheme;
    }

    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            IAndroidTarget target = this.mySettings.getTarget();
            VersionQualifier version = this.myEditedConfig.getVersionQualifier();
            if (target != null && version != null && version.getVersion() > target.getVersion().getFeatureLevel()) {
                target = this.mySettings.getTarget(version.getVersion());
            }
            return Configuration.getTargetForRendering(target, this.mySettings.getConfigModule());
        }
        return this.myTarget;
    }

    public IAndroidTarget getRealTarget() {
        IAndroidTarget target = this.getTarget();
        if (target instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatTarget = (CompatibilityRenderTarget)target;
            return compatTarget.getRealTarget();
        }
        return target;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isLocaleSpecificLayout() {
        return this.myEditedConfig.getLocaleQualifier() != null;
    }

    public boolean isTargetSpecificLayout() {
        return this.myEditedConfig.getVersionQualifier() != null;
    }

    public boolean isOrientationSpecificLayout() {
        return this.myEditedConfig.getScreenOrientationQualifier() != null;
    }

    public FolderConfiguration getFullConfig() {
        if ((this.myFolderConfigDirty & 0xF6) != 0 || this.myProjectStateVersion != this.mySettings.getStateVersion()) {
            this.syncFolderConfig();
        }
        return this.myFullConfig;
    }

    public FolderConfiguration getEditedConfig() {
        return this.myEditedConfig;
    }

    public void setActivity(String activity) {
        if (!Objects.equals(this.myActivity, activity)) {
            this.myActivity = activity;
            this.updated(256);
        }
    }

    public void setDevice(Device device, boolean preserveState) {
        if (this.mySpecificDevice != device) {
            Device prevDevice = this.mySpecificDevice;
            State prevState = this.myState;
            this.myDevice = this.mySpecificDevice = device;
            int updateFlags = 2;
            if (device != null) {
                State state = null;
                if (preserveState && prevDevice != null) {
                    if (prevState != null) {
                        FolderConfiguration oldConfig = DeviceConfigHelper.getFolderConfig(prevState);
                        if (oldConfig != null) {
                            String stateName = Configuration.getClosestMatch(oldConfig, device.getAllStates());
                            state = device.getState(stateName);
                        } else {
                            state = device.getState(prevState.getName());
                        }
                    }
                } else if (preserveState && this.myStateName != null) {
                    state = device.getState(this.myStateName);
                }
                if (state == null) {
                    state = device.getDefaultState();
                }
                if (this.myState != state) {
                    this.setDeviceStateName(state.getName());
                    this.myState = state;
                    updateFlags |= 4;
                }
            }
            this.updated(updateFlags);
        }
    }

    private static String getClosestMatch(FolderConfiguration oldConfig, List<State> states) {
        ArrayList<State> list1 = new ArrayList<State>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count2 = FolderConfiguration.getQualifierCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            for (State s2 : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i2);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig(s2);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i2) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(s2);
                    continue;
                }
                if (!oldQualifier.equals(newQualifier)) continue;
                list2.add(s2);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.isEmpty()) continue;
            list1.clear();
            list1.addAll(list2);
            list2.clear();
        }
        if (!list1.isEmpty()) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    public void setDeviceState(State state) {
        if (this.myState != state) {
            if (state != null) {
                this.setDeviceStateName(state.getName());
            } else {
                this.myStateName = null;
            }
            this.myState = state;
            this.updated(4);
        }
    }

    public void setDeviceStateName(String stateName) {
        ScreenOrientation orientation;
        ScreenOrientationQualifier qualifier = this.myEditedConfig.getScreenOrientationQualifier();
        if (qualifier != null && (orientation = qualifier.getValue()) != null) {
            stateName = orientation.getShortDisplayValue();
        }
        if (!Objects.equals(stateName, this.myStateName)) {
            this.myStateName = stateName;
            this.myState = null;
            this.updated(4);
        }
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals(this.myLocale, locale)) {
            this.myLocale = locale;
            this.updated(16);
        }
    }

    public void setTarget(IAndroidTarget target) {
        if (this.myTarget != target) {
            this.myTarget = Configuration.getTargetForRendering(target, this.mySettings.getConfigModule());
            this.updated(32);
        }
    }

    public void setDisplayName(String displayName) {
        if (!Objects.equals(this.myDisplayName, displayName)) {
            this.myDisplayName = displayName;
            this.updated(512);
        }
    }

    public void setNightMode(NightMode night) {
        if (this.myNightMode != night) {
            if (night == NightMode.NIGHT) {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x20);
            } else {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x10);
            }
        }
    }

    public void setUiMode(UiMode uiMode) {
        if (this.myUiMode != uiMode) {
            int newUiTypeFlags = 0;
            switch (uiMode) {
                case NORMAL: {
                    newUiTypeFlags = 1;
                    break;
                }
                case DESK: {
                    newUiTypeFlags = 2;
                    break;
                }
                case WATCH: {
                    newUiTypeFlags = 6;
                    break;
                }
                case TELEVISION: {
                    newUiTypeFlags = 4;
                    break;
                }
                case APPLIANCE: {
                    newUiTypeFlags = 5;
                    break;
                }
                case CAR: {
                    newUiTypeFlags = 3;
                    break;
                }
                case VR_HEADSET: {
                    newUiTypeFlags = 7;
                }
            }
            this.setUiModeFlagValue(this.getUiModeFlagValue() & 0x30 | newUiTypeFlags);
        }
    }

    public void setUiModeFlagValue(int uiMode) {
        int modifiedElements = this.myUiModeFlagValue ^ uiMode;
        this.myUiModeFlagValue = uiMode;
        int updatedFlags = 0;
        if ((modifiedElements & 0x30) != 0) {
            this.myNightMode = (uiMode & 0x30) == 32 ? NightMode.NIGHT : NightMode.NOTNIGHT;
            updatedFlags |= 0x40;
        }
        if ((modifiedElements & 0xF) != 0) {
            switch (uiMode & 0xF) {
                case 5: {
                    this.myUiMode = UiMode.APPLIANCE;
                    break;
                }
                case 3: {
                    this.myUiMode = UiMode.CAR;
                    break;
                }
                case 4: {
                    this.myUiMode = UiMode.TELEVISION;
                    break;
                }
                case 6: {
                    this.myUiMode = UiMode.WATCH;
                    break;
                }
                case 2: {
                    this.myUiMode = UiMode.DESK;
                    break;
                }
                case 7: {
                    this.myUiMode = UiMode.VR_HEADSET;
                    break;
                }
                default: {
                    this.myUiMode = UiMode.NORMAL;
                }
            }
            updatedFlags |= 0x80;
        }
        if (updatedFlags != 0) {
            this.updated(updatedFlags);
        }
    }

    public int getUiModeFlagValue() {
        return this.myUiModeFlagValue;
    }

    public void setTheme(String theme) {
        if (!Objects.equals(this.myTheme, theme)) {
            this.myTheme = theme;
            this.checkThemePrefix();
            this.updated(8);
        }
    }

    public void setFontScale(float fontScale) {
        assert (fontScale > 0.0f) : "fontScale must be greater than 0";
        if (this.myFontScale != fontScale) {
            this.myFontScale = fontScale;
            this.updated(1024);
        }
    }

    public float getFontScale() {
        return this.myFontScale;
    }

    public void setAdaptiveShape(AdaptiveIconShape adaptiveShape) {
        if (this.myAdaptiveShape != adaptiveShape) {
            this.myAdaptiveShape = adaptiveShape;
            this.updated(2048);
        }
    }

    public AdaptiveIconShape getAdaptiveShape() {
        return this.myAdaptiveShape;
    }

    public void setWallpaper(Wallpaper wallpaper) {
        if (!Objects.equals((Object)this.myWallpaper, (Object)wallpaper)) {
            this.myWallpaper = wallpaper;
            this.myUseThemedIcon = wallpaper != null;
            this.updated(8);
        }
    }

    public String getWallpaperPath() {
        return this.myWallpaper != null ? this.myWallpaper.getResourcePath() : null;
    }

    public void setImageTransformation(Consumer<BufferedImage> imageTransformation) {
        this.myImageTransformation = imageTransformation;
    }

    public Consumer<BufferedImage> getImageTransformation() {
        return this.myImageTransformation;
    }

    public boolean getUseThemedIcon() {
        return this.myUseThemedIcon;
    }

    protected void syncFolderConfig() {
        Device device = this.getDevice();
        if (device == null) {
            return;
        }
        State deviceState = this.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        FolderConfiguration config = Configuration.getFolderConfig(this.mySettings.getConfigModule(), deviceState, this.getLocale(), this.getTarget());
        this.myFullConfig.set(config);
        Locale locale = this.getLocale();
        this.myFullConfig.setLocaleQualifier(locale.qualifier);
        LayoutDirectionQualifier layoutDirectionQualifier = this.myEditedConfig.getLayoutDirectionQualifier();
        if (layoutDirectionQualifier != null && layoutDirectionQualifier != layoutDirectionQualifier.getNullQualifier()) {
            this.myFullConfig.setLayoutDirectionQualifier(layoutDirectionQualifier);
        } else if (!locale.hasLanguage()) {
            this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
        } else {
            ConfigurationModelModule configModule = this.mySettings.getConfigModule();
            LayoutLibrary layoutLib = Configuration.getLayoutLibrary(this.getTarget(), configModule.getAndroidPlatform(), configModule.getLayoutlibContext());
            if (layoutLib != null) {
                if (layoutLib.isRtl(locale.toLocaleId())) {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
                } else {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
                }
            }
        }
        UiMode uiMode = this.getUiMode();
        this.myFullConfig.setUiModeQualifier(new UiModeQualifier(uiMode));
        NightMode nightMode = this.getNightMode();
        this.myFullConfig.setNightModeQualifier(new NightModeQualifier(nightMode));
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            int apiLevel = target.getVersion().getFeatureLevel();
            this.myFullConfig.setVersionQualifier(new VersionQualifier(apiLevel));
        }
        this.myFolderConfigDirty = 0;
        this.myProjectStateVersion = this.mySettings.getStateVersion();
    }

    public ScreenSize getScreenSize() {
        FolderConfiguration folderConfig;
        State deviceState = this.getDeviceState();
        if (deviceState != null && (folderConfig = DeviceConfigHelper.getFolderConfig(deviceState)) != null) {
            ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
            assert (qualifier != null);
            return qualifier.getValue();
        }
        ScreenSize screenSize = null;
        Device device = this.getDevice();
        if (device != null) {
            List<State> states = device.getAllStates();
            for (State state : states) {
                FolderConfiguration folderConfig2 = DeviceConfigHelper.getFolderConfig(state);
                if (folderConfig2 == null) continue;
                ScreenSizeQualifier qualifier = folderConfig2.getScreenSizeQualifier();
                assert (qualifier != null);
                screenSize = qualifier.getValue();
                break;
            }
        }
        return screenSize;
    }

    private void checkThemePrefix() {
        if (this.myTheme != null && !this.myTheme.startsWith("@")) {
            if (this.myTheme.isEmpty()) {
                this.myTheme = this.getPreferredTheme();
                return;
            }
            this.myTheme = ResourceUtils.getStyleResourceUrl(this.myTheme);
        }
    }

    public Density getDensity() {
        Density d2;
        DensityQualifier qualifier = this.getFullConfig().getDensityQualifier();
        if (qualifier != null && (d2 = qualifier.getValue()) != null && d2.isValidValueForDevice()) {
            return d2;
        }
        return Density.MEDIUM;
    }

    public State getNextDeviceState(State from2) {
        Device device = this.getDevice();
        if (device == null) {
            return null;
        }
        List<State> states = device.getAllStates();
        for (int i2 = 0; i2 < states.size(); ++i2) {
            if (states.get(i2) != from2) continue;
            return states.get((i2 + 1) % states.size());
        }
        if (from2 != null) {
            String name2 = from2.getName();
            for (int i3 = 0; i3 < states.size(); ++i3) {
                if (!states.get(i3).getName().equals(name2)) continue;
                return states.get((i3 + 1) % states.size());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkEditing() {
        Configuration configuration = this;
        synchronized (configuration) {
            ++this.myBulkEditingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkEditing() {
        boolean notify = false;
        Configuration configuration = this;
        synchronized (configuration) {
            --this.myBulkEditingCount;
            if (this.myBulkEditingCount == 0) {
                notify = true;
            }
        }
        if (notify) {
            this.updated(0);
        }
    }

    public void updated(int flags) {
        this.myNotifyDirty |= flags;
        this.myFolderConfigDirty |= flags;
        ++this.myModificationCount;
        if (this.myBulkEditingCount == 0) {
            int changed = this.myNotifyDirty;
            if (this.myListeners != null) {
                for (ConfigurationListener listener : this.myListeners) {
                    listener.changed(changed);
                }
            }
            this.myNotifyDirty = 0;
        }
    }

    public void addListener(ConfigurationListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<ConfigurationListener>();
        }
        this.myListeners.add(listener);
    }

    public void removeListener(ConfigurationListener listener) {
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    @Slow
    public ResourceResolver getResourceResolver() {
        String theme = this.getTheme();
        Device device = this.getDevice();
        ResourceResolverCache resolverCache = this.mySettings.getResolverCache();
        if (device != null && CUSTOM_DEVICE_ID.equals(device.getId())) {
            resolverCache.replaceCustomConfig(theme, this.getFullConfig());
        }
        return resolverCache.getResourceResolver(this.getTarget(), theme, this.getFullConfig());
    }

    public ResourceRepository getFrameworkResources() {
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            return this.mySettings.getResolverCache().getFrameworkResources(this.getFullConfig(), target);
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("display", this.myDisplayName).add("theme", this.myTheme).add("activity", this.myActivity).add("device", this.myDevice).add("state", this.myState).add("locale", this.myLocale).add("target", this.myTarget).add("uimode", this.myUiMode).add("nightmode", this.myNightMode).toString();
    }

    public ConfigurationModelModule getConfigModule() {
        return this.mySettings.getConfigModule();
    }

    public void setEffectiveDevice(Device device, State state) {
        int updateFlags = 0;
        if (this.myDevice != device) {
            updateFlags = 2;
            this.myDevice = device;
        }
        if (this.myState != state) {
            this.myState = state;
            this.myStateName = state != null ? state.getName() : null;
            updateFlags |= 4;
        }
        if (updateFlags != 0) {
            this.updated(updateFlags);
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    private static IAndroidTarget getTargetForRendering(IAndroidTarget target, ConfigurationModelModule module) {
        if (target == null) {
            return null;
        }
        return module.getCompatibilityTarget(target);
    }

    public String getPreferredTheme() {
        return this.mySettings.getConfigModule().getThemeInfoProvider().getDefaultTheme(this);
    }
}

