/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ResourceResolverCache;
import com.android.tools.environment.Logger;
import java.io.Serializable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"postSplashAttrReference", "Lcom/android/ide/common/rendering/api/ResourceReference;", "kotlin.jvm.PlatformType", "findPostSplashTheme", "", "themeStyle", "configuration", "Lcom/android/tools/configurations/Configuration;", "unnamed"})
public final class DefaultThemeProviderKt {
    private static final ResourceReference postSplashAttrReference = ResourceReference.attr(ResourceNamespace.RES_AUTO, "postSplashScreenTheme");

    private static final String findPostSplashTheme(String themeStyle, Configuration configuration) {
        String resolveTheme;
        ResourceReference reference;
        Logger log = Logger.Companion.getInstance(Configuration.class);
        ResourceUrl themeUrl = ResourceUrl.parseStyleParentReference(themeStyle);
        if (themeUrl == null) {
            if (log.isDebugEnabled()) {
                String string2 = "Unable to parse theme %s";
                Object[] objectArray = new Object[]{themeStyle};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                log.debug(string3);
            }
            return themeStyle;
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespacePrefix(themeUrl.namespace, ResourceNamespace.RES_AUTO, ResourceNamespace.Resolver.EMPTY_RESOLVER);
        ResourceNamespace resourceNamespace = namespace;
        if (resourceNamespace == null) {
            resourceNamespace = ResourceNamespace.RES_AUTO;
        }
        if ((reference = themeUrl.resolve(resourceNamespace, ResourceNamespace.Resolver.EMPTY_RESOLVER)) == null) {
            if (log.isDebugEnabled()) {
                String string4 = "Unable to resolve reference for theme %s";
                Object[] objectArray = new Object[]{themeUrl};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
                log.debug(string5);
            }
            return themeStyle;
        }
        ResourceResolverCache resolverCache = configuration.getSettings().getResolverCache();
        ResourceResolver resourceResolver = resolverCache.getResourceResolver(configuration.getTarget(), themeUrl.toString(), configuration.getFullConfig());
        Intrinsics.checkNotNullExpressionValue(resourceResolver, "resolverCache.getResourc\u2026configuration.fullConfig)");
        ResourceResolver resourceResolver2 = resourceResolver;
        StyleResourceValue theme = resourceResolver2.getStyle(reference);
        if (theme == null) {
            if (log.isDebugEnabled()) {
                String string6 = "Unable to resolve theme %s";
                Object[] objectArray = new Object[]{themeUrl};
                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string7, "format(...)");
                log.debug(string7);
            }
            return themeStyle;
        }
        StyleItemResourceValue value = resourceResolver2.findItemInStyle(theme, postSplashAttrReference);
        ResourceValue resolvedValue = resourceResolver2.resolveResValue(value);
        Serializable serializable = resolvedValue;
        String postSplashTheme = serializable != null && (serializable = serializable.getResourceUrl()) != null ? ((ResourceUrl)serializable).toString() : null;
        String string8 = postSplashTheme;
        if (string8 == null) {
            string8 = resolveTheme = themeStyle;
        }
        if (log.isDebugEnabled()) {
            String string9 = "Post splash resolved=%s, original theme=%s";
            Object[] objectArray = new Object[]{postSplashTheme, themeUrl};
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string10, "format(...)");
            log.debug(string10);
        }
        return resolveTheme;
    }

    public static final /* synthetic */ String access$findPostSplashTheme(String themeStyle, Configuration configuration) {
        return DefaultThemeProviderKt.findPostSplashTheme(themeStyle, configuration);
    }
}

