/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.DisjointUnionMap;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ReadAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceResolverCache {
    private final ConfigurationSettings mySettings;
    private final Object myLock = new Object();
    @VisibleForTesting
    public final Map<String, ResourceResolver> myResolverMap = new HashMap<String, ResourceResolver>();
    @VisibleForTesting
    public final Map<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>> myAppResourceMap = new HashMap<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>>();
    @VisibleForTesting
    public final Map<String, Map<ResourceType, ResourceValueMap>> myFrameworkResourceMap = new HashMap<String, Map<ResourceType, ResourceValueMap>>();
    private long myCachedGeneration;
    private final SparseArray<AndroidTargetData> myFrameworkResources = new SparseArray();
    private String myCustomConfigurationKey;
    private String myCustomResolverKey;

    public ResourceResolverCache(ConfigurationSettings settings) {
        this.mySettings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public ResourceResolver getResourceResolver(IAndroidTarget target, String themeStyle, FolderConfiguration fullConfiguration) {
        ResourceRepositoryManager repositoryManager = this.mySettings.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null) {
            return ResourceResolver.create(Collections.emptyMap(), null);
        }
        CacheableResourceRepository resources = repositoryManager.getAppResources();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCachedGeneration != resources.getModificationCount()) {
                this.myResolverMap.clear();
                this.myAppResourceMap.clear();
            }
            this.myCachedGeneration = resources.getModificationCount();
        }
        String qualifierString = fullConfiguration.getQualifierString();
        String resolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString);
        ResourceResolver resolver2 = this.getCachedResolver(resolverKey);
        if (resolver2 == null) {
            if (target == null) {
                target = this.mySettings.getTarget();
            }
            Map frameworkResources = target == null ? Collections.emptyMap() : this.getConfiguredFrameworkResources(target, fullConfiguration);
            Table configuredAppRes = this.getCachedAppResources(qualifierString);
            if (configuredAppRes == null) {
                configuredAppRes = ReadAction.compute(() -> ResourceRepositoryUtil.getConfiguredResources(resources, fullConfiguration));
                this.cacheAppResources(qualifierString, configuredAppRes);
            }
            DisjointUnionMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>> allResources = new DisjointUnionMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>>(Collections.singletonMap(ResourceNamespace.ANDROID, frameworkResources), configuredAppRes.rowMap());
            assert (themeStyle.startsWith("@")) : themeStyle;
            ResourceReference theme = null;
            ResourceUrl themeUrl = ResourceUrl.parse(themeStyle);
            if (themeUrl != null) {
                ResourceNamespace contextNamespace = repositoryManager.getNamespace();
                theme = themeUrl.resolve(contextNamespace, ResourceNamespace.Resolver.EMPTY_RESOLVER);
            }
            resolver2 = ResourceResolver.create(allResources, theme);
            if (target instanceof CompatibilityRenderTarget) {
                int apiLevel = target.getVersion().getFeatureLevel();
                if (apiLevel >= 21) {
                    resolver2.setDeviceDefaults("Material");
                } else if (apiLevel >= 14) {
                    resolver2.setDeviceDefaults("Holo");
                } else {
                    resolver2.setDeviceDefaults("");
                }
            }
            this.cacheResourceResolver(resolverKey, resolver2);
        }
        return resolver2;
    }

    @Slow
    public Map<ResourceType, ResourceValueMap> getConfiguredFrameworkResources(IAndroidTarget target, FolderConfiguration fullConfiguration) {
        ResourceRepository resourceRepository = this.getFrameworkResources(fullConfiguration, target);
        if (resourceRepository == null) {
            return Collections.emptyMap();
        }
        String qualifierString = fullConfiguration.getQualifierString();
        Map<ResourceType, ResourceValueMap> frameworkResources = this.getCachedFrameworkResources(qualifierString);
        if (frameworkResources == null) {
            frameworkResources = ResourceRepositoryUtil.getConfiguredResources(resourceRepository, fullConfiguration).row(ResourceNamespace.ANDROID);
            this.cacheFrameworkResources(qualifierString, frameworkResources);
        }
        return frameworkResources;
    }

    private static String getResolverKey(String themeStyle, String qualifierString) {
        return qualifierString.isEmpty() ? themeStyle : themeStyle + "-" + qualifierString;
    }

    @Slow
    public ResourceRepository getFrameworkResources(FolderConfiguration configuration, IAndroidTarget target) {
        String language;
        LocaleQualifier locale;
        int apiLevel = target.getVersion().getFeatureLevel();
        AndroidTargetData targetData = this.getCachedTargetData(apiLevel);
        if (targetData == null) {
            AndroidPlatform platform = this.mySettings.getConfigModule().getAndroidPlatform();
            if (platform == null) {
                return null;
            }
            targetData = AndroidTargetData.get(platform.getSdkData(), target);
            this.cacheTargetData(apiLevel, targetData);
        }
        if ((locale = configuration.getLocaleQualifier()) == null) {
            locale = this.mySettings.getLocale().qualifier;
        }
        ImmutableSet<String> languages = (language = locale.getLanguage()) == null ? ImmutableSet.of() : ImmutableSet.of(language);
        return targetData.getFrameworkResources(languages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCachedGeneration = 0L;
            this.myAppResourceMap.clear();
            this.myResolverMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCustomConfig(String themeStyle, FolderConfiguration fullConfiguration) {
        String qualifierString = fullConfiguration.getQualifierString();
        String newCustomResolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString);
        Object object = this.myLock;
        synchronized (object) {
            if (newCustomResolverKey.equals(this.myCustomResolverKey)) {
                return;
            }
            if (this.myCustomConfigurationKey != null) {
                this.myFrameworkResourceMap.remove(this.myCustomConfigurationKey);
                this.myAppResourceMap.remove(this.myCustomConfigurationKey);
            }
            if (this.myCustomResolverKey != null) {
                this.myResolverMap.remove(this.myCustomResolverKey);
            }
            this.myCustomConfigurationKey = qualifierString;
            this.myCustomResolverKey = newCustomResolverKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheTargetData(int apiLevel, AndroidTargetData targetData) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFrameworkResources.put(apiLevel, targetData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AndroidTargetData getCachedTargetData(int apiLevel) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFrameworkResources.get(apiLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFrameworkResources(String qualifierString, Map<ResourceType, ResourceValueMap> frameworkResources) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFrameworkResourceMap.put(qualifierString, frameworkResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ResourceType, ResourceValueMap> getCachedFrameworkResources(String qualifierString) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFrameworkResourceMap.get(qualifierString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAppResources(String qualifierString, Table<ResourceNamespace, ResourceType, ResourceValueMap> configuredAppResources) {
        Object object = this.myLock;
        synchronized (object) {
            this.myAppResourceMap.put(qualifierString, configuredAppResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table<ResourceNamespace, ResourceType, ResourceValueMap> getCachedAppResources(String qualifierString) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myAppResourceMap.get(qualifierString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResourceResolver(String resolverKey, ResourceResolver resolver2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myResolverMap.put(resolverKey, resolver2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResolver getCachedResolver(String resolverKey) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myResolverMap.get(resolverKey);
        }
    }
}

