/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.dom.attrs;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.StyleableDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class FilteredAttributeDefinitions
implements AttributeDefinitions {
    private final AttributeDefinitions myWrappee;

    protected FilteredAttributeDefinitions(AttributeDefinitions wrappee) {
        this.myWrappee = wrappee;
    }

    protected abstract boolean isAttributeAcceptable(ResourceReference var1);

    @Override
    public StyleableDefinition getStyleableDefinition(ResourceReference styleable) {
        StyleableDefinition styleableDef = this.myWrappee.getStyleableDefinition(styleable);
        return styleableDef != null ? new MyStyleableDefinition(styleableDef) : null;
    }

    @Override
    @Deprecated
    public StyleableDefinition getStyleableByName(String name2) {
        StyleableDefinition styleable = this.myWrappee.getStyleableByName(name2);
        return styleable != null ? new MyStyleableDefinition(styleable) : null;
    }

    @Override
    public Set<ResourceReference> getAttrs() {
        HashSet<ResourceReference> result2 = new HashSet<ResourceReference>();
        for (ResourceReference attrRef : this.myWrappee.getAttrs()) {
            if (!this.isAttributeAcceptable(attrRef)) continue;
            result2.add(attrRef);
        }
        return result2;
    }

    @Override
    public AttributeDefinition getAttrDefinition(ResourceReference attr) {
        AttributeDefinition attribute = this.myWrappee.getAttrDefinition(attr);
        return attribute != null && this.isAttributeAcceptable(attr) ? attribute : null;
    }

    @Override
    @Deprecated
    public AttributeDefinition getAttrDefByName(String name2) {
        AttributeDefinition attribute = this.myWrappee.getAttrDefByName(name2);
        return attribute != null && this.isAttributeAcceptable(attribute.getResourceReference()) ? attribute : null;
    }

    @Override
    public String getAttrGroup(ResourceReference attr) {
        return this.myWrappee.getAttrGroup(attr);
    }

    private class MyStyleableDefinition
    implements StyleableDefinition {
        private final StyleableDefinition myWrappee;

        private MyStyleableDefinition(StyleableDefinition wrappee) {
            this.myWrappee = wrappee;
        }

        @Override
        public ResourceReference getResourceReference() {
            return this.myWrappee.getResourceReference();
        }

        @Override
        public String getName() {
            return this.myWrappee.getName();
        }

        @Override
        public List<AttributeDefinition> getAttributes() {
            ArrayList<AttributeDefinition> result2 = new ArrayList<AttributeDefinition>();
            for (AttributeDefinition definition : this.myWrappee.getAttributes()) {
                if (!FilteredAttributeDefinitions.this.isAttributeAcceptable(definition.getResourceReference())) continue;
                result2.add(definition);
            }
            return result2;
        }
    }
}

