/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.tools.fonts.Fonts;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SystemFonts {
    private static final int CONDENSED_WIDTH = 75;
    private final Map<String, FontFamily> myFonts;

    public SystemFonts(FontLoader fontLoader) {
        this.myFonts = SystemFonts.createFonts(fontLoader);
    }

    public Collection<FontFamily> getFontFamilies() {
        return this.myFonts.values();
    }

    public FontFamily getFont(String name2) {
        return this.myFonts.get(name2);
    }

    private static Map<String, FontFamily> createFonts(FontLoader fontLoader) {
        TreeMap<String, FontFamily> fonts = new TreeMap<String, FontFamily>();
        for (String fontName : Fonts.AVAILABLE_FAMILIES) {
            FontFamily family = SystemFonts.createFont(fontLoader, fontName);
            if (family == null) continue;
            fonts.put(fontName, family);
        }
        return fonts;
    }

    private static FontFamily createFont(FontLoader fontLoader, String systemFontName) {
        switch (systemFontName) {
            case "sans-serif-thin": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 100, 100, 400);
            }
            case "sans-serif-light": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 100, 300, 700);
            }
            case "sans-serif": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 100, 400, 700);
            }
            case "sans-serif-medium": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 100, 500, 900);
            }
            case "sans-serif-black": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 100, 900);
            }
            case "sans-serif-condensed-light": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 75, 300, 700);
            }
            case "sans-serif-condensed": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 75, 400, 700);
            }
            case "sans-serif-condensed-medium": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Roboto", 75, 400, 700);
            }
            case "serif": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Noto Serif", 100, 400, 700);
            }
            case "monospace": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Droid Sans Mono", 100, 400);
            }
            case "serif-monospace": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Cutive Mono", 100, 400);
            }
            case "casual": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Coming Soon", 100, 400);
            }
            case "cursive": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Dancing Script", 100, 400, 700);
            }
            case "sans-serif-smallcaps": {
                return SystemFonts.findFont(fontLoader, systemFontName, "Carrois Gothic SC", 100, 400);
            }
        }
        return null;
    }

    private static FontFamily findFont(FontLoader fontLoader, String systemFontName, String name2, int width, int ... weights) {
        FontFamily family = fontLoader.findFont(FontProvider.GOOGLE_PROVIDER, name2);
        if (family == null) {
            return null;
        }
        List<MutableFontDetail> filtered = family.getFonts().stream().filter(font -> font.getWidth() == width && Ints.contains(weights, font.getWeight())).map(FontDetail::toMutableFontDetail).collect(Collectors.toList());
        MutableFontDetail wanted = new MutableFontDetail(400, width, false);
        FontDetail best = wanted.findBestMatch(family.getFonts());
        if (best == null) {
            return null;
        }
        return new FontFamily(FontProvider.GOOGLE_PROVIDER, FontSource.SYSTEM, systemFontName, best.getFontUrl(), "", filtered);
    }
}

