/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.google.common.base.MoreObjects;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class BufferingFileWrapper
implements IAbstractFile {
    private final File myFile;

    public BufferingFileWrapper(File file2) {
        this.myFile = file2;
    }

    @Override
    public InputStream getContents() throws StreamException {
        try {
            byte[] content = this.readFile();
            return new ByteArrayInputStream(content);
        }
        catch (IOException e2) {
            throw new StreamException(e2, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile() throws IOException {
        try (DataInputStream is = new DataInputStream(new FileInputStream(this.myFile));){
            byte[] data = new byte[(int)this.myFile.length()];
            is.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    public File getFile() {
        return this.myFile;
    }

    @Override
    public void setContents(InputStream source) throws StreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getOutputStream() throws StreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOsLocation() {
        return this.myFile.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        return this.myFile.isFile();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("file", this.myFile).toString();
    }
}

