/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.tools.preview.config.AndroidDimension;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.MutableDeviceConfig;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.Shape;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0002\u001a$\u0010\n\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u000f\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0011\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"referenceDeviceIds", "", "", "getReferenceDeviceIds", "()Ljava/util/Map;", "referenceDeviceRealDensities", "", "parseAndroidNumberOrNull", "Lcom/android/tools/preview/config/AndroidDimension;", "text", "appendParamValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parameterName", "value", "appendSeparator", "toImmutableConfig", "Lcom/android/tools/preview/config/DeviceConfig;", "Lcom/android/tools/preview/config/MutableDeviceConfig;", "toMutableConfig", "unnamed"})
@SourceDebugExtension(value={"SMAP\nDeviceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfigKt\n+ 2 EnumUtils.kt\ncom/android/ide/common/util/EnumUtilsKt\n*L\n1#1,532:1\n27#2,5:533\n*S KotlinDebug\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfigKt\n*L\n504#1:533,5\n*E\n"})
public final class DeviceConfigKt {
    @NotNull
    private static final Map<String, String> referenceDeviceIds;
    @NotNull
    private static final Map<String, Integer> referenceDeviceRealDensities;

    @NotNull
    public static final Map<String, String> getReferenceDeviceIds() {
        return referenceDeviceIds;
    }

    @NotNull
    public static final DeviceConfig toImmutableConfig(@NotNull MutableDeviceConfig $this$toImmutableConfig) {
        Intrinsics.checkNotNullParameter($this$toImmutableConfig, "<this>");
        Shape shape = $this$toImmutableConfig.getShape();
        float f2 = $this$toImmutableConfig.getWidth();
        float f3 = $this$toImmutableConfig.getHeight();
        DimUnit dimUnit = $this$toImmutableConfig.getDimUnit();
        int n2 = $this$toImmutableConfig.getDpi();
        Orientation orientation = $this$toImmutableConfig.getOrientation();
        String string2 = $this$toImmutableConfig.getParentDeviceId();
        return new DeviceConfig(null, f2, f3, dimUnit, n2, shape, 0.0f, orientation, string2, 65, null);
    }

    @NotNull
    public static final MutableDeviceConfig toMutableConfig(@NotNull DeviceConfig $this$toMutableConfig) {
        Intrinsics.checkNotNullParameter($this$toMutableConfig, "<this>");
        Shape shape = $this$toMutableConfig.getShape();
        float f2 = $this$toMutableConfig.getWidth();
        float f3 = $this$toMutableConfig.getHeight();
        DimUnit dimUnit = $this$toMutableConfig.getDimUnit();
        int n2 = $this$toMutableConfig.getDpi();
        float f4 = $this$toMutableConfig.getChinSize();
        Orientation orientation = $this$toMutableConfig.getOrientation();
        String string2 = $this$toMutableConfig.getParentDeviceId();
        return new MutableDeviceConfig(null, f2, f3, dimUnit, n2, shape, f4, orientation, string2, 1, null);
    }

    private static final AndroidDimension parseAndroidNumberOrNull(String text) {
        Enum enum_;
        if (text == null) {
            return null;
        }
        String unit = StringsKt.takeLast(text, 2);
        boolean $i$f$enumValueOfOrNull = false;
        try {
            enum_ = DimUnit.valueOf(unit);
        }
        catch (Exception _$iv) {
            enum_ = null;
        }
        DimUnit dimUnit = (DimUnit)enum_;
        if (dimUnit == null) {
            return null;
        }
        DimUnit dimUnit2 = dimUnit;
        Float f2 = StringsKt.toFloatOrNull(StringsKt.dropLast(text, 2));
        if (f2 == null) {
            return null;
        }
        float value = f2.floatValue();
        return new AndroidDimension(value, dimUnit2);
    }

    private static final StringBuilder appendParamValue(StringBuilder $this$appendParamValue, String parameterName, String value) {
        StringBuilder stringBuilder = $this$appendParamValue.append(parameterName + "=" + value);
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(\"$parameterName$OPERATOR$value\")");
        return stringBuilder;
    }

    private static final StringBuilder appendSeparator(StringBuilder $this$appendSeparator) {
        StringBuilder stringBuilder = $this$appendSeparator.append(',');
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(SEPARATOR)");
        return stringBuilder;
    }

    public static final /* synthetic */ StringBuilder access$appendParamValue(StringBuilder $receiver, String parameterName, String value) {
        return DeviceConfigKt.appendParamValue($receiver, parameterName, value);
    }

    public static final /* synthetic */ StringBuilder access$appendSeparator(StringBuilder $receiver) {
        return DeviceConfigKt.appendSeparator($receiver);
    }

    public static final /* synthetic */ Map access$getReferenceDeviceRealDensities$p() {
        return referenceDeviceRealDensities;
    }

    public static final /* synthetic */ AndroidDimension access$parseAndroidNumberOrNull(String text) {
        return DeviceConfigKt.parseAndroidNumberOrNull(text);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("spec:id=reference_phone,shape=Normal,width=411,height=891,unit=dp,dpi=420", "_device_class_phone"), TuplesKt.to("spec:id=reference_foldable,shape=Normal,width=673,height=841,unit=dp,dpi=420", "_device_class_foldable"), TuplesKt.to("spec:id=reference_tablet,shape=Normal,width=1280,height=800,unit=dp,dpi=240", "_device_class_tablet"), TuplesKt.to("spec:id=reference_desktop,shape=Normal,width=1920,height=1080,unit=dp,dpi=160", "_device_class_desktop")};
        referenceDeviceIds = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to("_device_class_phone", 420), TuplesKt.to("_device_class_foldable", 420), TuplesKt.to("_device_class_tablet", 240), TuplesKt.to("_device_class_desktop", 160)};
        referenceDeviceRealDensities = MapsKt.mapOf(pairArray);
    }
}

