/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.environment.Logger;
import com.android.tools.preview.config.Densities;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DeviceConfigKt;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.MutableDeviceConfig;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.Shape;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a$\u0010\u0010\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\t*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\n*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"CHIN_SIZE_PX_FOR_ROUND_CHIN", "", "DEFAULT_DEVICE_ID", "", "DEFAULT_DEVICE_ID_WITH_PREFIX", "DEVICE_BY_ID_PREFIX", "DEVICE_BY_NAME_PREFIX", "DEVICE_BY_SPEC_PREFIX", "createDeviceInstance", "Lcom/android/sdklib/devices/Device;", "Lcom/android/tools/preview/config/DeviceConfig;", "findByIdOrName", "", "deviceDefinition", "logger", "Lcom/android/tools/environment/Logger;", "findOrParseFromDefinition", "getDefaultPreviewDevice", "Lcom/android/tools/configurations/ConfigurationSettings;", "toDeviceConfig", "unnamed"})
@SourceDebugExtension(value={"SMAP\nDeviceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/preview/config/DeviceUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1#2:204\n288#3,2:205\n288#3,2:207\n*S KotlinDebug\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/preview/config/DeviceUtilsKt\n*L\n183#1:205,2\n191#1:207,2\n*E\n"})
public final class DeviceUtilsKt {
    @NotNull
    public static final String DEVICE_BY_ID_PREFIX = "id:";
    @NotNull
    public static final String DEVICE_BY_NAME_PREFIX = "name:";
    @NotNull
    public static final String DEVICE_BY_SPEC_PREFIX = "spec:";
    @NotNull
    public static final String DEFAULT_DEVICE_ID = "pixel_5";
    @NotNull
    public static final String DEFAULT_DEVICE_ID_WITH_PREFIX = "id:pixel_5";
    public static final int CHIN_SIZE_PX_FOR_ROUND_CHIN = 30;

    @NotNull
    public static final DeviceConfig toDeviceConfig(@NotNull Device $this$toDeviceConfig) {
        MutableDeviceConfig mutableDeviceConfig;
        Intrinsics.checkNotNullParameter($this$toDeviceConfig, "<this>");
        MutableDeviceConfig $this$toDeviceConfig_u24lambda_u240 = mutableDeviceConfig = new MutableDeviceConfig(null, 0.0f, 0.0f, null, 0, null, 0.0f, null, null, 511, null);
        boolean bl2 = false;
        $this$toDeviceConfig_u24lambda_u240.setDimUnit(DimUnit.px);
        MutableDeviceConfig config = mutableDeviceConfig;
        State deviceState = $this$toDeviceConfig.getDefaultState();
        Screen screen = deviceState.getHardware().getScreen();
        config.setWidth(screen.getXDimension());
        config.setHeight(screen.getYDimension());
        config.setDpi(screen.getPixelDensity().getDpiValue());
        ScreenOrientation screenOrientation = deviceState.getOrientation();
        config.setOrientation((screenOrientation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[screenOrientation.ordinal()]) == 1 ? Orientation.landscape : Orientation.portrait);
        if (screen.getScreenRound() == ScreenRound.ROUND) {
            config.setShape(Shape.Round);
            config.setChinSize(screen.getChin());
        } else {
            config.setShape(Shape.Normal);
        }
        if (!Intrinsics.areEqual($this$toDeviceConfig.getId(), "Custom")) {
            config.setParentDeviceId($this$toDeviceConfig.getId());
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Device createDeviceInstance(@NotNull DeviceConfig $this$createDeviceInstance) {
        void $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243;
        void $this$createDeviceInstance_u24lambda_u245_u24lambda_u244;
        Screen screen;
        ScreenOrientation screenOrientation;
        Object $this$createDeviceInstance_u24lambda_u242_u24lambda_u241;
        Intrinsics.checkNotNullParameter($this$createDeviceInstance, "<this>");
        MutableDeviceConfig deviceConfig = !($this$createDeviceInstance instanceof MutableDeviceConfig) ? DeviceConfigKt.toMutableConfig($this$createDeviceInstance) : (MutableDeviceConfig)$this$createDeviceInstance;
        Object object = new Device.Builder();
        Device.Builder $this$createDeviceInstance_u24lambda_u242 = object;
        boolean bl2 = false;
        $this$createDeviceInstance_u24lambda_u242.setTagId("");
        $this$createDeviceInstance_u24lambda_u242.setName("Custom");
        $this$createDeviceInstance_u24lambda_u242.setId("Custom");
        $this$createDeviceInstance_u24lambda_u242.setManufacturer("");
        $this$createDeviceInstance_u24lambda_u242.addSoftware(new Software());
        Object object2 = new State();
        State state = object2;
        Object object3 = $this$createDeviceInstance_u24lambda_u242;
        boolean bl3 = false;
        ((State)$this$createDeviceInstance_u24lambda_u242_u24lambda_u241).setDefaultState(true);
        ((State)$this$createDeviceInstance_u24lambda_u242_u24lambda_u241).setHardware(new Hardware());
        ((Device.Builder)object3).addState((State)object2);
        Device customDevice = ((Device.Builder)object).build();
        Object $this$createDeviceInstance_u24lambda_u245 = object = customDevice.getDefaultState();
        boolean bl4 = false;
        switch (WhenMappings.$EnumSwitchMapping$1[deviceConfig.getOrientation().ordinal()]) {
            case 1: {
                screenOrientation = ScreenOrientation.LANDSCAPE;
                break;
            }
            case 2: {
                screenOrientation = ScreenOrientation.PORTRAIT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ((State)$this$createDeviceInstance_u24lambda_u245).setOrientation(screenOrientation);
        $this$createDeviceInstance_u24lambda_u242_u24lambda_u241 = object2 = new Hardware();
        object3 = $this$createDeviceInstance_u24lambda_u245;
        boolean bl5 = false;
        Screen screen2 = screen = new Screen();
        void var12_12 = $this$createDeviceInstance_u24lambda_u245_u24lambda_u244;
        boolean bl6 = false;
        Density density = Densities.getCommonScreenDensity(false, deviceConfig.getDpi(), 0);
        Intrinsics.checkNotNullExpressionValue(density, "getCommonScreenDensity(f\u2026Config.dpi.toDouble(), 0)");
        Density resolvedDensity = density;
        deviceConfig.setDpi(resolvedDensity.getDpiValue());
        deviceConfig.setDimUnit(DimUnit.px);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setXDimension(MathKt.roundToInt(deviceConfig.getWidth()));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setYDimension(MathKt.roundToInt(deviceConfig.getHeight()));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setPixelDensity(resolvedDensity);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setDiagonalLength(Math.sqrt(1.0 * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXDimension() * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXDimension() + 1.0 * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getYDimension() * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getYDimension()) / (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getPixelDensity().getDpiValue());
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setScreenRound(deviceConfig.isRound() ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setChin(deviceConfig.getShape() == Shape.Chin ? 30 : (deviceConfig.isRound() ? MathKt.roundToInt(deviceConfig.getChinSize()) : 0));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setSize(ScreenSize.getScreenSize($this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getDiagonalLength()));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setRatio(ScreenRatio.create($this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXDimension(), $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getYDimension()));
        var12_12.setScreen(screen);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244.setButtonType(ButtonType.SOFT);
        ((State)object3).setHardware((Hardware)object2);
        Intrinsics.checkNotNullExpressionValue(customDevice, "customDevice");
        return customDevice;
    }

    @Nullable
    public static final Device getDefaultPreviewDevice(@NotNull ConfigurationSettings $this$getDefaultPreviewDevice) {
        Device device;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$getDefaultPreviewDevice, "<this>");
            Iterable iterable = $this$getDefaultPreviewDevice.getDevices();
            for (Object t2 : iterable) {
                Device device2 = (Device)t2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(device2.getId(), DEFAULT_DEVICE_ID)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        if ((device = (Device)v0) == null) {
            device = $this$getDefaultPreviewDevice.getDefaultDevice();
        }
        return device;
    }

    @Nullable
    public static final Device findOrParseFromDefinition(@NotNull Collection<Device> $this$findOrParseFromDefinition, @NotNull String deviceDefinition, @NotNull Logger logger) {
        Device device;
        Intrinsics.checkNotNullParameter($this$findOrParseFromDefinition, "<this>");
        Intrinsics.checkNotNullParameter(deviceDefinition, "deviceDefinition");
        Intrinsics.checkNotNullParameter(logger, "logger");
        if (StringsKt.isBlank(deviceDefinition)) {
            device = null;
        } else {
            if (StringsKt.startsWith$default(deviceDefinition, DEVICE_BY_SPEC_PREFIX, false, 2, null)) {
                Device deviceBySpec;
                MutableDeviceConfig mutableDeviceConfig = DeviceConfig.Companion.toMutableDeviceConfigOrNull(deviceDefinition, $this$findOrParseFromDefinition);
                Device device2 = deviceBySpec = mutableDeviceConfig != null ? DeviceUtilsKt.createDeviceInstance(mutableDeviceConfig) : null;
                if (deviceBySpec == null) {
                    logger.warn("Unable to parse device configuration: " + deviceDefinition);
                }
                return deviceBySpec;
            }
            device = DeviceUtilsKt.findByIdOrName($this$findOrParseFromDefinition, deviceDefinition, logger);
        }
        return device;
    }

    public static /* synthetic */ Device findOrParseFromDefinition$default(Collection collection, String string2, Logger logger, int n2, Object object) {
        if ((n2 & 2) != 0) {
            logger = Logger.Companion.getInstance(MutableDeviceConfig.class);
        }
        return DeviceUtilsKt.findOrParseFromDefinition(collection, string2, logger);
    }

    @Nullable
    public static final Device findByIdOrName(@NotNull Collection<Device> $this$findByIdOrName, @NotNull String deviceDefinition, @NotNull Logger logger) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$findByIdOrName, "<this>");
        Intrinsics.checkNotNullParameter(deviceDefinition, "deviceDefinition");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Collection<Device> availableDevices = $this$findByIdOrName;
        if (StringsKt.isBlank(deviceDefinition)) {
            v0 = null;
        } else {
            if (StringsKt.startsWith$default(deviceDefinition, DEVICE_BY_ID_PREFIX, false, 2, null)) {
                Object v1;
                String id2;
                block8: {
                    id2 = StringsKt.removePrefix(deviceDefinition, (CharSequence)DEVICE_BY_ID_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getId(), id2)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                Device deviceById = v1;
                if (deviceById == null) {
                    logger.warn("Unable to find device with id '" + id2 + "'");
                }
                return deviceById;
            }
            if (StringsKt.startsWith$default(deviceDefinition, DEVICE_BY_NAME_PREFIX, false, 2, null)) {
                Object v2;
                String name2;
                block9: {
                    name2 = StringsKt.removePrefix(deviceDefinition, (CharSequence)DEVICE_BY_NAME_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getDisplayName(), name2)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                Device deviceByName = v2;
                if (deviceByName == null) {
                    logger.warn("Unable to find device with name '" + name2 + "'");
                }
                return deviceByName;
            }
            logger.warn("Unsupported device definition: " + deviceDefinition);
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ Device findByIdOrName$default(Collection collection, String string2, Logger logger, int n2, Object object) {
        if ((n2 & 2) != 0) {
            logger = Logger.Companion.getInstance(MutableDeviceConfig.class);
        }
        return DeviceUtilsKt.findByIdOrName(collection, string2, logger);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScreenOrientation.values().length];
            try {
                nArray[ScreenOrientation.LANDSCAPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.landscape.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.portrait.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

