/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DeviceConfigKt;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.ReferenceConfigsKt;
import com.android.tools.preview.config.WindowSizeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"DeviceWindowsNames", "", "", "getDeviceWindowsNames", "()Ljava/util/Map;", "PREDEFINED_WINDOW_SIZES_DEFINITIONS", "", "Lcom/android/tools/preview/config/WindowSizeData;", "getPREDEFINED_WINDOW_SIZES_DEFINITIONS", "()Ljava/util/List;", "toPx", "", "", "density", "Lcom/android/resources/Density;", "unnamed"})
@SourceDebugExtension(value={"SMAP\nWindowSizeData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowSizeData.kt\ncom/android/tools/preview/config/WindowSizeDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1549#2:63\n1620#2,3:64\n*S KotlinDebug\n*F\n+ 1 WindowSizeData.kt\ncom/android/tools/preview/config/WindowSizeDataKt\n*L\n48#1:63\n48#1:64,3\n*E\n"})
public final class WindowSizeDataKt {
    @NotNull
    private static final Map<String, String> DeviceWindowsNames;
    @NotNull
    private static final List<WindowSizeData> PREDEFINED_WINDOW_SIZES_DEFINITIONS;

    public static final int toPx(double $this$toPx, @NotNull Density density) {
        Intrinsics.checkNotNullParameter(density, "density");
        return MathKt.roundToInt($this$toPx * ((double)density.getDpiValue() / 160.0));
    }

    @NotNull
    public static final Map<String, String> getDeviceWindowsNames() {
        return DeviceWindowsNames;
    }

    @NotNull
    public static final List<WindowSizeData> getPREDEFINED_WINDOW_SIZES_DEFINITIONS() {
        return PREDEFINED_WINDOW_SIZES_DEFINITIONS;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("_device_class_phone", "Medium Phone"), TuplesKt.to("_device_class_foldable", "Foldable"), TuplesKt.to("_device_class_tablet", "Medium Tablet"), TuplesKt.to("_device_class_desktop", "Desktop")};
        DeviceWindowsNames = MapsKt.mapOf(pairArray);
        Iterable $this$map$iv = DeviceConfigKt.getReferenceDeviceIds().entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScreenOrientation screenOrientation;
            String string2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String deviceClassName = (String)entry.getValue();
            DeviceConfig config = ReferenceConfigsKt.getDeviceConfigFor(deviceClassName);
            String string3 = config.getDeviceId();
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = DeviceWindowsNames.get(deviceClassName)) == null) {
                string2 = "Custom";
            }
            double d2 = config.getWidth();
            double d3 = config.getHeight();
            Density density = Density.create(config.getDpi());
            Intrinsics.checkNotNullExpressionValue(density, "create(config.dpi)");
            switch (WhenMappings.$EnumSwitchMapping$0[config.getOrientation().ordinal()]) {
                case 1: {
                    screenOrientation = ScreenOrientation.PORTRAIT;
                    break;
                }
                case 2: {
                    screenOrientation = ScreenOrientation.LANDSCAPE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(new WindowSizeData(string3, string2, d2, d3, density, screenOrientation));
        }
        PREDEFINED_WINDOW_SIZES_DEFINITIONS = (List)var3_3;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.portrait.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.landscape.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

