/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.multipreview.visitors;

import com.android.tools.preview.multipreview.AnnotationReferencesRecorder;
import com.android.tools.preview.multipreview.ClassNameEncodingKt;
import com.android.tools.preview.multipreview.Graph;
import com.android.tools.preview.multipreview.MethodRepresentation;
import com.android.tools.preview.multipreview.MultipreviewSettings;
import com.android.tools.preview.multipreview.ParameterRepresentation;
import com.android.tools.preview.multipreview.visitors.AnnotationRecordersKt;
import com.android.tools.preview.multipreview.visitors.PreviewParameterAnnotationVisitor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/preview/multipreview/visitors/AnnotatedMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "settings", "Lcom/android/tools/preview/multipreview/MultipreviewSettings;", "graph", "Lcom/android/tools/preview/multipreview/Graph;", "methodFqn", "", "(Lcom/android/tools/preview/multipreview/MultipreviewSettings;Lcom/android/tools/preview/multipreview/Graph;Ljava/lang/String;)V", "annotationRecorder", "Lcom/android/tools/preview/multipreview/AnnotationReferencesRecorder;", "parameters", "", "Lcom/android/tools/preview/multipreview/ParameterRepresentation;", "visitAnnotation", "Lorg/objectweb/asm/AnnotationVisitor;", "descriptor", "visible", "", "visitEnd", "", "visitParameterAnnotation", "parameter", "", "unnamed"})
public final class AnnotatedMethodVisitor
extends MethodVisitor {
    @NotNull
    private final MultipreviewSettings settings;
    @NotNull
    private final Graph graph;
    @NotNull
    private final String methodFqn;
    @NotNull
    private final List<ParameterRepresentation> parameters;
    @NotNull
    private final AnnotationReferencesRecorder annotationRecorder;

    public AnnotatedMethodVisitor(@NotNull MultipreviewSettings settings, @NotNull Graph graph2, @NotNull String methodFqn) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(methodFqn, "methodFqn");
        super(589824);
        this.settings = settings;
        this.graph = graph2;
        this.methodFqn = methodFqn;
        this.parameters = new ArrayList();
        this.annotationRecorder = new AnnotationReferencesRecorder();
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(@Nullable String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = AnnotationRecordersKt.createAnnotationVisitor(this.annotationRecorder, descriptor2, this.settings.getBaseAnnotation());
        if (annotationVisitor == null) {
            annotationVisitor = super.visitAnnotation(descriptor2, visible);
        }
        return annotationVisitor;
    }

    @Override
    @Nullable
    public AnnotationVisitor visitParameterAnnotation(int parameter, @Nullable String descriptor2, boolean visible) {
        return Intrinsics.areEqual(ClassNameEncodingKt.descriptorToFqcn(descriptor2), this.settings.getParameterAnnotation()) && this.parameters.size() == parameter ? (AnnotationVisitor)new PreviewParameterAnnotationVisitor(this.parameters) : super.visitParameterAnnotation(parameter, descriptor2, visible);
    }

    @Override
    public void visitEnd() {
        if (this.annotationRecorder.getBaseAnnotations().isEmpty() && this.annotationRecorder.getDerivedAnnotations().isEmpty()) {
            return;
        }
        this.graph.addMethodNode(new MethodRepresentation(this.methodFqn, this.parameters), this.annotationRecorder);
    }
}

