/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.render.framework;

import com.android.tools.render.framework.IJFramework;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSetBuilder;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J-\u0010\u0012\u001a\u00020\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/render/framework/StandaloneFramework;", "Lcom/android/tools/render/framework/IJFramework;", "stopExecutor", "", "(Z)V", "app", "Lcom/intellij/mock/MockApplication;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "close", "", "registerService", "T", "", "serviceInterface", "Ljava/lang/Class;", "serviceImplementation", "(Ljava/lang/Class;Ljava/lang/Object;)V", "unnamed"})
public final class StandaloneFramework
implements IJFramework {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MockApplication app;
    @NotNull
    private final Project project;

    public StandaloneFramework(boolean stopExecutor) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable()");
        this.disposable = disposable;
        this.app = new MockApplication(this.getDisposable());
        ApplicationManager.setApplication(this.app, this.getDisposable());
        PluginManagerCore.setPluginSet(new PluginSetBuilder(SetsKt.emptySet()).createPluginSetWithEnabledModulesMap());
        if (stopExecutor) {
            Disposer.register(this.getDisposable(), 1.INSTANCE);
        }
        this.project = new MockProject(null, this.getDisposable());
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        return this.disposable;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        Intrinsics.checkNotNullParameter(serviceInterface, "serviceInterface");
        Intrinsics.checkNotNullParameter(serviceImplementation, "serviceImplementation");
        this.app.registerService(serviceInterface, serviceImplementation);
    }

    @Override
    public void close() {
        Disposer.dispose(this.getDisposable());
    }
}

